/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.Cursor;
import com.ibm.cics.server.DTCTerminal;
import com.ibm.cics.server.DataHolder;
import com.ibm.cics.server.EndOfChainIndicatorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidTerminalIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAllocatedException;
import com.ibm.cics.server.TCTUAHolder;
import com.ibm.cics.server.Terminal;
import com.ibm.cics.server.TerminalException;
import com.ibm.cics.server.TerminalSendBits;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class TerminalPrincipalFacility
extends Terminal
implements TerminalSendBits {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2001, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private byte[] TERMCODE;
    private int TCTUAlength;
    private byte[] TCTUAP;

    TerminalPrincipalFacility(String name, String netname) throws NullPointerException, InvalidTerminalIdException {
        super(name, netname);
        if (name == null) {
            throw new NullPointerException("null terminal name");
        }
        if (name.length() == 0) {
            throw new InvalidTerminalIdException("empty terminal name", 0);
        }
        DTCTerminal.getCommonData(this);
    }

    TerminalPrincipalFacility(String name) throws NullPointerException, InvalidTerminalIdException {
        super(name);
        if (name == null) {
            throw new NullPointerException("null terminal name");
        }
        if (name.length() == 0) {
            throw new InvalidTerminalIdException("empty terminal name", 0);
        }
        DTCTerminal.getCommonData(this);
    }

    public void clear() throws InvalidRequestException {
        this.erase();
    }

    public void converse(DataHolder data) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        DTCTerminal.SEND(data.getValue(), false, false, false, false, false, false);
        DTCTerminal.RECEIVE(data, false, false, this.getCursor());
    }

    public void converseASIS(DataHolder data) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        DTCTerminal.SEND(data.getValue(), false, false, false, false, false, false);
        DTCTerminal.RECEIVE(data, true, false, this.getCursor());
    }

    public void erase() throws InvalidRequestException {
        DTCTerminal.SEND_CONTROL(null, false, true, false, false, false, false, false);
    }

    @Override
    protected byte[] getNextCOMMAREA() {
        byte[] c = super.getNextCOMMAREA();
        return c;
    }

    @Override
    protected String getNextTransaction() {
        String s = super.getNextTransaction();
        return s;
    }

    @Override
    protected Channel getNextChannel() {
        return super.getNextChannel();
    }

    public void getTCTUA(TCTUAHolder holder) {
        if (holder == null) {
            throw new NullPointerException("null holder in TerminalPrincipalFacility.getTCTUA()");
        }
        if (this.TCTUAlength == 0) {
            holder.value = new byte[0];
        } else {
            DTCTerminal.ADDRESS_TCTUA(holder, this.TCTUAP, this.TCTUAlength);
        }
    }

    public byte[] getTERMCODE() {
        return this.TERMCODE;
    }

    public void receive(DataHolder data) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        DTCTerminal.RECEIVE(data, false, false, this.getCursor());
    }

    public void receiveASIS(DataHolder data) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        DTCTerminal.RECEIVE(data, true, false, this.getCursor());
    }

    public void receiveBuffer(DataHolder data) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        DTCTerminal.RECEIVE(data, false, true, this.getCursor());
    }

    public void receiveBufferASIS(DataHolder data) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        DTCTerminal.RECEIVE(data, true, true, this.getCursor());
    }

    public void send(byte[] data) throws InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        DTCTerminal.SEND(data, false, false, false, false, false, false);
    }

    public void send(byte[] data, BitSet options) throws InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean frset = false;
        boolean wait = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        frset = options.get(4);
        wait = options.get(5);
        DTCTerminal.SEND(data, alarm, erase, freekb, print, frset, wait);
    }

    public void sendControl(Cursor cursor) throws InvalidRequestException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean eraseaup = false;
        boolean formfeed = false;
        boolean frset = false;
        DTCTerminal.SEND_CONTROL(cursor, alarm, erase, freekb, print, eraseaup, formfeed, frset);
    }

    public void sendControl(Cursor cursor, BitSet options) throws InvalidRequestException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean eraseaup = false;
        boolean formfeed = false;
        boolean frset = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        eraseaup = options.get(4);
        formfeed = options.get(5);
        frset = options.get(6);
        DTCTerminal.SEND_CONTROL(cursor, alarm, erase, freekb, print, eraseaup, formfeed, frset);
    }

    public void sendControl(BitSet options) throws InvalidRequestException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean eraseaup = false;
        boolean formfeed = false;
        boolean frset = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        eraseaup = options.get(4);
        formfeed = options.get(5);
        frset = options.get(6);
        DTCTerminal.SEND_CONTROL(null, alarm, erase, freekb, print, eraseaup, formfeed, frset);
    }

    public void sendText(byte[] text) throws InvalidRequestException, LengthErrorException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean formfeed = false;
        boolean nleom = false;
        DTCTerminal.SEND_TEXT(text, null, alarm, erase, freekb, print, formfeed, nleom);
    }

    public void sendText(byte[] text, Cursor cursor) throws InvalidRequestException, LengthErrorException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean formfeed = false;
        boolean nleom = false;
        DTCTerminal.SEND_TEXT(text, cursor, alarm, erase, freekb, print, formfeed, nleom);
    }

    public void sendText(byte[] text, Cursor cursor, BitSet options) throws InvalidRequestException, LengthErrorException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean formfeed = false;
        boolean nleom = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        formfeed = options.get(4);
        nleom = options.get(5);
        DTCTerminal.SEND_TEXT(text, cursor, alarm, erase, freekb, print, formfeed, nleom);
    }

    public void sendText(byte[] text, BitSet options) throws InvalidRequestException, LengthErrorException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean formfeed = false;
        boolean nleom = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        formfeed = options.get(4);
        nleom = options.get(5);
        DTCTerminal.SEND_TEXT(text, null, alarm, erase, freekb, print, formfeed, nleom);
    }

    public void sendTextString(String text) throws InvalidRequestException, LengthErrorException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean formfeed = false;
        boolean nleom = false;
        try {
            DTCTerminal.SEND_TEXT(text.getBytes(CommonConstants.LOCALCCSID), null, alarm, erase, freekb, print, formfeed, nleom);
        }
        catch (UnsupportedEncodingException e) {
            DTCTerminal.SEND_TEXT(text.getBytes(), null, alarm, erase, freekb, print, formfeed, nleom);
        }
    }

    public void sendTextString(String text, Cursor cursor) throws InvalidRequestException, LengthErrorException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean formfeed = false;
        boolean nleom = false;
        try {
            DTCTerminal.SEND_TEXT(text.getBytes(CommonConstants.LOCALCCSID), cursor, alarm, erase, freekb, print, formfeed, nleom);
        }
        catch (UnsupportedEncodingException e) {
            DTCTerminal.SEND_TEXT(text.getBytes(), cursor, alarm, erase, freekb, print, formfeed, nleom);
        }
    }

    public void sendTextString(String text, Cursor cursor, BitSet options) throws InvalidRequestException, LengthErrorException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean formfeed = false;
        boolean nleom = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        formfeed = options.get(4);
        nleom = options.get(5);
        try {
            DTCTerminal.SEND_TEXT(text.getBytes(CommonConstants.LOCALCCSID), cursor, alarm, erase, freekb, print, formfeed, nleom);
        }
        catch (UnsupportedEncodingException e) {
            DTCTerminal.SEND_TEXT(text.getBytes(), cursor, alarm, erase, freekb, print, formfeed, nleom);
        }
    }

    public void sendText(String text, BitSet options) throws InvalidRequestException, LengthErrorException {
        boolean alarm = false;
        boolean erase = false;
        boolean freekb = false;
        boolean print = false;
        boolean formfeed = false;
        boolean nleom = false;
        alarm = options.get(0);
        erase = options.get(1);
        freekb = options.get(2);
        print = options.get(3);
        formfeed = options.get(4);
        nleom = options.get(5);
        try {
            DTCTerminal.SEND_TEXT(text.getBytes(CommonConstants.LOCALCCSID), null, alarm, erase, freekb, print, formfeed, nleom);
        }
        catch (UnsupportedEncodingException e) {
            DTCTerminal.SEND_TEXT(text.getBytes(), null, alarm, erase, freekb, print, formfeed, nleom);
        }
    }

    @Override
    public void setNextCOMMAREA(byte[] nextCOMMAREA) {
        super.setNextCOMMAREA(nextCOMMAREA);
    }

    @Override
    public void setNextTransaction(String nextTransaction) {
        super.setNextTransaction(nextTransaction);
    }

    @Override
    public void setNextChannel(Channel nextChan) {
        super.setNextChannel(nextChan);
    }

    public void setTCTUA(byte[] data) throws InvalidRequestException {
        if (data == null) {
            throw new NullPointerException("null data in setTCTUA()");
        }
        if (this.TCTUAlength == 0) {
            throw new InvalidRequestException("No TCTUA to update");
        }
        DTCTerminal.UPDATE_TCTUA(data, this.TCTUAP, this.TCTUAlength);
    }

    @Deprecated
    public void waitTerminal() {
    }

    public byte getAIDbyte() {
        return DTCTerminal.GETAID();
    }
}

