/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.TransformInput;
import com.ibm.cics.server.TransformOutput;
import com.ibm.cics.server.internal.JCICSLateBinding;

public class Transform {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static TransformOutput xmlToData(TransformInput input) throws IllegalArgumentException, RecordNotFoundException, ChannelErrorException, ContainerErrorException, LengthErrorException, InvalidRequestException {
        if (input.getChannel() == null) {
            throw new IllegalArgumentException("CHANNEL not set");
        }
        if (input.getXmlContainer() == null) {
            throw new IllegalArgumentException("XMLCONTAINER not set");
        }
        String channelName = null;
        String datContainerName = null;
        String xmlContainerName = null;
        String nsContainerName = null;
        String xmltransformName = null;
        if (input.getChannel() != null) {
            channelName = input.getChannel().getName();
        }
        if (input.getDataContainer() != null) {
            datContainerName = input.getDataContainer().getName();
        }
        if (input.getXmlContainer() != null) {
            xmlContainerName = input.getXmlContainer().getName();
        }
        if (input.getNsContainer() != null) {
            nsContainerName = input.getNsContainer().getName();
        }
        if (input.getXmltransform() != null) {
            xmltransformName = input.getXmltransform().getName();
        }
        if (input.getElementName() != null) {
            input.setTypeName(null);
            input.setTypeNamespace(null);
            input.setElementName(null);
            input.setElementNamespace(null);
        }
        JCICSLateBinding.bindTaskIfRequired();
        TransformOutput output = Transform.XMLTODATA(channelName, datContainerName, input.getTypeName(), input.getTypeNamespace(), xmlContainerName, xmltransformName, nsContainerName);
        return output;
    }

    public static TransformOutput dataToXML(TransformInput input) throws IllegalArgumentException, RecordNotFoundException, ChannelErrorException, ContainerErrorException, LengthErrorException, InvalidRequestException {
        if (input.getChannel() == null) {
            throw new IllegalArgumentException("CHANNEL not set");
        }
        if (input.getXmlContainer() == null) {
            throw new IllegalArgumentException("XMLCONTAINER not set");
        }
        if (input.getXmltransform() == null) {
            throw new IllegalArgumentException("XMLTRANSFORM not set");
        }
        String channelName = null;
        String datContainerName = null;
        String xmlContainerName = null;
        String xmltransformName = null;
        if (input.getChannel() != null) {
            channelName = input.getChannel().getName();
        }
        if (input.getDataContainer() != null) {
            datContainerName = input.getDataContainer().getName();
        }
        if (input.getXmlContainer() != null) {
            xmlContainerName = input.getXmlContainer().getName();
        }
        if (input.getXmltransform() != null) {
            xmltransformName = input.getXmltransform().getName();
        }
        JCICSLateBinding.bindTaskIfRequired();
        return Transform.DATATOXML(channelName, datContainerName, input.getElementName(), input.getElementNamespace(), input.getTypeName(), input.getTypeNamespace(), xmlContainerName, xmltransformName);
    }

    private static final native TransformOutput XMLTODATA(String var0, String var1, String var2, String var3, String var4, String var5, String var6) throws RecordNotFoundException, ChannelErrorException, ContainerErrorException, LengthErrorException, InvalidRequestException;

    private static final native TransformOutput DATATOXML(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws RecordNotFoundException, ChannelErrorException, ContainerErrorException, LengthErrorException, InvalidRequestException;
}

