/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.CCSIDErrorException;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.internal.JCICSLateBinding;
import java.util.HashMap;
import java.util.Map;

public class WSAContext
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2008, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int FROMEPR = 850;
    public static final int TOEPR = 851;
    public static final int REPLYTOEPR = 852;
    public static final int FAULTTOEPR = 853;
    public static final int REQCONTEXT = 854;
    public static final int RESPCONTEXT = 855;
    private static final int IALL = 856;
    private static final int IMETADATA = 857;
    private static final int IREFPARMS = 858;
    private static final int IADDRESS = 859;
    private String channel;
    private String natlang;

    public static void delete(String channel) throws InvalidRequestException, ChannelErrorException, RecordNotFoundException {
        if (channel == null || channel.equals("")) {
            throw new IllegalStateException("Null or empty Channel name");
        }
        JCICSLateBinding.bindTaskIfRequired();
        WSAContext.DELETE(channel);
    }

    public void delete() throws IllegalStateException, InvalidRequestException, ChannelErrorException, RecordNotFoundException {
        if (this.channel == null || this.channel.equals("")) {
            throw new IllegalStateException("Channel name not supplied");
        }
        JCICSLateBinding.bindTaskIfRequired();
        WSAContext.DELETE(this.channel);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getNationalLang() {
        return this.natlang;
    }

    public void setNationalLang(String natlang) {
        this.natlang = natlang;
    }

    public String getAction(int contextType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        String action = null;
        if (contextType != 854 && contextType != 855) {
            throw new IllegalArgumentException("Context type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        action = WSAContext.GETACTION(contextType, chn, this.natlang);
        if (action != null) {
            action = action.trim();
        }
        return action;
    }

    public void setAction(String action) throws InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        WSAContext.BUILD(chn, action, null, null, null, 0, 0, null, this.natlang);
    }

    public String getMessageId(int contextType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        String messageId = null;
        if (contextType != 854 && contextType != 855) {
            throw new IllegalArgumentException("Context type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        messageId = WSAContext.GETMESSAGEID(contextType, chn, this.natlang);
        if (messageId != null) {
            messageId = messageId.trim();
        }
        return messageId;
    }

    public void setMessageId(String messageId) throws InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        WSAContext.BUILD(chn, null, messageId, null, null, 0, 0, null, this.natlang);
    }

    public Map<String, String> getRelatesTo(int contextType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        HashMap<String, String> relatesTo = new HashMap<String, String>();
        String rString = null;
        if (contextType != 854 && contextType != 855) {
            throw new IllegalArgumentException("Context type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        for (int i = 1; i <= 1024; ++i) {
            try {
                rString = WSAContext.GETRELATES(contextType, chn, i, this.natlang);
                relatesTo.put(rString.substring(0, 255).trim(), rString.substring(255).trim());
                continue;
            }
            catch (InvalidRequestException ex) {
                if (ex.getRESP2() == 12) break;
                throw ex;
            }
        }
        return relatesTo;
    }

    public void setRelatesTo(String relatesURI, String relatesType) throws InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        WSAContext.BUILD(chn, null, null, relatesURI, relatesType, 0, 0, null, this.natlang);
    }

    public void setRelatesTo(String relatesURI) throws InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        WSAContext.BUILD(chn, null, null, relatesURI, null, 0, 0, null, this.natlang);
    }

    public String getEprAddress(int contextType, int eprType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        int index1;
        String address = "http://www.w3.org/2005/08/addressing/anonymous";
        String epr = this.getEpr(contextType, eprType);
        if (epr != null && (index1 = epr.indexOf(":Address>")) > -1) {
            int index2 = epr.substring(index1 += ":Address>".length()).indexOf(":Address>");
            while (epr.charAt(index1 + index2) != '<') {
                --index2;
            }
            address = epr.substring(index1, index1 + index2);
        }
        return address;
    }

    public void setEprAddress(int eprType, String address) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        if (eprType != 851 && eprType != 850 && eprType != 852 && eprType != 853) {
            throw new IllegalArgumentException("EPR type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        WSAContext.BUILD(chn, null, null, null, null, eprType, 859, address, this.natlang);
    }

    public String getEprRefParms(int contextType, int eprType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        int index1;
        String refParms = null;
        String epr = this.getEpr(contextType, eprType);
        if (epr != null && (index1 = epr.indexOf(":ReferenceParameters>")) > -1) {
            int index2 = epr.substring(index1 += ":ReferenceParameters>".length()).lastIndexOf(":ReferenceParameters>");
            while (epr.charAt(index1 + index2) != '<') {
                --index2;
            }
            refParms = epr.substring(index1, index1 + index2);
        }
        return refParms;
    }

    public void setEprRefParms(int eprType, String refparms) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        if (eprType != 851 && eprType != 850 && eprType != 852 && eprType != 853) {
            throw new IllegalArgumentException("EPR type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        WSAContext.BUILD(chn, null, null, null, null, eprType, 858, refparms, this.natlang);
    }

    public String getEprMetadata(int contextType, int eprType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        int index1;
        String metadata = null;
        String epr = this.getEpr(contextType, eprType);
        if (epr != null && (index1 = epr.indexOf(":Metadata>")) > -1) {
            int index2 = epr.substring(index1 += ":Metadata>".length()).lastIndexOf(":Metadata>");
            while (epr.charAt(index1 + index2) != '<') {
                --index2;
            }
            metadata = epr.substring(index1, index1 + index2);
        }
        return metadata;
    }

    public void setEprMetadata(int eprType, String metadata) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        if (eprType != 851 && eprType != 850 && eprType != 852 && eprType != 853) {
            throw new IllegalArgumentException("EPR type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        WSAContext.BUILD(chn, null, null, null, null, eprType, 857, metadata, this.natlang);
    }

    public String getEpr(int contextType, int eprType) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, RecordNotFoundException, ChannelErrorException {
        String epr = null;
        if (contextType != 854 && contextType != 855) {
            throw new IllegalArgumentException("Context type not valid");
        }
        if (eprType != 851 && eprType != 850 && eprType != 852 && eprType != 853) {
            throw new IllegalArgumentException("EPR type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        epr = WSAContext.GETEPR(contextType, chn, eprType, 856, this.natlang);
        return epr;
    }

    public void setEpr(int eprType, String epr) throws IllegalArgumentException, InvalidRequestException, CCSIDErrorException, ChannelErrorException {
        if (eprType != 851 && eprType != 850 && eprType != 852 && eprType != 853) {
            throw new IllegalArgumentException("EPR type not valid");
        }
        String chn = this.channel;
        if (chn != null && chn.equals("")) {
            chn = null;
        }
        JCICSLateBinding.bindTaskIfRequired();
        WSAContext.BUILD(chn, null, null, null, null, eprType, 856, epr, this.natlang);
    }

    private static final native void BUILD(String var0, String var1, String var2, String var3, String var4, int var5, int var6, String var7, String var8) throws InvalidRequestException, CCSIDErrorException;

    private static final native String GETEPR(int var0, String var1, int var2, int var3, String var4) throws InvalidRequestException, CCSIDErrorException, RecordNotFoundException;

    private static final native String GETRELATES(int var0, String var1, int var2, String var3) throws InvalidRequestException, CCSIDErrorException, RecordNotFoundException;

    private static final native String GETACTION(int var0, String var1, String var2) throws InvalidRequestException, CCSIDErrorException, RecordNotFoundException;

    private static final native String GETMESSAGEID(int var0, String var1, String var2) throws InvalidRequestException, CCSIDErrorException, RecordNotFoundException;

    private static final native void DELETE(String var0) throws InvalidRequestException, ChannelErrorException, RecordNotFoundException;
}

