/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.InvalidRequestException;

class WebInfo
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NOTSET = -1;
    private String httpMethod;
    private String httpVersion;
    private int requestType = -1;
    private String path;
    private String queryString;
    private String host;
    private String urimap;
    private int scheme = -1;
    private int portNumber = -1;
    private int hostType = -1;
    public static final int NOTAPPLIC = 1;
    public static final int IPV4 = 300;
    public static final int IPV6 = 301;
    public static final int HOSTNAME = 302;
    public static final int HTTPYES = 1033;
    public static final int HTTPNO = 1034;
    public static final int HTTP = 1096;
    public static final int HTTPS = 1029;

    private native void EXTRACT() throws InvalidRequestException;

    WebInfo() {
    }

    public String getHttpMethod() throws InvalidRequestException {
        if (this.httpMethod == null) {
            this.EXTRACT();
        }
        return this.httpMethod;
    }

    public String getHttpVersion() throws InvalidRequestException {
        if (this.httpVersion == null) {
            this.EXTRACT();
        }
        return this.httpVersion;
    }

    public String getRequestType() throws InvalidRequestException {
        String rType;
        if (this.requestType == -1) {
            this.EXTRACT();
        }
        switch (this.requestType) {
            case 1033: {
                rType = "HTTPYES";
                break;
            }
            default: {
                rType = "HTTPNO";
            }
        }
        return rType;
    }

    public boolean isDataHttp() throws InvalidRequestException {
        boolean httpData = false;
        if (this.requestType == -1) {
            this.EXTRACT();
        }
        if (this.requestType == 1033) {
            httpData = true;
        }
        return httpData;
    }

    public String getPath() throws InvalidRequestException {
        if (this.path == null) {
            this.EXTRACT();
        }
        return this.path;
    }

    public String getQueryString() throws InvalidRequestException {
        if (this.queryString == null) {
            this.EXTRACT();
        }
        return this.queryString;
    }

    public String getHost() throws InvalidRequestException {
        if (this.host == null) {
            this.EXTRACT();
        }
        return this.host;
    }

    public boolean isSchemeHttp() throws InvalidRequestException {
        boolean httpScheme = false;
        if (this.scheme == -1) {
            this.EXTRACT();
        }
        if (this.scheme == 1096) {
            httpScheme = true;
        }
        return httpScheme;
    }

    public boolean isSchemeHttps() throws InvalidRequestException {
        boolean httpsScheme = false;
        if (this.scheme == -1) {
            this.EXTRACT();
        }
        if (this.scheme == 1029) {
            httpsScheme = true;
        }
        return httpsScheme;
    }

    public String getScheme() throws InvalidRequestException {
        String rScheme;
        if (this.scheme == -1) {
            this.EXTRACT();
        }
        switch (this.scheme) {
            case 1029: {
                rScheme = "HTTPS";
                break;
            }
            default: {
                rScheme = "HTTP";
            }
        }
        return rScheme;
    }

    public String getUrimap() throws InvalidRequestException {
        if (this.urimap == null) {
            this.EXTRACT();
        }
        return this.urimap;
    }

    public int getPortNumber() throws InvalidRequestException {
        if (this.portNumber == -1) {
            this.EXTRACT();
        }
        return this.portNumber;
    }

    public int getHostType() throws InvalidRequestException {
        if (this.hostType == -1) {
            this.EXTRACT();
        }
        return this.hostType;
    }

    protected void resetObject() {
        this.httpMethod = null;
        this.httpVersion = null;
        this.requestType = -1;
        this.path = null;
        this.queryString = null;
        this.host = null;
        this.urimap = null;
        this.scheme = -1;
        this.portNumber = -1;
    }
}

