/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.NonHttpDataException;
import com.ibm.cics.server.RecordNotFoundException;

class WebReceive
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int NOTSET = -1;
    private static final int TRUNCATEYES = -1;
    private static final int TRUNCATENO = -2;
    private static final int NONHTTPDATAEXCEPTIONYES = -1;
    private static final int NONHTTPDATAEXCEPTIONNO = -2;
    private static final int BODYCOMPLETE = 0;
    private static final int BODYTRUNCATED = 1;
    private static final int BODYPARTIAL = 2;
    private static final int DEFAULTMAXLENGTH = Short.MAX_VALUE;
    private String characterset;
    private String hostCodePage;
    private int serverConvert = -1;
    private int maxLength = Short.MAX_VALUE;
    private int truncate = -1;
    private int bodyState = -1;
    private int nonHttpDataException = -1;
    private String bodyCharset;
    private String mediaType;
    private static final int SRVCONVERT = 738;
    private static final int NOSRVCONVERT = 739;

    private native void RECCONT(String var1, String var2, String var3) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException;

    private native byte[] RECEIVE(String var1, String var2, int var3, int var4, int var5, int var6) throws InvalidRequestException, RecordNotFoundException, NonHttpDataException;

    WebReceive() {
    }

    protected void setServerConvert() {
        this.serverConvert = 738;
    }

    protected void setNoServerConvert() {
        this.serverConvert = 739;
        this.characterset = null;
        this.hostCodePage = null;
    }

    protected void setCharacterset(String characterset) {
        this.characterset = characterset;
        this.serverConvert = 738;
    }

    protected void setHostCodePage(String hostCodePage) {
        this.hostCodePage = hostCodePage;
        this.serverConvert = 738;
    }

    protected void setNoTruncate() {
        this.truncate = -2;
    }

    protected void setTruncate() {
        this.truncate = -1;
    }

    protected void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    protected void setNonHttpDataExceptionYes() {
        this.nonHttpDataException = -1;
    }

    protected void setNonHttpDataExceptionNo() {
        this.nonHttpDataException = -2;
    }

    protected byte[] receive() throws InvalidRequestException, RecordNotFoundException, NonHttpDataException {
        return this.RECEIVE(this.hostCodePage, this.characterset, this.serverConvert, this.maxLength, this.truncate, this.nonHttpDataException);
    }

    protected void receiveContainer(String toContainer, String toChannel) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException {
        this.RECCONT(this.characterset, toContainer, toChannel);
    }

    protected boolean isBodyComplete() {
        boolean bodyComplete = false;
        if (this.bodyState == 0) {
            bodyComplete = true;
        }
        return bodyComplete;
    }

    protected boolean isBodyTruncated() {
        boolean bodyTruncated = false;
        if (this.bodyState == 1) {
            bodyTruncated = true;
        }
        return bodyTruncated;
    }

    protected boolean isBodyPartial() {
        boolean bodyPartial = false;
        if (this.bodyState == 2) {
            bodyPartial = true;
        }
        return bodyPartial;
    }

    protected String getBodyCharset() throws InvalidRequestException {
        if (this.bodyCharset == null) {
            throw new InvalidRequestException("getContent() or getContentAsContainer() not called");
        }
        return this.bodyCharset.trim();
    }

    protected String getMediaType() throws InvalidRequestException {
        if (this.mediaType == null) {
            throw new InvalidRequestException("getContent() or getContentAsContainer() not called");
        }
        return this.mediaType.trim();
    }

    protected void resetObject() {
        this.characterset = null;
        this.hostCodePage = null;
        this.serverConvert = -1;
        this.maxLength = Short.MAX_VALUE;
        this.truncate = -1;
        this.bodyState = -1;
        this.nonHttpDataException = -1;
        this.bodyCharset = null;
        this.mediaType = null;
    }
}

