/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.Channel;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.Resource;
import com.ibm.cics.server.TimedOutException;
import com.ibm.cics.server.URIMap;

public class WebService
extends Resource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2004, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 4389824957186735041L;
    private static final int MAX_NAME_LEN = 32;
    private static final int MAX_URI_NAME_LEN = 255;
    private static final int MAX_OP_NAME_LEN = 255;
    private static final int MAX_URIMAP_NAME_LEN = 8;
    private String scope;

    public void invoke(Channel theChannel, String operationName) throws RecordNotFoundException, InvalidRequestException, TimedOutException, LengthErrorException {
        this.invoke(theChannel, operationName, null, null);
    }

    public void invoke(Channel theChannel, String operationName, String uri) throws RecordNotFoundException, InvalidRequestException, TimedOutException, LengthErrorException {
        this.invoke(theChannel, operationName, uri, null);
    }

    public void invoke(Channel theChannel, String operationName, URIMap urimap) throws RecordNotFoundException, InvalidRequestException, TimedOutException, LengthErrorException {
        this.invoke(theChannel, operationName, null, urimap);
    }

    private void invoke(Channel theChannel, String operationName, String uri, URIMap urimap) throws RecordNotFoundException, InvalidRequestException, TimedOutException, LengthErrorException {
        String webServiceName;
        if (operationName == null) {
            operationName = "";
        }
        if ((webServiceName = this.getName()).length() > 32) {
            webServiceName = webServiceName.substring(0, 32);
        }
        String urimapString = null;
        StringBuilder ub = null;
        if (urimap != null) {
            ub = new StringBuilder(urimap.getName());
            ub.setLength(8);
            for (int i = 7; i >= 0 && ub.charAt(i) == '\u0000'; --i) {
                ub.setCharAt(i, ' ');
            }
            urimapString = ub.toString();
        }
        StringBuilder sb = new StringBuilder(webServiceName);
        sb.setLength(32);
        for (int i = 31; i >= 0 && sb.charAt(i) == '\u0000'; --i) {
            sb.setCharAt(i, ' ');
        }
        if (operationName.length() > 255) {
            operationName = operationName.substring(0, 255);
        }
        if (uri != null && uri.length() > 255) {
            uri = uri.substring(0, 255);
        }
        this.INVOKE(sb.toString(), theChannel.getName(), operationName, uri, urimapString, this.scope);
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    private final native void INVOKE(String var1, String var2, String var3, String var4, String var5, String var6) throws RecordNotFoundException, InvalidRequestException, TimedOutException, LengthErrorException;
}

