/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.common.CommonLogger;
import com.ibm.cics.common.CommonUtils;
import com.ibm.cics.common.ThreadStopper;
import com.ibm.cics.domains.Dfhsjjsj;
import com.ibm.cics.domains.Dfhsjthj;
import com.ibm.cics.domains.DomainResponse;
import com.ibm.cics.osgi.ICICSClassProxy;
import com.ibm.cics.osgi.ICICSDB2SQLJDriverClassService;
import com.ibm.cics.ras.CICSRas;
import com.ibm.cics.ras.RASInitializationProtector;
import com.ibm.cics.ras.server.WrapperHelper;
import com.ibm.cics.server.AbendCancelException;
import com.ibm.cics.server.AbendError;
import com.ibm.cics.server.AbendException;
import com.ibm.cics.server.CICSExecutorService;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.CicsConditionException;
import com.ibm.cics.server.CommAreaHolder;
import com.ibm.cics.server.DTC;
import com.ibm.cics.server.DTCProgram;
import com.ibm.cics.server.EndOfProgramException;
import com.ibm.cics.server.IsCICS;
import com.ibm.cics.server.OutputRedirectionPlugin;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.TerminalPrincipalFacility;
import com.ibm.cics.server.TransferOfControlException;
import com.ibm.cics.server.debug.DebugImpl;
import com.ibm.cics.server.internal.OSGiWrapper;
import com.ibm.cics.server.internal.ShutdownResponder;
import com.ibm.lang.management.GarbageCollectorMXBean;
import com.ibm.lang.management.MemoryMXBean;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Wrapper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2001, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) ,COM1-201903161811 %I% %E% %U%";
    private static final String jcicsNativeLib = "com_ibm_cics_server_DTC";
    private static final String COMPONENT = Wrapper.class.getPackage().getName();
    private static final String CLASS_NAME = Wrapper.class.getSimpleName();
    private static final int LOCATION_FREE = 0;
    private static final int LOCATION_JAVA = 1;
    private static final int LOCATION_CICS = 2;
    private static final String applid;
    public static final int MAIN_METHOD = 0;
    public static final int LINKABLE = 1;
    public static final int RUNNABLE = 2;
    public static final int CALLABLE = 3;
    private static ThreadLocal<String> debugPrefix;
    private static Class<?> outClass;
    private static Class<?> errClass;
    private static OutputStream oStream;
    private static OutputStream eStream;
    private static PrintStream originalSTDOUT;
    private static PrintStream originalSTDERR;
    private static boolean checkedIfOSGi;
    private static boolean isOSGi;
    public static final Class<?>[] MAIN_STRING_ARRAY_PARAMETERS;
    public static final Class<?>[] MAIN_COMMAREA_PARAMETERS;
    public static PrintStream outHandler;
    public static PrintStream errHandler;
    public static final int UNABLE_TO_DETERMINE_STATUS = -1;
    public static final int NOT_CICS_REGION = 0;
    public static final int CICS_REGION_BUT_API_DISALLOWED = 1;
    public static final int CICS_REGION_AND_API_ALLOWED = 2;
    private static DebugImpl plugins;
    private static Map<Long, Thread> runningDSTasks;
    private static List<Task> runningTasks;
    private static final String thisClassName = "com.ibm.cics.server.Wrapper";
    private static final String TID_1 = "WRAPPER_1";
    private static final String TID_2 = "WRAPPER_2";
    private static final String TID_3 = "WRAPPER_3";
    private static final String TID_JDBC_PRE_CALL = "JDBC_PRE_CALL_";
    private static final String TID_JDBC_POST_CALL = "JDBC_POST_CALL_";
    private static final String TID_WRAPPER_TIDYUP = "WRAPPER_TIDYUP";
    private static Class<?> JDBC_class;
    private static Class<?> CICSRecoveryStarterClass;
    private static String fullJavaVersion;
    private static boolean libertyVersionShown;
    static ClassLoader contextCL;
    private static ICICSDB2SQLJDriverClassService cicsDB2SQLJDriverClassService;

    protected void bindCICSDB2SQLJDriverClassService(ICICSDB2SQLJDriverClassService cicsDB2SQLJDriverClassService) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntryExit("bindCICSDB2SQLJDriverClassService", 'D', "");
        }
        Wrapper.cicsDB2SQLJDriverClassService = cicsDB2SQLJDriverClassService;
    }

    public static void route(byte[] args1, byte[][] args2, int sjTraceLevel) {
        CommonLogger.setTraceLevel((int)sjTraceLevel);
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("route", 'D');
        }
        try {
            Dfhsjthj plist = new Dfhsjthj(args1, args2);
            Thread thisThread = Thread.currentThread();
            switch (plist.getFunction()) {
                case 12: {
                    thisThread.setName("PURGE_KILL_JVMSERVER_" + thisThread.getName());
                    if (plist.getExistence(49)) {
                        thisThread.setName("PURGE_KILL_JVMSERVER_" + thisThread.getName());
                        byte[] tranbytes = plist.getTrannum();
                        String unpacked = CommonUtils.packedToUnpacked((byte[])tranbytes);
                        Wrapper.jvmServerTaskTerminate(unpacked);
                        break;
                    }
                    Wrapper.jvmServerTerminate(null);
                    break;
                }
                case 13: {
                    thisThread.setName("JVMSERVER_STATISTICS_" + thisThread.getName());
                    Wrapper.jvmServerStats(null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected function: " + plist.getFunction());
                }
            }
        }
        catch (Throwable t) {
            Wrapper.logError("route", 'E', "experienced a problem", t);
            throw t;
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("route", 'D');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void addTask(Task theTask) {
        Object object;
        if (runningTasks == null) {
            object = sccsid;
            // MONITORENTER : "@(#) ,COM1-201903161811 %I% %E% %U%"
            if (runningTasks == null) {
                runningTasks = new ArrayList<Task>(100);
            }
            // MONITOREXIT : object
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEvent("addTask", 'D', "Task = " + theTask.getTaskNumber());
        }
        object = runningTasks;
        // MONITORENTER : object
        runningTasks.add(theTask);
        // MONITOREXIT : object
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDSTask(long threadId) {
        if (runningDSTasks == null) {
            runningDSTasks = new ConcurrentHashMap<Long, Thread>(8, 0.9f, 1);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEvent("addDSTask", 'D', "cicsPoolThreadId = " + threadId);
        }
        Map<Long, Thread> map = runningDSTasks;
        synchronized (map) {
            runningDSTasks.put(threadId, Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTask(Task theTask) {
        if (runningTasks != null) {
            if (Wrapper.shouldTrace('D')) {
                Wrapper.logEvent("removeTask", 'D', "Task = " + theTask.getTaskNumber());
            }
            List<Task> list = runningTasks;
            synchronized (list) {
                runningTasks.remove(theTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDSTask(long threadId) {
        if (runningDSTasks != null) {
            Thread removedThread;
            Map<Long, Thread> map = runningDSTasks;
            synchronized (map) {
                removedThread = runningDSTasks.remove(threadId);
            }
            if (Wrapper.shouldTrace('D') && removedThread != null) {
                Wrapper.logEvent("removeDSTask", 'D', "cicsPoolThreadId = " + threadId + ", Thread name = " + removedThread.getName());
            }
        }
    }

    private static boolean ibmJVMTidyUp() {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("ibmJVMTidyUp", 'D');
        }
        if (Wrapper.collectingTrace()) {
            CICSRas.getTraceService().trace(2048L, thisClassName, TID_WRAPPER_TIDYUP, "ibmJVMTidyUp");
        }
        try {
            if (outHandler != null) {
                outHandler.flush();
            }
            if (errHandler != null) {
                errHandler.flush();
            }
        }
        catch (Exception exc) {
            CICSRas.getTraceService().exception(thisClassName, TID_WRAPPER_TIDYUP, (Throwable)exc);
        }
        Task.resetTask();
        DTC.Cleanup();
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("ibmJVMTidyUp", 'D');
        }
        return true;
    }

    private static boolean isActiveDB2SQLJJDBC(Task currentTask) {
        if (Wrapper.shouldTrace('D')) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            Wrapper.logEntry("isActiveDB2SQLJJDBC", 'D', "Task = " + taskNum);
        }
        if (currentTask == null) {
            currentTask = Task.getTask();
        }
        if (currentTask.getDB2SQLJJDBCActive()) {
            if (Wrapper.shouldTrace('D')) {
                Wrapper.logExit("isActiveDB2SQLJDBC", 'D', "true");
            }
            return true;
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("isActiveDB2SQLJJDBC", 'D', "false");
        }
        return false;
    }

    private static int callJDBCStaticVoid(String method) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("callJDBCStaticVoid", 'D', method);
        }
        Class[] void_parameter = new Class[]{};
        Object[] no_parameters = new Object[]{};
        ApplicationResponse.ReturnCode rc = ApplicationResponse.ReturnCode.SUCCESS;
        try {
            if (JDBC_class == null) {
                JDBC_class = contextCL == null ? (cicsDB2SQLJDriverClassService != null && cicsDB2SQLJDriverClassService.getDriverClass() != null ? cicsDB2SQLJDriverClassService.getDriverClass() : Class.forName("COM.ibm.db2os390.sqlj.jdbc.DB2SQLJDriver")) : contextCL.loadClass("COM.ibm.db2os390.sqlj.jdbc.DB2SQLJDriver");
            }
            try {
                Method JDBC_void_method = JDBC_class.getMethod(method, void_parameter);
                try {
                    JDBC_void_method.invoke(JDBC_class, no_parameters);
                }
                catch (Exception e) {
                    rc = ApplicationResponse.ReturnCode.JDBC_STATIC_INVOKE_METHOD_FAILED;
                    if (Wrapper.collectingTrace()) {
                        CICSRas.getTraceService().exception(thisClassName, "callJDBCStaticVoid", (Throwable)e);
                    }
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                rc = ApplicationResponse.ReturnCode.JDBC_STATIC_GET_METHOD_FAILED;
                if (Wrapper.collectingTrace()) {
                    CICSRas.getTraceService().exception(thisClassName, "callJDBCStaticVoid", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            rc = ApplicationResponse.ReturnCode.JDBC_STATIC_GET_CLASS_FAILED;
            if (Wrapper.collectingTrace()) {
                CICSRas.getTraceService().exception(thisClassName, "callJDBCStaticVoid", (Throwable)e);
            }
            e.printStackTrace();
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("callJDBCStaticVoid", 'D', "rc = " + (Object)((Object)rc));
        }
        return rc.getNumericValue();
    }

    public static boolean collectingTrace() {
        return RASInitializationProtector.passTraceToCICS();
    }

    public static int isSQLJPropSet() {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("isSQLPropSet", 'D');
        }
        if (!Wrapper.isActiveDB2SQLJJDBC(null)) {
            if (Wrapper.shouldTrace('D')) {
                Wrapper.logExit("isSQLPropSet", 'D', "false");
            }
            return 0;
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("isSQLPropSet", 'D', "true");
        }
        return 1;
    }

    private static ApplicationResponse call_main(Class<?> userClass, Object argsType, Method cachedMainMethod) throws NoSuchMethodException {
        boolean isStringArgs = argsType instanceof String[];
        if (Wrapper.shouldTrace('D')) {
            if (isStringArgs) {
                Wrapper.logEntry("call_main", 'D', "userClass = " + userClass + ", args = " + Arrays.toString((String[])argsType));
            } else {
                Wrapper.logEntry("call_main", 'D', "UserClass = " + userClass + ", CAH = " + argsType + ", Method = " + cachedMainMethod);
            }
        }
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.SUCCESS);
        Method method = cachedMainMethod;
        try {
            if (isStringArgs) {
                method = userClass.getMethod("main", MAIN_STRING_ARRAY_PARAMETERS);
            } else if (method == null) {
                method = userClass.getMethod("main", MAIN_COMMAREA_PARAMETERS);
            }
            try {
                Object[] args = new Object[]{argsType};
                String className = userClass.getName();
                String methodName = method.getName();
                plugins.callPluginsStart(className, methodName);
                method.invoke(null, args);
                plugins.callPluginsStop(className, methodName);
            }
            catch (IllegalAccessException IAE) {
                response.setThrown(IAE);
                response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
            }
            catch (IllegalArgumentException IAE) {
                response.setThrown(IAE);
                response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
            }
            catch (InvocationTargetException ITE) {
                response = Wrapper.checkRealException(ITE);
            }
            catch (NullPointerException NPE) {
                response.setThrown(NPE);
                response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
            }
            catch (ExceptionInInitializerError EIIE) {
                EIIE.printStackTrace(System.err);
                CICSRas.getTraceService().exception(thisClassName, "call_main", (Throwable)EIIE);
                response.setThrown(EIIE.getException());
                CICSRas.getMessageService().msg(2L, thisClassName, "call_main", "CICS_MESSAGE SJ 903", "", (Object)EIIE.toString(), (Object)userClass.getName());
                response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
            }
        }
        catch (SecurityException SE) {
            response.setThrown(SE);
            response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("call_main", 'D', "rc = " + (Object)((Object)response.getReturnCode()));
        }
        return response;
    }

    public static void callUserClass(String[] args, Task currentTask) throws AbendException, AbendCancelException, ThreadDeath {
        String s;
        Object o;
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("callUserClass", 'D', "args = " + args + ", Task = " + currentTask.getTaskNumber());
        }
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.SUCCESS);
        String userClassName = "unknown";
        CommAreaHolder CAH = new CommAreaHolder();
        boolean inputCommArea = true;
        Class<?> userClass = null;
        if (args.length < 1 || args[0].length() == 0) {
            Wrapper.SetAbend("AJ0" + ApplicationResponse.ReturnCode.INVALID_ARGUMENTS.getNumericValue(), false);
            response.setReturnCode(ApplicationResponse.ReturnCode.INVALID_ARGUMENTS);
        }
        if (Wrapper.collectingTrace()) {
            CICSRas.getTraceService().entry(thisClassName, "callUserClass", (Object)args[0]);
        }
        Thread.currentThread().setName(currentTask.getThreadName());
        CAH.value = Wrapper.GetCommArea(null, null);
        if (CAH.value == null) {
            inputCommArea = false;
            CAH.value = new byte[0];
        }
        try {
            userClassName = args[0].replace('/', '.');
            userClass = contextCL.loadClass(userClassName);
            try {
                if (Wrapper.collectingTrace()) {
                    CICSRas.getTraceService().trace(4096L, thisClassName, "callUserClass", TID_2, (Object)userClassName);
                }
                if ((response = Wrapper.call_main(userClass, CAH, null)).getReturnCode() == ApplicationResponse.ReturnCode.SUCCESS) {
                    if (inputCommArea) {
                        Wrapper.SetCommArea(null, null, CAH.value);
                    }
                    CAH.value = null;
                }
            }
            catch (NoSuchMethodException main_cah_e) {
                try {
                    Object[] userArgs = new String[]{};
                    if (Wrapper.collectingTrace()) {
                        CICSRas.getTraceService().trace(4096L, thisClassName, "callUserClass", TID_3, userArgs);
                    }
                    response = Wrapper.call_main(userClass, userArgs, null);
                }
                catch (NoSuchMethodException main_e) {
                    response.setThrown(main_e);
                    response.setReturnCode(ApplicationResponse.ReturnCode.NO_SUCH_METHOD_ERROR);
                }
            }
            catch (NoSuchMethodError NSME) {
                response.setThrown(NSME);
                response.setReturnCode(ApplicationResponse.ReturnCode.NO_SUCH_METHOD_ERROR);
            }
        }
        catch (ClassNotFoundException CNFE) {
            response.setThrown(CNFE);
            response.setReturnCode(ApplicationResponse.ReturnCode.NO_CLASS_DEF_FOUND_ERROR);
        }
        catch (Throwable th) {
            response.setThrown(th);
            response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
        }
        userClass = null;
        if (response.getReturnCode() != ApplicationResponse.ReturnCode.SUCCESS) {
            Wrapper.handleReturnCode(response, userClassName, 0);
        }
        if ((o = currentTask.getPrincipalFacility()) instanceof TerminalPrincipalFacility && (s = ((TerminalPrincipalFacility)o).getNextTransaction()) != null) {
            TerminalPrincipalFacility term = (TerminalPrincipalFacility)o;
            term.setNextTransaction(null);
            Channel nextChan = term.getNextChannel();
            byte[] commArea = term.getNextCOMMAREA();
            if (nextChan != null && commArea != null) {
                Wrapper.SetAbendForCondition(CicsConditionException.RESPCODE.INVREQ.getValue());
            }
            if (nextChan != null) {
                DTCProgram.RETURN(s, null, nextChan.getName());
            } else {
                DTCProgram.RETURN(s, commArea, null);
            }
        }
        if (Wrapper.collectingTrace()) {
            CICSRas.getTraceService().exit(thisClassName, "callUserClass", (Object)userClassName);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("callUserClass", 'D');
        }
    }

    public static void handleReturnCode(ApplicationResponse response, String userClassName, int callType) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("handleReturnCode", 'D');
        }
        Throwable localThrown = response.getThrown();
        ApplicationResponse.ReturnCode rc = response.getReturnCode();
        if (localThrown != null) {
            CICSRas.getTraceService().exception(thisClassName, "handleReturnCode", localThrown);
            if (localThrown instanceof IllegalArgumentException) {
                CICSRas.getMessageService().msg(1L, thisClassName, "handleReturnCode", "CICS_MESSAGE SJ 905", "", (Object)userClassName);
            }
            if (callType == 1) {
                CICSRas.getMessageService().msg(2L, thisClassName, "handleReturnCode", "CICS_MESSAGE SJ 926", "", (Object)localThrown.toString(), (Object)userClassName);
            } else {
                CICSRas.getMessageService().msg(2L, thisClassName, "handleReturnCode", "CICS_MESSAGE SJ 904", "", (Object)localThrown.toString(), (Object)userClassName);
            }
        }
        if (rc == ApplicationResponse.ReturnCode.ABEND_RECEIVED_AND_SET) {
            if (localThrown instanceof AbendException) {
                throw (AbendException)localThrown;
            }
            if (localThrown instanceof ThreadDeath) {
                throw (ThreadDeath)localThrown;
            }
            if (localThrown instanceof AbendCancelException) {
                throw (AbendCancelException)localThrown;
            }
        }
        if (CommonConstants.THREADPOOL_ACTIVE && Wrapper.getApiStatus(false) != 2) {
            if (Wrapper.shouldTrace('D')) {
                Wrapper.logExit("handleReturnCode", 'D', "No TRANSACTION to abend");
            }
            return;
        }
        if (rc.getNumericValue() < 10) {
            Wrapper.SetAbend("AJ0" + rc.getNumericValue(), false);
        } else {
            Wrapper.SetAbend("AJ" + rc.getNumericValue(), false);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("handleReturnCode", 'D');
        }
    }

    private static void terminateTask(Task theTask) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntryExit("terminateTask", 'D', "Thread.stop(TASK) = " + theTask.getTaskNumber());
        }
        try {
            theTask.getTaskThread().stop();
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }

    public static void set_jvmserver_disabling(String[] args) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntryExit("set_jvmserver_disabling", 'D', "");
        }
        Wrapper.DtcMarkJvmserverDisabling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void terminateAllTasks() {
        Object object;
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("terminateAllTasks", 'D');
        }
        if (runningTasks == null && runningDSTasks == null) {
            if (Wrapper.shouldTrace('D')) {
                Wrapper.logExit("terminateAllTasks", 'D', "none to terminate");
            }
            return;
        }
        Task currentTask = null;
        if (runningTasks != null) {
            object = runningTasks;
            synchronized (object) {
                ListIterator<Task> it = runningTasks.listIterator();
                while (it.hasNext()) {
                    currentTask = it.next();
                    if (Wrapper.DtcGetThreadLocation(currentTask.getThreadPosition()) != 1) continue;
                    Wrapper.terminateTask(currentTask);
                    it.remove();
                }
            }
        }
        if (runningDSTasks != null) {
            object = runningDSTasks;
            synchronized (object) {
                Collection<Thread> threads = runningDSTasks.values();
                Iterator<Thread> it = threads.iterator();
                while (it.hasNext()) {
                    Thread theThread = it.next();
                    if (Wrapper.shouldTrace('D')) {
                        Wrapper.logEvent("terminateAllTasks", 'D', "Thread.stop(DS_TASK) = " + theThread.getName() + ":" + (Object)((Object)theThread.getState()));
                    }
                    try {
                        theThread.stop();
                    }
                    catch (ThreadDeath td) {
                        // empty catch block
                    }
                    it.remove();
                }
            }
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("terminateAllTasks", 'D');
        }
    }

    private static ApplicationResponse checkRealException(InvocationTargetException ITE) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("checkRealException", 'D', "Exception = " + ITE);
        }
        ApplicationResponse response = null;
        try {
            response = Wrapper.interpretUserException(ITE.getCause());
        }
        catch (NoClassDefFoundError e) {
            e.initCause(ITE);
            response = new ApplicationResponse(ApplicationResponse.ReturnCode.NO_CLASS_DEF_FOUND_ERROR);
            response.setThrown(e);
            Wrapper.logError("checkRealException", 'E', "", e);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("checkRealException", 'D');
        }
        return response;
    }

    public static ApplicationResponse interpretUserException(Throwable userException) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("interpretUserException", 'D', "Exception = " + userException);
        }
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.INVOCATION_TARGET_EXCEPTION);
        response.setThrown(userException);
        if (userException instanceof AbendError) {
            response.setReturnCode(ApplicationResponse.ReturnCode.ABEND_RECEIVED);
        } else if (userException instanceof CicsConditionException) {
            try {
                if (Wrapper.getApiStatus(false) == 2) {
                    Wrapper.SetAbendForCondition(((CicsConditionException)userException).getRESPCode().getValue());
                }
            }
            catch (RuntimeException re) {
                re.initCause(userException);
                throw re;
            }
            response.setReturnCode(ApplicationResponse.ReturnCode.CONDITION_RECEIVED);
        } else if (userException instanceof AbendException) {
            try {
                Wrapper.SetAbend(((AbendException)userException).getABCODE(), false);
            }
            catch (RuntimeException e) {
                response.setReturnCode(ApplicationResponse.ReturnCode.ABEND_RECEIVED_AND_SET);
            }
        } else if (userException instanceof AbendCancelException) {
            try {
                Wrapper.SetAbend(((AbendCancelException)userException).getABCODE(), true);
            }
            catch (RuntimeException e) {
                response.setReturnCode(ApplicationResponse.ReturnCode.ABEND_RECEIVED_AND_SET);
            }
        } else if (userException instanceof EndOfProgramException) {
            response.setReturnCode(ApplicationResponse.ReturnCode.SUCCESS);
        } else if (userException instanceof TransferOfControlException) {
            response.setReturnCode(ApplicationResponse.ReturnCode.SUCCESS);
        } else if (userException instanceof ThreadDeath) {
            response.setReturnCode(ApplicationResponse.ReturnCode.ABEND_RECEIVED_AND_SET);
        } else {
            response.setReturnCode(ApplicationResponse.ReturnCode.INVOCATION_TARGET_EXCEPTION);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("interpretUserException", 'D', "rc = " + (Object)((Object)response.getReturnCode()));
        }
        return response;
    }

    public static void jvmServerWrapperEntry(String[] args) {
        if (Wrapper.shouldTrace('D')) {
            debugPrefix.set("[" + Thread.currentThread().getName() + "] ");
            Wrapper.logEntry("jvmServerWrapperEntry", 'D', "args = " + Arrays.toString(args));
        }
        Task currentTask = Wrapper.initWrapper();
        Wrapper.jvmServerProcessArgs(currentTask);
        try {
            Wrapper.invokeJvmServerUserClass(args, currentTask);
        }
        catch (Throwable t) {
            Wrapper.logError("jvmServerWrapperEntry", 'E', "Problem detected", t);
            throw t;
        }
        finally {
            Wrapper.driveTidyUp(currentTask);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("jvmServerWrapperEntry", 'D');
        }
    }

    public static void jvmServerStats(String[] args) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("jvmServerStats", 'D');
        }
        String gcPolicy = "not detected";
        long current_heap = 0L;
        long initial_heap = 0L;
        long max_heap = 0L;
        long peak_heap = 0L;
        long major_gc_events = 0L;
        long major_gc_elapsed_time = 0L;
        long major_heap_freed = 0L;
        long minor_gc_events = 0L;
        long minor_gc_elapsed_time = 0L;
        long minor_heap_freed = 0L;
        long heap_occupancy = 0L;
        MemoryMXBean memoryBean = (MemoryMXBean)ManagementFactory.getMemoryMXBean();
        gcPolicy = memoryBean.getGCMode();
        List<java.lang.management.GarbageCollectorMXBean> gcBeanList = ManagementFactory.getGarbageCollectorMXBeans();
        String gcName = null;
        for (java.lang.management.GarbageCollectorMXBean theBean : gcBeanList) {
            GarbageCollectorMXBean bean = (GarbageCollectorMXBean)theBean;
            gcName = bean.getName();
            if (gcName.equalsIgnoreCase("Copy") || gcName.equalsIgnoreCase("scavenge")) {
                minor_gc_events = bean.getCollectionCount();
                minor_gc_elapsed_time = bean.getCollectionTime();
                minor_heap_freed = bean.getTotalMemoryFreed();
                continue;
            }
            major_gc_events = bean.getCollectionCount();
            major_gc_elapsed_time = bean.getCollectionTime();
            major_heap_freed = bean.getTotalMemoryFreed();
        }
        List<MemoryPoolMXBean> poolBeanList = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean theBean : poolBeanList) {
            com.ibm.lang.management.MemoryPoolMXBean bean = (com.ibm.lang.management.MemoryPoolMXBean)theBean;
            if (bean.getType() != MemoryType.HEAP) continue;
            MemoryUsage use = bean.getUsage();
            initial_heap += use.getInit();
            max_heap += use.getMax();
            current_heap += use.getUsed();
            MemoryUsage peakUse = bean.getPeakUsage();
            peak_heap += peakUse.getUsed();
            MemoryUsage occupancyUse = bean.getCollectionUsage();
            if (occupancyUse == null) continue;
            heap_occupancy += occupancyUse.getUsed();
        }
        Dfhsjjsj sjjs = new Dfhsjjsj();
        try {
            sjjs.setFunction((byte)11);
            sjjs.setJvmserver(CommonConstants.JVMSERVER_NAME);
            sjjs.setInitHeap(initial_heap);
            sjjs.setCurrentHeap(current_heap);
            sjjs.setMaxHeap(max_heap);
            sjjs.setPeakHeap(peak_heap);
            sjjs.setOccupancy(heap_occupancy);
            sjjs.setGcpolicy(gcPolicy);
            sjjs.setMajorGcEvents((int)major_gc_events);
            sjjs.setMajorGcCpu(major_gc_elapsed_time);
            sjjs.setMajorHeapFreed(major_heap_freed);
            sjjs.setMinorGcEvents((int)minor_gc_events);
            sjjs.setMinorGcCpu(minor_gc_elapsed_time);
            sjjs.setMinorHeapFreed(minor_heap_freed);
            sjjs.invoke();
        }
        catch (DomainResponse dr) {
            dr.printStackTrace(System.err);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("jvmServerStats", 'D');
        }
    }

    public static void jvmServerTerminate(String[] args) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("jvmServerTerminate", 'D', "args = " + Arrays.toString(args));
        }
        Wrapper.terminateAllTasks();
        if (CommonConstants.IS_LIBERTY) {
            ThreadStopper.terminateThreads((ThreadStopper.ThreadTypes)ThreadStopper.ThreadTypes.NonDaemon);
        } else if (Wrapper.shouldTrace('D')) {
            Wrapper.logEvent("jvmServerTerminate", 'D', "ThreadStopper bypassed");
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("jvmServerTerminate", 'D');
        }
    }

    public static void jvmServerTaskTerminate(String trannum) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("jvmServerTaskTerminate", 'D', "trannum = " + trannum);
        }
        for (Task task : runningTasks) {
            int tasknum = task.getTaskNumber();
            if (tasknum != Integer.parseInt(trannum)) continue;
            if (Wrapper.shouldTrace('D')) {
                Wrapper.logEvent("jvmServerTaskTerminate", 'D', "terminating TASK = " + tasknum);
            }
            Wrapper.terminateTask(task);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("jvmServerTaskTerminate", 'D');
        }
    }

    public static void startJTARecovery() {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("startJTARecovery", 'D');
        }
        Class[] void_parameter = new Class[]{};
        Object[] no_parameters = new Object[]{};
        Task currentTask = Wrapper.initOSGiWrapper();
        try {
            CICSRecoveryStarterClass = Class.forName("com.ibm.cics.jta.util.CICSRecoveryStarter");
            try {
                Method startRecoveryMethod = CICSRecoveryStarterClass.getMethod("startRecovery", void_parameter);
                try {
                    startRecoveryMethod.invoke(CICSRecoveryStarterClass, no_parameters);
                }
                catch (Exception e) {
                    Wrapper.logError("startJTARecovery", 'E', "", e);
                }
            }
            catch (Exception e) {
                Wrapper.logError("startJTARecovery", 'E', "", e);
            }
        }
        catch (Exception e) {
            Wrapper.logError("startJTARecovery", 'E', "", e);
        }
        Wrapper.driveTidyUp(currentTask);
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("startJTARecovery", 'D');
        }
    }

    public static int getApiStatus(boolean lateBind) {
        return IsCICS.getApiStatus(lateBind);
    }

    public static Task threadPoolBindDTC(byte[] originData, byte[] transactionGroupID) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("threadPoolBindDTC", 'D');
        }
        Task t = Wrapper.initOSGiWrapper();
        t.setOriginData(originData, transactionGroupID);
        Wrapper.addTask(t);
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("threadPoolBindDTC", 'D');
        }
        return t;
    }

    public static void threadPoolUnbindDTC(Task currentTask) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("threadPoolUnbindDTC", 'D');
        }
        Wrapper.driveTidyUp(currentTask);
        Wrapper.removeTask(currentTask);
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("threadPoolUnbindDTC", 'D');
        }
    }

    public static void main(String[] args) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("main", 'D', "args = " + Arrays.toString(args));
        }
        if (Wrapper.shouldTrace('D')) {
            debugPrefix.set("[" + Thread.currentThread().getName() + "] ");
        }
        Task currentTask = Wrapper.initWrapper();
        Wrapper.processArgs(args, currentTask);
        Wrapper.invokeUserClass(args, currentTask);
        Wrapper.driveTidyUp(currentTask);
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("main", 'D');
        }
    }

    private static Task initWrapper() {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("initWrapper", 'D');
        }
        RASInitializationProtector.reset();
        if (contextCL == null) {
            contextCL = Thread.currentThread().getContextClassLoader();
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEvent("initWrapper", 'D', "contextCL = " + contextCL.toString());
        }
        if (fullJavaVersion == null) {
            if (CommonConstants.DISPLAY_JAVA_VERSION) {
                fullJavaVersion = CommonConstants.JAVA_FULLVERSION;
                CICSRas.getMessageService().msg(1L, thisClassName, "initWrapper", "CICS_MESSAGE SJ 901", "", (Object)CommonConstants.JVMSERVER_NAME, (Object)fullJavaVersion);
            } else {
                fullJavaVersion = "NOT REQUESTED";
            }
        }
        Task currentTask = Task.getTask();
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEvent("initWrapper", 'D', "Task object = " + currentTask.getTaskNumber());
        }
        if (originalSTDOUT == null) {
            originalSTDOUT = System.out;
        }
        if (originalSTDERR == null) {
            originalSTDERR = System.err;
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("initWrapper", 'D');
        }
        return currentTask;
    }

    private static Task initOSGiWrapper() {
        RASInitializationProtector.reset();
        if (fullJavaVersion == null) {
            if (CommonConstants.DISPLAY_JAVA_VERSION) {
                fullJavaVersion = CommonConstants.JAVA_FULLVERSION;
                CICSRas.getMessageService().msg(1L, thisClassName, "initWrapper", "CICS_MESSAGE SJ 901", "", (Object)CommonConstants.JVMSERVER_NAME, (Object)fullJavaVersion);
            } else {
                fullJavaVersion = "NOT REQUESTED";
            }
        }
        if (CommonConstants.IS_LIBERTY && !libertyVersionShown) {
            File wlpReadMeFile = new File(CommonConstants.WLP_INSTALL_DIR + "/README.TXT");
            String wlpVersionString = null;
            String errorMessage = null;
            try {
                Scanner scanner = new Scanner(wlpReadMeFile);
                if (scanner.hasNext()) {
                    wlpVersionString = scanner.nextLine();
                } else {
                    errorMessage = "File " + wlpReadMeFile.getAbsolutePath() + " is empty";
                    Wrapper.logError("initOSGGiWrapper", 'E', "Unable to determine Liberty version. " + errorMessage, null);
                }
                scanner.close();
            }
            catch (FileNotFoundException e) {
                errorMessage = "Exception occured: " + e.getMessage();
                Wrapper.logError("initOSGGiWrapper", 'E', "Unable to determine Liberty version from " + wlpReadMeFile.getAbsolutePath(), e);
            }
            if (wlpVersionString != null) {
                String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
                CICSRas.getMessageService().msg(1L, thisClassName, "initOSGiWrapper", "CICS_MESSAGE SJ 1405", "", new Object[]{CommonConstants.JVMSERVER_NAME, wlpVersionString, pid});
                Logger LOGGER = Logger.getLogger(Wrapper.class.getName());
                LOGGER.logp(Level.INFO, Wrapper.class.getName(), "initOSGGiWrapper", "DFHSJ1405I: " + wlpVersionString);
                if (Wrapper.shouldTrace('D')) {
                    Wrapper.logEvent("initOSGGiWrapper", 'D', wlpVersionString);
                }
            } else {
                CICSRas.getMessageService().msg(1L, thisClassName, "initOSGiWrapper", "CICS_MESSAGE SJ 1406", "", new Object[]{CommonConstants.JVMSERVER_NAME, errorMessage});
            }
            libertyVersionShown = true;
        }
        Task currentTask = Task.getTask();
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEvent("initOSGGiWrapper", 'D', "Task object = " + currentTask.getTaskNumber());
        }
        if (originalSTDOUT == null) {
            originalSTDOUT = System.out;
        }
        if (originalSTDERR == null) {
            originalSTDERR = System.err;
        }
        return currentTask;
    }

    private static void processArgs(String[] args, Task currentTask) {
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.SUCCESS);
        if (Wrapper.shouldTrace('D')) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            Wrapper.logEntry("processArgs", 'D', "Task = " + taskNum + " args = " + Arrays.toString(args));
        }
        if (!checkedIfOSGi) {
            checkedIfOSGi = true;
            ClassLoader wrapperClassLoader = Wrapper.class.getClassLoader();
            HashSet superclasses = new HashSet();
            Wrapper.getSuperClassesAndInterfaces(wrapperClassLoader.getClass(), superclasses);
            for (Class clazz : superclasses) {
                if (!"org.osgi.framework.BundleReference".equals(clazz.getName())) continue;
                isOSGi = true;
                break;
            }
        }
        if (args.length > 1 && args[1].length() != 0) {
            String outClassName = args[1].replace('/', '.');
            try {
                if (outHandler == null) {
                    if (isOSGi) {
                        oStream = OSGiWrapper.getOutputRedirectionPlugin(outClassName);
                        if (oStream == null) {
                            throw new ClassNotFoundException(outClassName);
                        }
                        outClass = oStream.getClass();
                        oStream = (OutputStream)outClass.newInstance();
                    } else {
                        outClass = Class.forName(outClassName);
                        oStream = (OutputStream)outClass.newInstance();
                    }
                    outHandler = new PrintStream(oStream);
                    if (Wrapper.collectingTrace()) {
                        CICSRas.getTraceService().trace(4096L, thisClassName, "callOutputRedirectionPlugin", outClassName, (Object)"stdout");
                    }
                    System.out.flush();
                    System.setOut(outHandler);
                }
                if (oStream instanceof OutputRedirectionPlugin && currentTask != null) {
                    boolean ignored = ((OutputRedirectionPlugin)((Object)oStream)).initRedirect("stdout", originalSTDOUT, applid, currentTask.getProgramName(), currentTask.getTaskNumberInteger(), currentTask.getTransactionName());
                }
            }
            catch (ClassNotFoundException CNFE) {
                response.setThrown(CNFE);
                CICSRas.getTraceService().exception(thisClassName, "callOutputRedirectionPlugin", (Throwable)CNFE);
                CICSRas.getMessageService().msg(4L, thisClassName, "callOutputRedirectionPlugin", "CICS_MESSAGE SJ 906", "", (Object)outClassName);
                CNFE.printStackTrace(System.err);
            }
            catch (Exception exc) {
                response.setThrown(exc);
                CICSRas.getMessageService().msg(4L, thisClassName, "callOutputRedirectionPlugin", "CICS_MESSAGE SJ 907", "", (Object)outClassName, (Object)exc);
                exc.printStackTrace();
            }
        }
        if (args.length > 2 && args[2].length() != 0) {
            String errClassName = args[2].replace('/', '.');
            try {
                if (errHandler == null) {
                    if (isOSGi) {
                        eStream = OSGiWrapper.getOutputRedirectionPlugin(errClassName);
                        if (eStream == null) {
                            throw new ClassNotFoundException(errClassName);
                        }
                        errClass = eStream.getClass();
                        eStream = (OutputStream)errClass.newInstance();
                    } else {
                        errClass = Class.forName(errClassName);
                        eStream = (OutputStream)errClass.newInstance();
                    }
                    errHandler = new PrintStream(eStream);
                    if (Wrapper.collectingTrace()) {
                        CICSRas.getTraceService().trace(4096L, thisClassName, "callOutputRedirectionPlugin", errClassName, (Object)"stderr");
                    }
                    System.err.flush();
                    System.setErr(errHandler);
                }
                if (eStream instanceof OutputRedirectionPlugin && currentTask != null) {
                    boolean ignored = ((OutputRedirectionPlugin)((Object)eStream)).initRedirect("stderr", originalSTDERR, applid, currentTask.getProgramName(), currentTask.getTaskNumberInteger(), currentTask.getTransactionName());
                }
            }
            catch (ClassNotFoundException CNFE) {
                response.setThrown(CNFE);
                CICSRas.getTraceService().exception(thisClassName, "callOutputRedirectionPlugin", (Throwable)CNFE);
                CICSRas.getMessageService().msg(1L, thisClassName, "callOutputRedirectionPlugin", "CICS_MESSAGE SJ 906", "", (Object)errClassName);
                CNFE.printStackTrace(System.err);
            }
            catch (Exception exc) {
                response.setThrown(exc);
                CICSRas.getMessageService().msg(4L, thisClassName, "callOutputRedirectionPlugin", "CICS_MESSAGE SJ 907", "", (Object)errClassName, (Object)exc);
                exc.printStackTrace();
            }
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("processArgs", 'D');
        }
    }

    private static void getSuperClassesAndInterfaces(Class<?> class1, Set<Class<?>> superclasses) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("getSuperClassesAndInterfaces", 'D');
        }
        for (Class<?> interface1 : class1.getInterfaces()) {
            superclasses.add(interface1);
            Wrapper.getSuperClassesAndInterfaces(interface1, superclasses);
        }
        Class<?> superclass = class1.getSuperclass();
        if (superclass != null) {
            superclasses.add(superclass);
            Wrapper.getSuperClassesAndInterfaces(superclass, superclasses);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("getSuperClassesAndInterfaces", 'D');
        }
    }

    private static void jvmServerProcessArgs(Task currentTask) {
        String arg0;
        if (Wrapper.shouldTrace('D')) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            Wrapper.logEntry("jvmServerProcessArgs", 'D', "Task = " + taskNum);
        }
        if ((arg0 = System.getProperty("com.ibm.cics.userOutputClass")) == null) {
            return;
        }
        String arg1 = arg0;
        String arg2 = arg0;
        String[] mockArgs = new String[]{arg0, arg1, arg2};
        Wrapper.processArgs(mockArgs, currentTask);
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("jvmServerProcessArgs", 'D');
        }
    }

    private static void invokeUserClass(String[] args, Task currentTask) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("invokeUserClass", 'D', "Task = " + currentTask.getTaskNumber() + ", args = " + Arrays.toString(args));
        }
        plugins = new DebugImpl(thisClassName, "com.ibm.cics.server.debug.WrapperPlugin", "CICS_MESSAGE SJ 906", "CICS_MESSAGE SJ 907", null);
        plugins.initializeGlobalPlugins();
        Wrapper.callUserClass(args, currentTask);
        plugins.callPluginsExit();
        Thread.currentThread().setContextClassLoader(contextCL);
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("invokeUserClass", 'D');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeJvmServerUserClass(String[] args, Task currentTask) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("invokeJvmServerUserClass", 'D', "Task = " + currentTask.getTaskNumber());
        }
        plugins = new DebugImpl(thisClassName, "com.ibm.cics.server.debug.WrapperPlugin", "CICS_MESSAGE SJ 906", "CICS_MESSAGE SJ 907", null);
        try {
            plugins.initializeGlobalPlugins();
            Wrapper.addTask(currentTask);
            Wrapper.callUserClass(args, currentTask);
        }
        finally {
            Wrapper.removeTask(currentTask);
            plugins.callPluginsExit();
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("invokeJvmServerUserClass", 'D');
        }
    }

    private static void driveTidyUp(Task currentTask) {
        if (Wrapper.shouldTrace('D')) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            Wrapper.logEntry("driveTidyUp", 'D', "Task = " + taskNum);
        }
        WrapperHelper.driveTidyUp();
        if (Wrapper.isActiveDB2SQLJJDBC(currentTask)) {
            if (Wrapper.collectingTrace()) {
                CICSRas.getTraceService().trace(4096L, thisClassName, "driveTidyUp", TID_JDBC_PRE_CALL, (Object)"JDBC_pre_reset");
            }
            int rc = Wrapper.callJDBCStaticVoid("reset");
            if (Wrapper.collectingTrace()) {
                CICSRas.getTraceService().trace(4096L, thisClassName, "driveTidyUp", TID_JDBC_POST_CALL, (Object)("JDBC_post_reset. rc=" + rc));
            }
            if (rc != 0) {
                throw new RuntimeException("callJDBCStaticVoid failed with " + (Object)((Object)ApplicationResponse.ReturnCode.values()[rc]));
            }
        }
        Wrapper.ibmJVMTidyUp();
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("driveTidyUp", 'D');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jvmServerOSGiEntry(ICICSClassProxy classProxy, Method cachedMainMethod, long threadId) {
        if (Wrapper.shouldTrace('D')) {
            debugPrefix.set("[" + Thread.currentThread().getName() + "] ");
            Wrapper.logEntry("jvmServerOSGiEntry", 'D', "cicsPoolThreadId = " + threadId);
        }
        Task currentTask = null;
        if (threadId == 0L) {
            currentTask = Wrapper.initOSGiWrapper();
        }
        Wrapper.jvmServerProcessArgs(currentTask);
        try {
            Wrapper.invokeJvmServerOSGiClass(classProxy, currentTask, cachedMainMethod, threadId);
        }
        finally {
            if (threadId == 0L) {
                Wrapper.driveTidyUp(currentTask);
            }
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("jvmServerOSGiEntry", 'D');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeJvmServerOSGiClass(ICICSClassProxy classProxy, Task currentTask, Method cachedMainMethod, long threadId) {
        if (Wrapper.shouldTrace('D')) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            Wrapper.logEntry("invokeJvmServerOSGiClass", 'D', "cicsPoolThreadId = " + threadId + ", Task = " + taskNum);
        }
        plugins = new DebugImpl(thisClassName, "com.ibm.cics.server.debug.WrapperPlugin", "CICS_MESSAGE SJ 906", "CICS_MESSAGE SJ 907", classProxy.getBundle().getBundleContext());
        try {
            plugins.initializeGlobalPlugins();
            if (threadId == 0L) {
                Wrapper.addTask(currentTask);
            } else {
                Wrapper.addDSTask(threadId);
            }
            Wrapper.callOSGiClass(classProxy, currentTask, cachedMainMethod, threadId);
        }
        finally {
            if (threadId == 0L) {
                Wrapper.removeTask(currentTask);
            } else {
                Wrapper.removeDSTask(threadId);
            }
            plugins.callPluginsExit();
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("invokeJvmServerOSGiClass", 'D');
        }
    }

    private static void callOSGiClass(ICICSClassProxy classProxy, Task currentTask, Method cachedMainMethod, long threadId) throws AbendException, AbendCancelException, ThreadDeath {
        String s;
        Object o;
        if (Wrapper.shouldTrace('D')) {
            int taskNum = 0;
            if (currentTask != null) {
                taskNum = currentTask.getTaskNumber();
            }
            Wrapper.logEntry("callOSGiClass", 'D', "cicsPoolThreadId = " + threadId + ", Task = " + taskNum);
        }
        if (classProxy == null) {
            Wrapper.SetAbend("AJ0" + ApplicationResponse.ReturnCode.INVALID_ARGUMENTS.getNumericValue(), false);
            if (Wrapper.shouldTrace('D')) {
                Wrapper.logExit("callOSGiClass", 'D', "no classProxy");
            }
            return;
        }
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.SUCCESS);
        CommAreaHolder CAH = new CommAreaHolder();
        boolean inputCommArea = true;
        Class userClass = null;
        if (Wrapper.collectingTrace()) {
            CICSRas.getTraceService().entry(thisClassName, "callOSGiClass", (Object)classProxy.getClassName());
        }
        if (threadId == 0L && currentTask != null) {
            Thread.currentThread().setName(currentTask.getThreadName());
            CAH.value = Wrapper.GetCommArea(null, null);
            if (CAH.value == null) {
                inputCommArea = false;
                CAH.value = new byte[0];
            }
        }
        try {
            userClass = classProxy.getTheClass();
            try {
                if (Wrapper.collectingTrace()) {
                    CICSRas.getTraceService().trace(4096L, thisClassName, "callOSGiClass", TID_2, (Object)classProxy.getClassName());
                }
                if (threadId != 0L) {
                    inputCommArea = false;
                    String[] userArgs = new String[]{Long.toString(threadId)};
                    response = Wrapper.call_main(userClass, userArgs, null);
                } else {
                    response = Wrapper.call_main(userClass, CAH, cachedMainMethod);
                }
                if (response.getReturnCode() == ApplicationResponse.ReturnCode.SUCCESS) {
                    if (inputCommArea) {
                        Wrapper.SetCommArea(null, null, CAH.value);
                    }
                    CAH.value = null;
                }
            }
            catch (NoSuchMethodException main_cah_e) {
                try {
                    Object[] userArgs = new String[]{};
                    if (Wrapper.collectingTrace()) {
                        CICSRas.getTraceService().trace(4096L, thisClassName, "callOSGiClass", TID_3, userArgs);
                    }
                    response = Wrapper.call_main(userClass, userArgs, null);
                }
                catch (NoSuchMethodException main_e) {
                    response.setThrown(main_e);
                    response.setReturnCode(ApplicationResponse.ReturnCode.NO_SUCH_METHOD_ERROR);
                    Wrapper.logError("callOSGiClass", 'E', "", main_e);
                }
            }
            catch (NoSuchMethodError NSME) {
                response.setThrown(NSME);
                response.setReturnCode(ApplicationResponse.ReturnCode.NO_SUCH_METHOD_ERROR);
                Wrapper.logError("callOSGiClass", 'E', "", NSME);
            }
        }
        catch (ClassNotFoundException CNFE) {
            response.setThrown(CNFE);
            response.setReturnCode(ApplicationResponse.ReturnCode.NO_CLASS_DEF_FOUND_ERROR);
            Wrapper.logError("callOSGiClass", 'E', "", CNFE);
        }
        catch (Throwable th) {
            response.setThrown(th);
            response.setReturnCode(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
            Wrapper.logError("callOSGiClass", 'E', "", th);
        }
        userClass = null;
        if (response.getReturnCode() != ApplicationResponse.ReturnCode.SUCCESS) {
            Wrapper.handleReturnCode(response, classProxy.getClassName(), 0);
        }
        if (threadId == 0L && currentTask != null && (o = currentTask.getPrincipalFacility()) instanceof TerminalPrincipalFacility && (s = ((TerminalPrincipalFacility)o).getNextTransaction()) != null) {
            TerminalPrincipalFacility term = (TerminalPrincipalFacility)o;
            term.setNextTransaction(null);
            Channel nextChan = term.getNextChannel();
            byte[] commArea = term.getNextCOMMAREA();
            if (nextChan != null && commArea != null) {
                Wrapper.SetAbendForCondition(CicsConditionException.RESPCODE.INVREQ.getValue());
            }
            if (nextChan != null) {
                DTCProgram.RETURN(s, null, nextChan.getName());
            } else {
                DTCProgram.RETURN(s, commArea, null);
            }
        }
        if (Wrapper.collectingTrace()) {
            CICSRas.getTraceService().exit(thisClassName, "callOSGiClass", (Object)classProxy.getClassName());
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("callOSGiClass", 'D');
        }
    }

    public static byte[] getOriginDataForCurrentTask() {
        Task t = Task.getTask();
        return t.getOriginData();
    }

    public static byte[] getTransactionGroupId() {
        Task t = Task.getTask();
        return t.getTransactionGroupID();
    }

    private static final void logEntry(String theMethod, char level) {
        CommonLogger.logEntry((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)"", null);
    }

    private static final void logEntry(String theMethod, char level, String msg) {
        CommonLogger.logEntry((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)msg, null);
    }

    private static final void logExit(String theMethod, char level) {
        CommonLogger.logExit((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)"", null);
    }

    private static final void logExit(String theMethod, char level, String msg) {
        CommonLogger.logExit((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)msg, null);
    }

    private static final void logEvent(String theMethod, char level, String message) {
        CommonLogger.logEvent((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)message, null);
    }

    private static final void logError(String theMethod, char level, String message, Throwable t) {
        CommonLogger.logError((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)message, (Throwable)t);
    }

    private static final void logEntryExit(String theMethod, char level, String message) {
        CommonLogger.logEntryExit((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)message, null);
    }

    private static final boolean shouldTrace(char level) {
        return CommonLogger.shouldTrace((char)level);
    }

    public static ApplicationResponse interpretSystemException(Throwable systemException, String classIdentifier) {
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logEntry("interpretSystemException", 'D', "Exception = " + systemException);
        }
        ApplicationResponse response = new ApplicationResponse(ApplicationResponse.ReturnCode.UNEXPECTED_EXCEPTION);
        response.setThrown(systemException);
        if (systemException instanceof InstantiationException) {
            response.setReturnCode(ApplicationResponse.ReturnCode.CLASS_NOT_INSTANTIABLE_ERROR);
            CICSRas.getMessageService().msg(2L, thisClassName, "interpretSystemException", "CICS_MESSAGE SJ 925", "", (Object)systemException.toString(), (Object)classIdentifier);
        } else if (systemException instanceof ExceptionInInitializerError) {
            systemException.printStackTrace(System.err);
            response.setReturnCode(ApplicationResponse.ReturnCode.CLASS_NOT_INSTANTIABLE_ERROR);
            CICSRas.getTraceService().exception(thisClassName, "interpretSystemException", systemException);
            response.setThrown(systemException.getCause());
        }
        if (Wrapper.shouldTrace('D')) {
            Wrapper.logExit("interpretSystemException", 'D', "rc = " + (Object)((Object)response.getReturnCode()));
        }
        return response;
    }

    public static void setThreadPoolReady(boolean value) {
        CICSExecutorService.setThreadPoolReady(value);
    }

    private static native byte[] GetCommArea(String var0, String var1);

    private static native void SetAbend(String var0, boolean var1);

    private static native void SetAbendForCondition(int var0);

    private static native void SetCommArea(String var0, String var1, byte[] var2);

    private static native void DtcMarkJvmserverDisabling();

    private static native int DtcGetThreadLocation(int var0);

    static {
        CommonLogger.init();
        try {
            System.loadLibrary(jcicsNativeLib);
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.print("DFHCZ0399 COM.IBM.CICS.SERVER.WRAPPER - ");
            System.err.print("UNSATISFIEDLINKERROR LOADING ");
            System.err.println(jcicsNativeLib);
        }
        ShutdownResponder shutdownResponder = new ShutdownResponder();
        shutdownResponder.start();
        applid = CommonLogger.getApplid();
        debugPrefix = new ThreadLocal();
        MAIN_STRING_ARRAY_PARAMETERS = new Class[1];
        MAIN_COMMAREA_PARAMETERS = new Class[1];
        Wrapper.MAIN_STRING_ARRAY_PARAMETERS[0] = String[].class;
        Wrapper.MAIN_COMMAREA_PARAMETERS[0] = CommAreaHolder.class;
        libertyVersionShown = false;
    }

    public static class ApplicationResponse {
        private ReturnCode returnCode;
        private Throwable thrown = null;

        public ApplicationResponse(ReturnCode returnCode) {
            this.returnCode = returnCode;
        }

        public void setReturnCode(ReturnCode returnCode) {
            this.returnCode = returnCode;
        }

        public ReturnCode getReturnCode() {
            return this.returnCode;
        }

        public void setThrown(Throwable t) {
            this.thrown = t;
        }

        public Throwable getThrown() {
            return this.thrown;
        }

        public static enum ReturnCode {
            SUCCESS(0),
            INVALID_ARGUMENTS(1),
            ABEND_RECEIVED(2),
            CONDITION_RECEIVED(3),
            UNEXPECTED_EXCEPTION(4),
            INVOCATION_TARGET_EXCEPTION(5),
            NO_CLASS_DEF_FOUND_ERROR(7),
            NO_SUCH_METHOD_ERROR(9),
            JDBC_STATIC_GET_CLASS_FAILED(10),
            JDBC_STATIC_GET_METHOD_FAILED(11),
            JDBC_STATIC_INVOKE_METHOD_FAILED(12),
            CLASS_NOT_INSTANTIABLE_ERROR(13),
            ABEND_RECEIVED_AND_SET(22);

            private int numericValue;

            private ReturnCode(int numericValue) {
                this.numericValue = numericValue;
            }

            public int getNumericValue() {
                return this.numericValue;
            }
        }
    }
}

