/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.debug;

import com.ibm.cics.osgi.ICICSClassProxy;
import com.ibm.cics.ras.CICSRas;
import com.ibm.cics.ras.RASInitializationProtector;
import com.ibm.cics.server.debug.DebugControl;
import com.ibm.cics.server.debug.Plugin;
import java.beans.Beans;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;

public class DebugImpl {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2001, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Vector<Plugin> pluginList;
    private Class<?> debugControl;
    private Class<?> pluginClass;
    private String thisClassName = "unknown";
    private String pluginExceptionMessage = "unknown";
    private String pluginsEV;
    private static Hashtable<String, String> pluginsPropertyMap = new Hashtable();

    private static boolean collectingTrace() {
        return RASInitializationProtector.passTraceToCICS();
    }

    public DebugImpl(String thisClassName, String pluginProperty, String classNotFoundMessage, String pluginExceptionMessage, BundleContext bundleContext) {
        this.thisClassName = thisClassName;
        this.pluginExceptionMessage = pluginExceptionMessage;
        this.pluginsEV = pluginsPropertyMap.get(pluginProperty);
        if (this.pluginsEV == null) {
            this.pluginsEV = System.getProperty(pluginProperty);
            if (this.pluginsEV == null) {
                this.pluginsEV = "";
            }
            pluginsPropertyMap.put(pluginProperty, this.pluginsEV);
        }
        if (this.pluginsEV.length() == 0) {
            return;
        }
        this.pluginList = new Vector();
        if (DebugImpl.collectingTrace()) {
            CICSRas.getTraceService().entry(thisClassName, "constructor", (Object)pluginProperty);
        }
        boolean error_occured = false;
        StringTokenizer st = new StringTokenizer(this.pluginsEV, System.getProperty("path.separator"));
        while (st.hasMoreTokens()) {
            String plugin = st.nextToken();
            if (plugin != "") {
                Class javaClass = null;
                try {
                    if (bundleContext == null) {
                        javaClass = Class.forName(plugin);
                    } else {
                        StringBuilder stringFilter = new StringBuilder(256);
                        Filter serviceFilter = bundleContext.createFilter(stringFilter.append("(&(com.ibm.cics.mainclass.name=").append(plugin).append(")(com.ibm.cics.mainclass.duplicate=false)(com.ibm.cics.mainclass.classnotfound=false)(com.ibm.cics.mainclass.methodnotfound=false))").toString());
                        ServiceReference[] refs = bundleContext.getServiceReferences(ICICSClassProxy.class.getName(), serviceFilter.toString());
                        if (refs == null || refs.length < 1) {
                            throw new ClassNotFoundException(plugin);
                        }
                        ICICSClassProxy holder = (ICICSClassProxy)bundleContext.getService(refs[0]);
                        javaClass = holder.getTheClass();
                    }
                    Plugin p = (Plugin)javaClass.newInstance();
                    if (p != null) {
                        this.pluginList.addElement(p);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    error_occured = true;
                    CICSRas.getMessageService().msg(1L, thisClassName, "constructor", classNotFoundMessage, "", (Object)plugin);
                    CICSRas.getTraceService().exception(thisClassName, "constructor", (Throwable)cnfe);
                }
                catch (Exception e) {
                    error_occured = true;
                    CICSRas.getMessageService().msg(1L, thisClassName, "constructor", pluginExceptionMessage, "", (Object)plugin, (Object)e.toString());
                    CICSRas.getTraceService().exception(thisClassName, "constructor", (Throwable)e);
                }
            }
            try {
                this.debugControl = DebugControl.class;
                this.pluginClass = Plugin.class;
            }
            catch (Exception e) {
                CICSRas.getTraceService().exception(thisClassName, "constructor", (Throwable)e);
            }
            if (!DebugImpl.collectingTrace()) continue;
            if (error_occured) {
                CICSRas.getTraceService().exit(thisClassName, "constructor", (Object)"NOT OK");
                continue;
            }
            CICSRas.getTraceService().exit(thisClassName, "constructor", (Object)"OK");
        }
    }

    public void initializeGlobalPlugins() {
        if (this.isEmpty()) {
            return;
        }
        Enumeration<Plugin> plugins = this.pluginList.elements();
        if (DebugImpl.collectingTrace()) {
            CICSRas.getTraceService().entry(this.thisClassName, "initializeGlobalPlugins");
        }
        boolean error_occured = false;
        while (plugins.hasMoreElements()) {
            Plugin o = plugins.nextElement();
            if (!Beans.isInstanceOf(o, this.pluginClass)) continue;
            Plugin p = o;
            if (DebugImpl.collectingTrace()) {
                CICSRas.getTraceService().trace(4096L, this.thisClassName, "initializeGlobalPlugins", p.getClass().getName());
            }
            try {
                p.init();
                if (!DebugImpl.collectingTrace()) continue;
                CICSRas.getTraceService().trace(4096L, this.thisClassName, "initializeGlobalPlugins", p.getClass().getName(), (Object)"OK");
            }
            catch (Exception e) {
                error_occured = true;
                CICSRas.getMessageService().msg(1L, this.thisClassName, "initializeGlobalPlugins", this.pluginExceptionMessage, "", (Object)p.getClass().getName(), (Object)e.toString());
                CICSRas.getTraceService().exception(this.thisClassName, "initializeGlobalPlugins", (Throwable)e);
            }
        }
        if (DebugImpl.collectingTrace()) {
            if (error_occured) {
                CICSRas.getTraceService().exit(this.thisClassName, "initializeGlobalPlugins", (Object)"NOT OK");
            } else {
                CICSRas.getTraceService().exit(this.thisClassName, "initializeGlobalPlugins", (Object)"OK");
            }
        }
    }

    public void callPluginsStart(String className, String methodName) {
        if (this.isEmpty()) {
            return;
        }
        Enumeration<Plugin> plugins = this.pluginList.elements();
        if (DebugImpl.collectingTrace()) {
            CICSRas.getTraceService().entry(this.thisClassName, "callPluginsStart", (Object)className, (Object)methodName);
        }
        boolean error_occured = false;
        while (plugins.hasMoreElements()) {
            Plugin o = plugins.nextElement();
            if (!Beans.isInstanceOf(o, this.debugControl)) continue;
            DebugControl dc = (DebugControl)((Object)o);
            if (DebugImpl.collectingTrace()) {
                CICSRas.getTraceService().trace(4096L, this.thisClassName, "callPluginsStart", dc.getClass().getName());
            }
            try {
                dc.startDebug(className, methodName);
                if (!DebugImpl.collectingTrace()) continue;
                CICSRas.getTraceService().trace(4096L, this.thisClassName, "callPluginsStart", dc.getClass().getName(), (Object)"OK");
            }
            catch (Exception e) {
                error_occured = true;
                CICSRas.getMessageService().msg(1L, this.thisClassName, "callPluginsStart", this.pluginExceptionMessage, "", (Object)dc.getClass().getName(), (Object)e.toString());
                CICSRas.getTraceService().exception(this.thisClassName, "callPluginsStart", (Throwable)e);
            }
        }
        if (DebugImpl.collectingTrace()) {
            if (error_occured) {
                CICSRas.getTraceService().exit(this.thisClassName, "callPluginsStart", (Object)"NOT OK");
            } else {
                CICSRas.getTraceService().exit(this.thisClassName, "callPluginsStart", (Object)"OK");
            }
        }
    }

    public void callPluginsStop(String className, String methodName) {
        if (this.isEmpty()) {
            return;
        }
        Enumeration<Plugin> plugins = this.pluginList.elements();
        if (DebugImpl.collectingTrace()) {
            CICSRas.getTraceService().entry(this.thisClassName, "callPluginsStop", (Object)className, (Object)methodName);
        }
        boolean error_occured = false;
        while (plugins.hasMoreElements()) {
            Plugin o = plugins.nextElement();
            if (!Beans.isInstanceOf(o, this.debugControl)) continue;
            DebugControl dc = (DebugControl)((Object)o);
            if (DebugImpl.collectingTrace()) {
                CICSRas.getTraceService().trace(4096L, this.thisClassName, "callPluginsStop", dc.getClass().getName());
            }
            try {
                dc.stopDebug(className, methodName);
                if (!DebugImpl.collectingTrace()) continue;
                CICSRas.getTraceService().trace(4096L, this.thisClassName, "callPluginsStop", dc.getClass().getName(), (Object)"OK");
            }
            catch (Exception e) {
                error_occured = true;
                CICSRas.getMessageService().msg(1L, this.thisClassName, "callPluginsStop", this.pluginExceptionMessage, "", (Object)dc.getClass().getName(), (Object)e.toString());
                CICSRas.getTraceService().exception(this.thisClassName, "callPluginsStop", (Throwable)e);
            }
        }
        if (DebugImpl.collectingTrace()) {
            if (error_occured) {
                CICSRas.getTraceService().exit(this.thisClassName, "callPluginsStop", (Object)"NOT OK");
            } else {
                CICSRas.getTraceService().exit(this.thisClassName, "callPluginsStop", (Object)"OK");
            }
        }
    }

    public void callPluginsExit() {
        if (this.isEmpty()) {
            return;
        }
        Enumeration<Plugin> plugins = this.pluginList.elements();
        if (DebugImpl.collectingTrace()) {
            CICSRas.getTraceService().entry(this.thisClassName, "callPluginsExit");
        }
        boolean error_occured = false;
        while (plugins.hasMoreElements()) {
            Plugin o = plugins.nextElement();
            if (!Beans.isInstanceOf(o, this.debugControl)) continue;
            DebugControl dc = (DebugControl)((Object)o);
            if (DebugImpl.collectingTrace()) {
                CICSRas.getTraceService().trace(4096L, this.thisClassName, "callPluginsExit", dc.getClass().getName());
            }
            try {
                dc.exitDebug();
                if (!DebugImpl.collectingTrace()) continue;
                CICSRas.getTraceService().trace(4096L, this.thisClassName, "callPluginsExit", dc.getClass().getName(), (Object)"OK");
            }
            catch (Exception e) {
                error_occured = true;
                CICSRas.getMessageService().msg(1L, this.thisClassName, "callPluginsExit", this.pluginExceptionMessage, "", (Object)dc.getClass().getName(), (Object)e.toString());
                CICSRas.getTraceService().exception(this.thisClassName, "callPluginsExit", (Throwable)e);
            }
        }
        if (DebugImpl.collectingTrace()) {
            if (error_occured) {
                CICSRas.getTraceService().exit(this.thisClassName, "callPluginsExit", (Object)"NOT OK");
            } else {
                CICSRas.getTraceService().exit(this.thisClassName, "callPluginsExit", (Object)"OK");
            }
        }
    }

    public boolean isEmpty() {
        if (this.pluginList == null) {
            return true;
        }
        return this.pluginList.isEmpty();
    }
}

