/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.common.CICSThreadLocalManager;
import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.osgi.ICICSHttpRunnable;
import com.ibm.cics.osgi.ICICSThreadJoiner;
import com.ibm.cics.osgi.log.ICICSLogger;
import com.ibm.cics.server.CICSTransactionCallable;
import com.ibm.cics.server.CICSTransactionRunnable;
import com.ibm.cics.server.CICSWebAppStateHolder;
import com.ibm.cics.server.CicsThreadingRuntimeException;
import com.ibm.cics.server.FutureWrapper;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.Wrapper;
import com.ibm.cics.server.internal.CICSLogger;
import com.ibm.cics.server.internal.TrackedRunnable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.ServiceReference;

public class CICSBasicThreadFactory
implements ThreadFactory,
ICICSThreadJoiner {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static CICSLogger cicsLog = CICSLogger.getLogger();
    static final String CLASS_NAME = CICSBasicThreadFactory.class.getSimpleName();
    protected static int THREAD_JOIN_TIMEOUT;
    private static int TRIGGER_TIMEOUT;
    private static final String DEFAULT_TRANID = "CJSA";
    private static final String TRIGGER_OBJECT_NAME = "TRIGGER";
    static final String CICS_UNCLASSIFIED_USERID;
    static final String CICS_UNCLASSIFIED_TRANID;
    private ThreadGroup threadGroup;
    String executorName;
    boolean zosSecurityActive;
    protected Lock workerLock = new ReentrantLock();
    Map<Integer, Runnable> runnables = Collections.synchronizedMap(new LinkedHashMap());
    volatile boolean tidyUpRunning = false;
    Thread TIDYUP_THREAD = new Thread(CLASS_NAME + "-TidyUpThread"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        cicsLog.logDeepEvent(CLASS_NAME, "TidyUpThread", new String[]{"Entering sleep"});
                        5.sleep(THREAD_JOIN_TIMEOUT);
                        cicsLog.logDeepEvent(CLASS_NAME, "TidyUpThread", new String[]{"Woken from sleep"});
                        long currentTime = System.currentTimeMillis();
                        Map<Integer, Runnable> map = CICSBasicThreadFactory.this.runnables;
                        synchronized (map) {
                            Iterator<Integer> it = CICSBasicThreadFactory.this.runnables.keySet().iterator();
                            while (it.hasNext()) {
                                Integer taskNumber = it.next();
                                Runnable runnable = CICSBasicThreadFactory.this.runnables.get(taskNumber);
                                if (!(runnable instanceof TrackedRunnable)) continue;
                                TrackedRunnable worker = (TrackedRunnable)runnable;
                                if (currentTime <= worker.getTimestamp() + (long)THREAD_JOIN_TIMEOUT) break;
                                cicsLog.logEvent(CLASS_NAME, "TidyUpThread", "removing timed-out runnable for Task = ", taskNumber);
                                it.remove();
                                Runnable userRunnable = worker.getRunnable();
                                if (!(userRunnable instanceof ICICSHttpRunnable)) continue;
                                cicsLog.logEvent(CLASS_NAME, "TidyUpThread", "closing WLP connection for Task = ", taskNumber);
                                try {
                                    ((ICICSHttpRunnable)userRunnable).sendError(503, "Service Unavailable");
                                }
                                catch (Exception e) {
                                    cicsLog.logException(CLASS_NAME, "TidyUpThread", "tried to send Http Error", e);
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    cicsLog.logException(CLASS_NAME, "TidyUpThread", "Interrupted", e);
                    continue;
                }
                catch (RuntimeException re) {
                    cicsLog.logException(CLASS_NAME, "TidyUpThread", "RuntimeException", re);
                    throw re;
                }
                catch (Error e) {
                    cicsLog.logError(CLASS_NAME, "TidyUpThread", "An Error was thrown");
                    throw e;
                }
                break;
            }
        }
    };

    private static void loadNativeLibrary() {
        String jcicsNativeLib = "com_ibm_cics_server_DTC";
        try {
            System.loadLibrary(jcicsNativeLib);
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.print(CLASS_NAME + ".loadNativeLibrary - ");
            System.err.print("UnsatisfiedLinkError loading ");
            System.err.println(jcicsNativeLib);
        }
    }

    public CICSBasicThreadFactory() {
        this.TIDYUP_THREAD.setDaemon(true);
        cicsLog.logEntryExit(CLASS_NAME, "constructor", new Object[0]);
    }

    protected void activate(Map<String, Object> componentConfig) {
        cicsLog.logEntry(CLASS_NAME, "activate", new Object[]{componentConfig});
        this.executorName = String.valueOf(componentConfig.get("executorName"));
        this.threadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                return new ThreadGroup(CICSBasicThreadFactory.this.executorName + " Thread Group");
            }
        });
        cicsLog.logExit(CLASS_NAME, "activate", new String[0]);
    }

    protected void modified(Map<String, Object> componentConfig) {
        cicsLog.logEntry(CLASS_NAME, "modified", new Object[]{componentConfig});
        this.executorName = String.valueOf(componentConfig.get("executorName"));
        this.threadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                return new ThreadGroup(CICSBasicThreadFactory.this.executorName + " Thread Group");
            }
        });
        cicsLog.logExit(CLASS_NAME, "modified", new String[0]);
    }

    protected void deactivate() {
        cicsLog.logEntryExit(CLASS_NAME, "deactivate", new Object[0]);
        this.threadGroup = null;
    }

    protected void setSecurityActive(ServiceReference<?> dummyService) {
        cicsLog.logEntry(CLASS_NAME, "setSecurityActive", new Object[]{"ON"});
        this.zosSecurityActive = true;
    }

    protected void setSecurityInactive(ServiceReference<?> dummyService) {
        cicsLog.logEntryExit(CLASS_NAME, "setSecurityInactive", new Object[]{"OFF"});
        this.zosSecurityActive = false;
    }

    public void joinAsThread(String threadId) throws Exception {
        throw new Exception("CICSBasicThreadFactory does not support pooling with ThreadID");
    }

    public void joinAsThread() throws Throwable {
        cicsLog.logEntry(CLASS_NAME, "joinAsThread", new Object[0]);
        CICSWebAppStateHolder.setWebAppException(null);
        this.joinAsThreadInternal();
        if (CICSWebAppStateHolder.getWebAppException() != null) {
            try {
                throw CICSWebAppStateHolder.getWebAppException();
            }
            catch (Throwable throwable) {
                CICSWebAppStateHolder.remove();
                throw throwable;
            }
        }
        cicsLog.logExit(CLASS_NAME, "joinAsThread", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinAsThreadInternal() throws Exception {
        int taskId = Task.getTask().getTaskNumber();
        cicsLog.logEntry(CLASS_NAME, "joinAsThread", taskId);
        Runnable worker = null;
        Runnable trigger = null;
        Object object = this.runnables;
        synchronized (object) {
            worker = this.runnables.remove(taskId);
            if (worker == null) {
                trigger = new Runnable(){

                    @Override
                    public void run() {
                    }

                    public String toString() {
                        return CICSBasicThreadFactory.TRIGGER_OBJECT_NAME;
                    }
                };
                this.runnables.put(taskId, trigger);
                cicsLog.logEvent(CLASS_NAME, "joinAsThread", "Trigger added for 'Task Id' = ", taskId);
            }
        }
        if (trigger != null) {
            object = trigger;
            synchronized (object) {
                trigger.wait(TRIGGER_TIMEOUT);
            }
        }
        if (worker == null) {
            worker = this.runnables.remove(taskId);
            if (worker == null) {
                throw new Exception("No Runnable found for Joining Thread. Task id = " + taskId + ".");
            }
            if (TRIGGER_OBJECT_NAME.equals(worker.toString())) {
                throw new Exception("No work found for Task " + taskId + ". The work this Task was started to perform has already timed-out.");
            }
            cicsLog.logInfo(CLASS_NAME, "joinAsThread", new String[]{"work found after pause. Task id = " + taskId});
        }
        ((TrackedRunnable)worker).setThread(Thread.currentThread());
        worker.run();
        cicsLog.logExit(CLASS_NAME, "joinAsThread", new String[]{"Success"});
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        cicsLog.logEntry(CLASS_NAME, "newThread", new Object[]{runnable});
        Thread newThread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){
            int newTaskNumber = 0;
            String userid = null;
            String tranid = null;
            String uri = null;
            String clientIPAddress = null;
            int clientPort = 0;
            int clientIPFamily = 0;
            String serverIPAddress = null;
            int serverPort = 0;
            int serverIPFamily = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Thread run() {
                cicsLog.logEntry(CLASS_NAME, "newThread", new Object[]{"run"});
                if (!CICSBasicThreadFactory.this.tidyUpRunning) {
                    CICSBasicThreadFactory.this.tidyUpRunning = true;
                    CICSBasicThreadFactory.this.TIDYUP_THREAD.start();
                }
                boolean isLibertyOrigin = false;
                this.tranid = CICSBasicThreadFactory.DEFAULT_TRANID;
                if (!CommonConstants.IS_LIBERTY) {
                    if (CICS_UNCLASSIFIED_TRANID != null) {
                        this.tranid = CICS_UNCLASSIFIED_TRANID;
                    }
                    if (CICS_UNCLASSIFIED_USERID != null) {
                        this.userid = CICS_UNCLASSIFIED_USERID;
                    }
                }
                int initiatingTaskNumber = 0;
                if (Wrapper.getApiStatus(false) == 2) {
                    cicsLog.logEvent(CLASS_NAME, "newThread", new String[]{"parent thread has a CICS Task environment"});
                    try {
                        Task parent = Task.getTask();
                        initiatingTaskNumber = parent.getTaskNumber();
                        this.tranid = parent.getTransactionName();
                        this.userid = parent.getUSERID();
                    }
                    catch (Exception e) {
                        cicsLog.logEvent(CLASS_NAME, "newThread", new String[]{"parent thread is API allowed, but has no Task environment"});
                    }
                } else {
                    cicsLog.logEvent(CLASS_NAME, "newThread", new String[]{"parent thread has no Task environment"});
                    ThreadLocal localUserID = CICSThreadLocalManager.getThreadLocal((String)"localUserID");
                    if (localUserID != null) {
                        this.userid = (String)localUserID.get();
                    }
                }
                ICICSHttpRunnable cicsHttpRunnable = null;
                TrackedRunnable worker = (TrackedRunnable)runnable;
                Runnable userRunnable = worker.getRunnable();
                cicsLog.logEvent(CLASS_NAME, "newThread", "Internal runnable ", new Object[]{userRunnable});
                if (CommonConstants.IS_LIBERTY && userRunnable instanceof ICICSHttpRunnable) {
                    isLibertyOrigin = true;
                    cicsHttpRunnable = (ICICSHttpRunnable)userRunnable;
                    this.userid = cicsHttpRunnable.getUserid();
                    this.uri = cicsHttpRunnable.getURL();
                    String queryString = cicsHttpRunnable.getQueryString();
                    if (queryString != null) {
                        this.uri = this.uri + "?" + queryString;
                    }
                    this.clientIPAddress = cicsHttpRunnable.getRemoteIPAddress();
                    this.clientPort = cicsHttpRunnable.getRemotePort();
                    this.clientIPFamily = cicsHttpRunnable.getRemoteIPFamily();
                    this.serverIPAddress = cicsHttpRunnable.getLocalIPAddress();
                    this.serverPort = cicsHttpRunnable.getLocalPort();
                    this.serverIPFamily = cicsHttpRunnable.getLocalIPFamily();
                    if (ICICSLogger.shouldTrace((int)4)) {
                        cicsLog.logEvent(CLASS_NAME, "newThread", new String[]{"uri = ", this.uri, ", client IP = " + this.clientIPAddress, ", client Port = " + this.clientPort, ", client IP Family = " + this.clientIPFamily, ", server IP = " + this.serverIPAddress, ", server Port = " + this.serverPort, ", server IP Family = " + this.serverIPFamily});
                    }
                }
                if (userRunnable instanceof CICSTransactionRunnable) {
                    CICSTransactionRunnable tranRunnable = (CICSTransactionRunnable)userRunnable;
                    this.tranid = tranRunnable.getTranid();
                    cicsLog.logEvent(CLASS_NAME, "newThread", new String[]{"CICSTransactionRunnable detected, tranid='", this.tranid, "'"});
                } else if (userRunnable instanceof FutureWrapper) {
                    FutureWrapper origin = (FutureWrapper)userRunnable;
                    cicsLog.logEvent(CLASS_NAME, "newThread", "FutureTask detected", new Object[]{origin.getClass()});
                    Callable callable = origin.getCallable();
                    if (callable instanceof CICSTransactionCallable) {
                        this.tranid = ((CICSTransactionCallable)callable).getTranid();
                        cicsLog.logEvent(CLASS_NAME, "newThread", new String[]{"CICSTransactionCallable detected, tranid='", this.tranid, "'"});
                    }
                }
                worker.setTimestamp(System.currentTimeMillis());
                CicsThreadingRuntimeException threadException = null;
                try {
                    this.newTaskNumber = CICSBasicThreadFactory.createCICSThread(this.userid, this.uri, initiatingTaskNumber, isLibertyOrigin, this.clientIPAddress, this.clientPort, this.clientIPFamily, this.serverIPAddress, this.serverPort, this.serverIPFamily, CICSBasicThreadFactory.this.zosSecurityActive, this.tranid);
                }
                catch (RuntimeException r) {
                    threadException = new CicsThreadingRuntimeException(r);
                }
                if (threadException != null) {
                    if (CommonConstants.IS_LIBERTY) {
                        if (cicsHttpRunnable == null) {
                            cicsLog.logEvent(CLASS_NAME, "newThread", new String[]{"there is no CICS Http runnable, unable to return error to browser"});
                            throw threadException;
                        }
                        try {
                            cicsHttpRunnable.sendError(threadException.getHttpResponseCode());
                        }
                        catch (Exception e) {
                            cicsLog.logException(CLASS_NAME, "newThread", "failed to send error to browser", e);
                        }
                    }
                    throw threadException;
                }
                Runnable oldValue = CICSBasicThreadFactory.this.runnables.put(this.newTaskNumber, worker);
                if (oldValue != null) {
                    if (CICSBasicThreadFactory.TRIGGER_OBJECT_NAME.equals(oldValue.toString())) {
                        Runnable runnable2 = oldValue;
                        synchronized (runnable2) {
                            oldValue.notify();
                        }
                        cicsLog.logEvent(CLASS_NAME, "newThread", "trigger object found and notified for task id = ", this.newTaskNumber);
                    } else {
                        cicsLog.logError(CLASS_NAME, "newThread", "unexpected runnable found for task id = " + this.newTaskNumber);
                    }
                }
                cicsLog.logExit(CLASS_NAME, "newThread", "Task = ", this.newTaskNumber);
                return null;
            }
        });
        return newThread;
    }

    static final native int createCICSThread(String var0, String var1, int var2, boolean var3, String var4, int var5, int var6, String var7, int var8, int var9, boolean var10, String var11);

    static {
        CICS_UNCLASSIFIED_USERID = System.getProperty("com.ibm.cics.jvmserver.unclassified.userid");
        CICS_UNCLASSIFIED_TRANID = System.getProperty("com.ibm.cics.jvmserver.unclassified.tranid");
        CICSBasicThreadFactory.loadNativeLibrary();
        try {
            THREAD_JOIN_TIMEOUT = Integer.parseInt(System.getProperty("com.ibm.cics.jvmserver.threadjoin.timeout"));
        }
        catch (NumberFormatException e) {
            THREAD_JOIN_TIMEOUT = 30000;
        }
        try {
            TRIGGER_TIMEOUT = Integer.parseInt(System.getProperty("com.ibm.cics.jvmserver.trigger.timeout"));
        }
        catch (NumberFormatException e) {
            TRIGGER_TIMEOUT = 500;
        }
    }
}

