/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.server.internal.CICSLogger;
import com.ibm.cics.server.internal.TrackedRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CICSThreadPoolExecutor
extends ThreadPoolExecutor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static CICSLogger cicsLog = CICSLogger.getLogger();
    private static final String CLASS_NAME = CICSThreadPoolExecutor.class.getSimpleName();
    private ThreadFactory threadFactory;

    public CICSThreadPoolExecutor(int coreThreads, int corePoolSize, long keepAliveMillis, TimeUnit milliseconds, BlockingQueue<Runnable> workQueue, ThreadFactory cicsThreadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(corePoolSize, corePoolSize, keepAliveMillis, milliseconds, workQueue, cicsThreadFactory, rejectedExecutionHandler);
        cicsLog.logEntry(CLASS_NAME, "constructor", new Object[]{coreThreads, corePoolSize, keepAliveMillis, workQueue, cicsThreadFactory, rejectedExecutionHandler});
        this.threadFactory = cicsThreadFactory;
        cicsLog.logExit(CLASS_NAME, "constructor", new String[0]);
    }

    @Override
    public void execute(Runnable usersRunnable) throws RejectedExecutionException {
        cicsLog.logEntry(CLASS_NAME, "execute", new Object[]{usersRunnable});
        if (this.isShutdown()) {
            this.rejectedExecution(usersRunnable);
        }
        TrackedRunnable worker = new TrackedRunnable(usersRunnable);
        this.threadFactory.newThread(worker);
        cicsLog.logExit(CLASS_NAME, "execute", new String[0]);
    }

    protected <V> RunnableFuture<V> newTaskFor(Callable<V> callable) {
        return new FutureTask<V>(callable);
    }

    protected <V> RunnableFuture<V> newTaskFor(Runnable runnable, V result) {
        return new FutureTask<V>(runnable, result);
    }

    protected void rejectedExecution(Runnable r) throws RejectedExecutionException {
        throw new RejectedExecutionException();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";poolSize=").append(this.getPoolSize());
        sb.append(",activeThreads=").append(this.getActiveCount());
        sb.append(",completedTasks=").append(this.getCompletedTaskCount());
        sb.append(",workers=[");
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
    }
}

