/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.common.CommonLogger;
import com.ibm.cics.common.ThreadStopper;
import com.ibm.cics.server.Wrapper;

public class ShutdownResponder
implements Runnable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String COMPONENT = ShutdownResponder.class.getPackage().getName();
    private static final String CLASS_NAME = ShutdownResponder.class.getSimpleName();

    private final native int waitForECB();

    private final native int postResponderECB(int var1);

    public ShutdownResponder() {
        ShutdownResponder.logEvent("constructor", 'D', "SHUTDOWN_RESPONDER has been created");
    }

    public void start() {
        ShutdownResponder.logEvent("start", 'D', "Started...");
        Thread srThread = new Thread((Runnable)this, "SHUTDOWN_RESPONDER");
        srThread.setDaemon(true);
        srThread.start();
    }

    @Override
    public void run() {
        int listenerFunction = 0;
        int threadCount = 0;
        String[] functions = new String[]{"TERMINATE_THREADS", "LISTENER_EXIT", "NON_DAEMON_COUNT", "SET_JVMSERVER_DISABLING", "NON_DAEMON_COUNT_WAIT", "LISTENER_NOT_NEEDED"};
        while (listenerFunction != 1 && listenerFunction != 5) {
            ShutdownResponder.logEvent("run", 'D', "SHUTDOWN_RESPONDER waiting for request");
            listenerFunction = this.waitForECB();
            ShutdownResponder.logEvent("run", 'D', "SHUTDOWN_RESPONDER woken. Function flag = " + functions[listenerFunction]);
            if (listenerFunction == 0) {
                Wrapper.jvmServerTerminate(null);
                this.postResponderECB(0);
                continue;
            }
            if (listenerFunction == 2) {
                threadCount = ThreadStopper.countNonDaemonThreads((int)2);
                this.postResponderECB(threadCount);
                continue;
            }
            if (listenerFunction == 3) {
                Wrapper.set_jvmserver_disabling(null);
                this.postResponderECB(0);
                continue;
            }
            if (listenerFunction != 4) continue;
            threadCount = ThreadStopper.countNonDaemonThreads((int)25);
            this.postResponderECB(threadCount);
        }
        this.postResponderECB(0);
        ShutdownResponder.logEvent("run", 'D', "SHUTDOWN_RESPONDER terminated");
    }

    private static void logEvent(String theMethod, char level, String message) {
        CommonLogger.logEvent((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)message, null);
    }
}

