/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal;

import com.ibm.cics.osgi.ICICSThreadJoiner;
import com.ibm.cics.server.CommAreaHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ThreadJoiner {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static BundleContext bc;
    private static ServiceReference<?> pooledThreadFactoryRef;
    private static ServiceReference<?> basicThreadFactoryRef;
    private static ICICSThreadJoiner pooledJoiner;
    private static ICICSThreadJoiner basicJoiner;

    public static void main(String[] args) throws Throwable {
        ThreadJoiner.getPooledJoinerService().joinAsThread(args[0]);
    }

    public static void main(CommAreaHolder args) throws Throwable {
        ThreadJoiner.getBasicJoinerService().joinAsThread();
    }

    private static ICICSThreadJoiner getPooledJoinerService() throws Throwable {
        if (bc == null) {
            Bundle bund = FrameworkUtil.getBundle(ThreadJoiner.class);
            if (bund.getState() == 4) {
                bund.start();
            }
            bc = bund.getBundleContext();
        }
        if (pooledThreadFactoryRef == null) {
            String filterString = "(service.type=POOLED)";
            ServiceReference[] refs = bc.getServiceReferences("com.ibm.cics.osgi.ICICSThreadJoiner", filterString);
            if (refs.length > 1) {
                throw new Exception("Internal error: ThreadJoiner - too many matches to PooledThreadJoiner Service!");
            }
            pooledThreadFactoryRef = refs[0];
        }
        if (pooledThreadFactoryRef == null) {
            throw new Exception("Internal error: ThreadJoiner - cannot find a registered implementation of ICICSThreadJoiner from PooledThreadFactory");
        }
        if (pooledJoiner == null) {
            pooledJoiner = (ICICSThreadJoiner)bc.getService(pooledThreadFactoryRef);
        }
        return pooledJoiner;
    }

    private static ICICSThreadJoiner getBasicJoinerService() throws Throwable {
        if (bc == null) {
            Bundle bund = FrameworkUtil.getBundle(ThreadJoiner.class);
            if (bund.getState() == 4) {
                bund.start();
            }
            bc = bund.getBundleContext();
        }
        if (basicThreadFactoryRef == null) {
            String filterString = "(service.type=BASIC)";
            ServiceReference[] refs = bc.getServiceReferences("com.ibm.cics.osgi.ICICSThreadJoiner", filterString);
            if (refs.length > 1) {
                throw new Exception("Internal error: ThreadJoiner - too many matches to BasicThreadJoiner Service!");
            }
            basicThreadFactoryRef = refs[0];
        }
        if (basicThreadFactoryRef == null) {
            throw new Exception("Internal error: ThreadJoiner - cannot find a registered implementation of ICICSThreadJoiner from BasicThreadFactory");
        }
        if (basicJoiner == null) {
            basicJoiner = (ICICSThreadJoiner)bc.getService(basicThreadFactoryRef);
        }
        return basicJoiner;
    }
}

