/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.server.CicsException;
import com.ibm.cics.server.Version;
import com.ibm.cics.server.internal.JCICSLateBinding;
import com.ibm.cics.server.internal.ManifestReader;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class API {
    private static Logger logger;
    private static final boolean rebindLoggerForEachUse;
    protected static AtomicBoolean isApiVersionAlreadyLogged;

    API() {
        this(true);
    }

    API(boolean bindTask) {
        if (logger == null || rebindLoggerForEachUse) {
            logger = LoggerFactory.getLogger(API.class);
        }
        if (logger.shouldTrace(LogType.DEBUG)) {
            logger.logDebug("constructor", new Object[]{"bindTask=" + bindTask + "," + this.toString()});
        }
        if (bindTask) {
            JCICSLateBinding.bindTaskIfRequired();
        }
        API.logApiVersion();
    }

    private static void logApiVersion() {
        if (!isApiVersionAlreadyLogged.getAndSet(true)) {
            try {
                Version apiVersion = API.getCICSServerApiVersion();
                String msg = String.format("Version of com.ibm.cics.server package is %s", apiVersion);
                logger.logInfo("logApiVersion", new Object[]{msg});
            }
            catch (Exception ex) {
                logger.logWarning("logApiVersion", "Failed to get the API version.", (Throwable)ex);
            }
        }
    }

    public static Version getCICSServerApiVersion() throws CicsException {
        ManifestReader reader = new ManifestReader();
        Version version = reader.getExportPackageVersion("com.ibm.cics.server");
        return version;
    }

    static {
        rebindLoggerForEachUse = EnvironmentConstants.env.isLoggerRebindRequired();
        isApiVersionAlreadyLogged = new AtomicBoolean(false);
    }
}

