/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.ResourceUnavailableException;
import com.ibm.cics.server.SynchronizationResource;

public class AddressResource
extends SynchronizationResource {
    private static final Logger cicsLog = LoggerFactory.getLogger(AddressResource.class);
    private static final long serialVersionUID = 319465280460549460L;
    private byte[] address;

    public void dequeue() throws LengthErrorException {
        cicsLog.logEntryExit("dequeue", new Object[0]);
        try {
            if (this.address == null) {
                throw new NullPointerException("null resource address");
            }
            super.dequeue(this.address);
        }
        catch (LengthErrorException lee) {
            throw new LengthErrorException("dequeue(address) returned LengthErrorException");
        }
    }

    public void enqueue() throws ResourceUnavailableException, LengthErrorException {
        cicsLog.logEntryExit("enqueue", new Object[0]);
        try {
            if (this.address == null) {
                throw new NullPointerException("null resource address");
            }
            super.enqueue(this.address, true);
        }
        catch (LengthErrorException lee) {
            throw new LengthErrorException("enqueue(address, true) returned LengthErrorException");
        }
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        cicsLog.logEntryExit("setAddress", new Object[]{address});
        this.address = new byte[]{0, 0, 0, 0};
        int dataLen = Math.min(address.length, this.address.length);
        System.arraycopy(address, 0, this.address, 0, dataLen);
    }

    public void tryEnqueue() throws ResourceUnavailableException, LengthErrorException {
        cicsLog.logEntryExit("tryEnqueue", new Object[0]);
        try {
            if (this.address == null) {
                throw new NullPointerException("null resource address");
            }
            super.enqueue(this.address, false);
        }
        catch (LengthErrorException lee) {
            throw new LengthErrorException("enqueue(address, false) in method tryEnqueue() returned LengthErrorException");
        }
    }
}

