/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateApplication;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.server.API;
import com.ibm.cics.server.ApplicationNotFoundException;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.Version;

public class Application
extends API {
    private static final Logger cicsLog = LoggerFactory.getLogger(Application.class);
    private String operation;
    private String application;
    private String platform;
    private Version appVersion;
    private MatchStyle match;
    private DelegateApplication delegate;

    public Application(String operation, String application, String platform, Version version, MatchStyle match) {
        cicsLog.logEntryExit("constructor", new Object[]{operation, application, platform, version, match});
        if (operation.length() > 64) {
            throw new IllegalArgumentException(operation);
        }
        if (application.length() > 64) {
            throw new IllegalArgumentException(application);
        }
        if (platform.length() > 64) {
            throw new IllegalArgumentException(platform);
        }
        if (match == null) {
            throw new IllegalArgumentException("match == null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version == null");
        }
        if (match == MatchStyle.NONE && version.getMajorVersion() >= 0) {
            throw new IllegalArgumentException("Version is not compatible with MatchStyle.NONE");
        }
        this.operation = operation;
        this.application = application;
        this.platform = platform;
        this.appVersion = version;
        this.match = match;
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateApplication();
    }

    public Application(String operation, String application, Version version, MatchStyle match) {
        this(operation, application, "", version, match);
    }

    public Application(String operation, String application) {
        this(operation, application, "", new Version(-1, 0, 0), MatchStyle.NONE);
    }

    public Application(String operation, String application, String platform) {
        this(operation, application, platform, new Version(-1, 0, 0), MatchStyle.NONE);
    }

    public Application(String operation, String application, String platform, int majorVersion, int minorVersion, MatchStyle match) {
        this(operation, application, platform, new Version(majorVersion, minorVersion, 0), match);
    }

    public Application(String operation, String application, int majorVersion, int minorVersion, MatchStyle match) {
        this(operation, application, "", new Version(majorVersion, minorVersion, 0), match);
    }

    public String getOperation() {
        return this.operation;
    }

    public String getApplication() {
        return this.application;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Version getVersion() {
        return this.appVersion;
    }

    public void setVersion(Version version) {
        cicsLog.logEntryExit("setVersion", new Object[]{version});
        this.appVersion = version;
    }

    public MatchStyle getMatch() {
        return this.match;
    }

    public void setMatch(MatchStyle match) {
        cicsLog.logEntryExit("setMatch", new Object[]{match});
        this.match = match;
    }

    public void setOperation(String operation) {
        cicsLog.logEntryExit("setOperation", new Object[]{operation});
        this.operation = operation;
    }

    public void setApplication(String application) {
        cicsLog.logEntryExit("setApplication", new Object[]{application});
        this.application = application;
    }

    public void setPlatform(String platform) {
        cicsLog.logEntryExit("setPlatform", new Object[]{platform});
        this.platform = platform;
    }

    public boolean equals(Object obj) {
        return obj instanceof Application && ((Application)obj).getApplication().equals(this.application) && ((Application)obj).getPlatform().equals(this.platform) && ((Application)obj).getOperation().equals(this.operation) && ((Application)obj).getVersion().equals(this.appVersion);
    }

    private static void handleDelegateError(DelegateError err) throws InvalidRequestException, ApplicationNotFoundException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case APPLICATION_NOT_FOUND: {
                throw new ApplicationNotFoundException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }

    public void invoke() throws InvalidRequestException, ApplicationNotFoundException {
        cicsLog.logEntryExit("invoke", new Object[0]);
        try {
            this.delegate.invoke(this.operation, this.application, this.platform, this.appVersion.getMajorVersion(), this.appVersion.getMinorVersion(), this.match.getMatchStyle());
        }
        catch (DelegateError err) {
            Application.handleDelegateError(err);
        }
    }

    public void invoke(Channel channel) throws InvalidRequestException, ApplicationNotFoundException {
        cicsLog.logEntryExit("invoke", new Object[]{channel});
        try {
            this.delegate.invokeChannel(this.operation, this.application, this.platform, this.appVersion.getMajorVersion(), this.appVersion.getMinorVersion(), this.match.getMatchStyle(), channel.getName());
        }
        catch (DelegateError err) {
            Application.handleDelegateError(err);
        }
    }

    public void invoke(byte[] commarea) throws InvalidRequestException, ApplicationNotFoundException {
        cicsLog.logEntryExit("invoke", new Object[]{"commarea:", commarea});
        try {
            this.delegate.invokeCommArea(this.operation, this.application, this.platform, this.appVersion.getMajorVersion(), this.appVersion.getMinorVersion(), this.match.getMatchStyle(), commarea);
        }
        catch (DelegateError err) {
            Application.handleDelegateError(err);
        }
    }

    public static enum MatchStyle {
        NONE(-1),
        EXACTMATCH(1),
        MINIMUM(2);

        private int match;

        private MatchStyle(int style) {
            this.match = style;
        }

        public int getMatchStyle() {
            return this.match;
        }
    }
}

