/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.async.DelegateAsyncService;
import com.ibm.cics.server.API;
import com.ibm.cics.server.AsyncService;
import com.ibm.cics.server.CICSFuture;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ChildResponse;
import com.ibm.cics.server.ChildResponseImpl;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidTransactionIdException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotFinishedException;
import com.ibm.cics.server.NotFoundException;
import com.ibm.cics.server.ResourceDisabledException;
import com.ibm.cics.server.StartFailedException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

@InjectLogging(isEnabled=false)
public final class AsyncServiceImpl
extends API
implements AsyncService {
    private static final Logger cicsLog = LoggerFactory.getLogger(AsyncServiceImpl.class);
    private DelegateAsyncService delegate;

    public AsyncServiceImpl() {
        cicsLog.logEntryExit("constructor", new Object[0]);
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateAsyncService();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public Future<ChildResponse> runTransactionId(String string, Channel channel) throws InvalidRequestException, InvalidTransactionIdException, ChannelErrorException, NotAuthorisedException, ResourceDisabledException, StartFailedException {
        CICSFuture future;
        void channel2;
        void tranId;
        cicsLog.logEntry("runTransactionId", new Object[]{string, channel});
        String channelName = "";
        byte[] childToken = null;
        String transactionId = tranId;
        if (transactionId == null || transactionId.isEmpty() || transactionId.length() > 4) {
            throw new InvalidTransactionIdException("The transaction ID is invalid", 1);
        }
        transactionId = String.format("%1$-4s", transactionId);
        if (channel2 != null) {
            channelName = channel2.getName();
        }
        try {
            childToken = this.delegate.runTransaction(transactionId, channelName);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_TRANSACTION_ID: {
                    throw new InvalidTransactionIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case FILE_DISABLED: {
                    throw new ResourceDisabledException("Transaction '" + transactionId + "' is disabled", 50, err);
                }
                case START_FAILED: {
                    throw new StartFailedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        CICSFuture cICSFuture = future = new CICSFuture(childToken);
        cicsLog.logExit("runTransactionId", new Object[]{cICSFuture});
        return cICSFuture;
    }

    @Override
    public Future<ChildResponse> runTransactionId(String transactionId) throws InvalidRequestException, InvalidTransactionIdException, NotAuthorisedException, ResourceDisabledException, StartFailedException {
        Future<ChildResponse> request = null;
        try {
            request = this.runTransactionId(transactionId, null);
        }
        catch (ChannelErrorException channelErrorException) {
            // empty catch block
        }
        return request;
    }

    @Override
    @InjectLogging
    public ChildResponse getAny() throws InvalidRequestException, NotFoundException {
        cicsLog.logEntry("getAny");
        ChildResponseImpl childResponse = new ChildResponseImpl(null);
        byte[] childResponseData = null;
        try {
            childResponseData = this.delegate.fetchAny(0, false);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_NOT_FOUND: {
                    throw new NotFoundException("No unfetched children were found", 1, err);
                }
                case NOT_FINISHED: {
                    break;
                }
                default: {
                    DelegateErrorHandler.handleUncheckedError(err);
                }
            }
        }
        if (childResponseData != null) {
            childResponse.setResponse(childResponseData, true);
        }
        ChildResponseImpl childResponseImpl = childResponse;
        cicsLog.logExit("getAny", new Object[]{childResponseImpl});
        return childResponseImpl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public ChildResponse getAny(AsyncService.BlockingAction blockingAction) throws InvalidRequestException, NotFinishedException, NotFoundException {
        void blockingAction2;
        cicsLog.logEntry("getAny", new Object[]{blockingAction});
        ChildResponseImpl childResponse = new ChildResponseImpl(null);
        byte[] childResponseData = null;
        boolean noSuspendKeyword = false;
        if (blockingAction2 != null) {
            switch (1.$SwitchMap$com$ibm$cics$server$AsyncService$BlockingAction[blockingAction2.ordinal()]) {
                case 1: {
                    noSuspendKeyword = true;
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
        try {
            childResponseData = this.delegate.fetchAny(0, noSuspendKeyword);
        }
        catch (DelegateError err) {
            AsyncServiceImpl.handleFetchAnyErrors(err);
        }
        if (childResponseData != null) {
            childResponse.setResponse(childResponseData, true);
        }
        ChildResponseImpl childResponseImpl = childResponse;
        cicsLog.logExit("getAny", new Object[]{childResponseImpl});
        return childResponseImpl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public ChildResponse getAny(long l, TimeUnit timeUnit) throws InvalidRequestException, NotFinishedException, NotFoundException {
        void timeout;
        void unit;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = new Long(l);
            objectArray[1] = timeUnit;
            cicsLog.logEntry("getAny", objectArray);
        }
        if (unit == null) {
            throw new InvalidRequestException("A TimeUnit must be specified", 241);
        }
        ChildResponseImpl childResponse = new ChildResponseImpl(null);
        byte[] childResponseData = null;
        long timeoutMilliSeconds = TimeUnit.MILLISECONDS.convert((long)timeout, (TimeUnit)unit);
        if (timeoutMilliSeconds >= Integer.MAX_VALUE) {
            throw new InvalidRequestException("Timeout value is too large", 241);
        }
        int cicsTimeout = (int)timeoutMilliSeconds;
        if (timeoutMilliSeconds < 0L) {
            throw new InvalidRequestException("Timeout value must be positive", 241);
        }
        try {
            childResponseData = this.delegate.fetchAny(cicsTimeout, false);
        }
        catch (DelegateError err) {
            AsyncServiceImpl.handleFetchAnyErrors(err);
        }
        if (childResponseData != null) {
            childResponse.setResponse(childResponseData, true);
        }
        ChildResponseImpl childResponseImpl = childResponse;
        cicsLog.logExit("getAny", new Object[]{childResponseImpl});
        return childResponseImpl;
    }

    private static void handleFetchAnyErrors(DelegateError err) throws InvalidRequestException, NotFoundException, NotFinishedException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case RECORD_NOT_FOUND: {
                throw new NotFoundException("No unfetched children were found", 1, err);
            }
            case NOT_FINISHED: {
                throw new NotFinishedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void freeChild(ChildResponse childResponse) throws InvalidRequestException {
        void childResponse2;
        cicsLog.logEntry("freeChild", new Object[]{childResponse});
        if (childResponse2 != null) {
            try {
                this.delegate.freeChild(((ChildResponseImpl)childResponse2).getToken());
            }
            catch (DelegateError err) {
                AsyncServiceImpl.handleFreeChildErrors(err);
            }
        } else {
            throw new InvalidRequestException("Parameter must not be null", 50);
        }
        cicsLog.logExit("freeChild");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void freeChild(Future<ChildResponse> future) throws InvalidRequestException {
        void future2;
        cicsLog.logEntry("freeChild", new Object[]{future});
        if (future2 == null || !(future2 instanceof CICSFuture)) {
            throw new InvalidRequestException("Parameter must be an instance of CICSFuture and not null", 50);
        }
        try {
            this.delegate.freeChild(((CICSFuture)future2).getChildResponse().getToken());
        }
        catch (DelegateError err) {
            AsyncServiceImpl.handleFreeChildErrors(err);
        }
        cicsLog.logExit("freeChild");
    }

    private static void handleFreeChildErrors(DelegateError err) throws InvalidRequestException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }
}

