/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.comms.DelegateConversation;
import com.ibm.cics.delegate.comms.DelegateConversationConnector;
import com.ibm.cics.delegate.comms.DelegateSyncLevel;
import com.ibm.cics.server.API;
import com.ibm.cics.server.Conversation;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAllocatedException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.SyncLevel;
import com.ibm.cics.server.SystemBusyException;
import java.io.Serializable;

@InjectLogging(isEnabled=false)
public class AttachInitiator
extends API
implements Serializable {
    private static final Logger cicsLog = LoggerFactory.getLogger(AttachInitiator.class);
    private static final long serialVersionUID = 1901955914874515196L;
    private String sysId = "";
    private String profile = "";
    private boolean toQueue = true;
    private String process = "";
    private SyncLevel syncLevel = SyncLevel.NONE;
    private DelegateConversationConnector delegate;

    public AttachInitiator() {
        cicsLog.logEntryExit("constructor", new Object[0]);
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateConversationConnector();
    }

    public String getProcess() {
        return this.process;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean getQueue() {
        return this.toQueue;
    }

    public SyncLevel getSyncLevel() {
        return this.syncLevel;
    }

    public String getSysId() {
        return this.sysId;
    }

    public Conversation initiate() throws InvalidSystemIdException, InvalidRequestException, LengthErrorException, NotAuthorisedException, NotAllocatedException, SystemBusyException {
        cicsLog.logEntryExit("initiate", new Object[0]);
        return this.initiate(null);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public Conversation initiate(byte[] byArray) throws InvalidSystemIdException, InvalidRequestException, LengthErrorException, NotAuthorisedException, NotAllocatedException, SystemBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("initiate", new Object[]{byArray});
        }
        Conversation result = null;
        try {
            void pipdata;
            DelegateSyncLevel level = DelegateSyncLevel.fromInt((int)this.getSyncLevel().hashCode());
            DelegateConversation delegateConversation = this.delegate.connectToProcess(this.getSysId(), this.getProfile(), this.getQueue(), this.getProcess(), level, (byte[])pipdata);
            result = new Conversation(delegateConversation);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case SYSTEM_BUSY: {
                    throw new SystemBusyException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        Conversation conversation = result;
        cicsLog.logExit("initiate", new Object[]{conversation});
        return conversation;
    }

    public void setProcess(String process) throws NullPointerException {
        cicsLog.logEntryExit("setProcess", new Object[]{process});
        if (process == null) {
            throw new NullPointerException("null process");
        }
        this.process = process;
    }

    public void setProfile(String profile) throws NullPointerException {
        cicsLog.logEntryExit("setProfile", new Object[]{profile});
        if (profile == null) {
            throw new NullPointerException("null profile");
        }
        this.profile = profile;
    }

    public void setQueue(boolean queue) {
        cicsLog.logEntryExit("setQueue", new Object[]{Boolean.toString(queue)});
        this.toQueue = queue;
    }

    public void setSyncLevel(SyncLevel syncLevel) {
        cicsLog.logEntryExit("setSyncLevel", new Object[]{syncLevel});
        this.syncLevel = syncLevel;
    }

    public void setSysId(String sysId) throws NullPointerException, InvalidSystemIdException {
        cicsLog.logEntryExit("setSysId", new Object[]{sysId});
        if (sysId == null) {
            throw new NullPointerException("null sysId");
        }
        if (sysId.length() == 0) {
            throw new InvalidSystemIdException("empty sysId", 0);
        }
        this.sysId = sysId;
    }
}

