/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.server.CicsRuntimeException;
import com.ibm.cics.server.FutureWrapper;
import com.ibm.cics.server.internal.CICSThreadPoolExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@InjectLogging(isEnabled=false, loggerName="cicsLog")
public class CICSExecutorService
implements ExecutorService {
    private static final Logger cicsLog = LoggerFactory.getLogger(CICSExecutorService.class);
    private static final boolean isThreadPoolActive = EnvironmentConstants.env.isThreadPoolActive();
    private static final boolean restrictRunAsCICS = EnvironmentConstants.env.isRunAsCicsRestricted();
    private static final int WAIT_PERIOD_MILLIS = 200;
    private static int THREADPOOLTIMEOUT;
    private static boolean isThreadPoolReady;
    private static ExecutorService cicsExecutor;
    private static ExecutorService libertyExecutor;
    private ThreadPoolExecutor cicsThreadExecutor;
    private ThreadFactory basicThreadFactory;

    public CICSExecutorService() {
        cicsLog.logEntryExit("constructor", new Object[0]);
        cicsExecutor = this;
    }

    protected void bindBasicThreadFactory(ThreadFactory theFactory) {
        cicsLog.logEntryExit("bindBasicThreadFactory", new Object[]{theFactory});
        this.basicThreadFactory = theFactory;
    }

    protected void unbindBasicThreadFactory(ThreadFactory theFactory) {
        cicsLog.logEntryExit("unbindBasicThreadFactory", new Object[]{theFactory});
        this.basicThreadFactory = null;
    }

    protected void bindLibertyExecutor(ExecutorService executor) {
        cicsLog.logEntryExit("bindLibertyExecutor", new Object[]{executor});
        libertyExecutor = executor;
    }

    protected void unbindLibertyExecutor(ExecutorService executor) {
        cicsLog.logEntryExit("unbindLibertyExecutor", new Object[]{executor});
        libertyExecutor = null;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected void activate(Map<String, Object> map) {
        cicsLog.logEntry("activate", new Object[]{map});
        if (!isThreadPoolActive) {
            void componentConfig;
            this.cicsThreadExecutor = this.createThreadExecutor((Map<String, Object>)componentConfig);
        }
        cicsLog.logExit("activate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected void modified(Map<String, Object> map) {
        cicsLog.logEntry("modified", new Object[]{map});
        if (!isThreadPoolActive) {
            void componentConfig;
            this.cicsThreadExecutor = this.createThreadExecutor((Map<String, Object>)componentConfig);
        }
        cicsLog.logExit("modified");
    }

    @InjectLogging
    protected void deactivate() {
        cicsLog.logEntry("deactivate");
        this.shutdown();
        this.cicsThreadExecutor = null;
        cicsLog.logExit("deactivate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    private ThreadPoolExecutor createThreadExecutor(Map<String, Object> map) {
        CICSThreadPoolExecutor singlePool;
        void componentConfig;
        cicsLog.logEntry("createThreadExecutor", new Object[]{map});
        RejectedWorkPolicy rejectedWorkPolicy = Enum.valueOf(RejectedWorkPolicy.class, (String)componentConfig.get("rejectedWorkPolicy"));
        RejectedExecutionHandler rejectedExecutionHandler = null;
        rejectedExecutionHandler = rejectedWorkPolicy.equals((Object)RejectedWorkPolicy.ABORT) ? new ThreadPoolExecutor.AbortPolicy() : new ThreadPoolExecutor.CallerRunsPolicy();
        int coreThreads = Integer.parseInt(String.valueOf(componentConfig.get("coreThreads")));
        int maxThreads = Integer.parseInt(String.valueOf(componentConfig.get("maxThreads")));
        long keepAliveMillis = Long.parseLong(String.valueOf(componentConfig.get("keepAlive")));
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        if (this.basicThreadFactory == null) {
            throw new RuntimeException("Internal Error: No BasicThreadFactory has been injected into CICSExecutorService.");
        }
        CICSThreadPoolExecutor cICSThreadPoolExecutor = singlePool = new CICSThreadPoolExecutor(coreThreads, maxThreads, keepAliveMillis, TimeUnit.MILLISECONDS, workQueue, this.basicThreadFactory, rejectedExecutionHandler);
        cicsLog.logExit("createThreadExecutor", new Object[]{cICSThreadPoolExecutor});
        return cICSThreadPoolExecutor;
    }

    @InjectLogging
    public static void runAsCICS(Runnable runnable) {
        Runnable theWork;
        cicsLog.logEntry("runAsCICS", new Object[]{runnable});
        String thisMethod = "runAsCICS(Runnable)";
        if (theWork == null) {
            cicsLog.logError("runAsCICS(Runnable)", new Object[]{"Runnable passed in is null"});
            throw new IllegalArgumentException("The user supplied Runnable 'theWork' is null.");
        }
        CICSExecutorService.isCICSThreadAllowed();
        if (isThreadPoolActive) {
            CICSExecutorService.waitForLibertyThreadPool();
            libertyExecutor.execute(theWork);
        } else {
            cicsExecutor.execute(theWork);
        }
        cicsLog.logExit("runAsCICS");
    }

    @InjectLogging
    public static <T> Future<T> runAsCICS(Callable<T> callable) {
        Callable<T> theWork;
        cicsLog.logEntry("runAsCICS", new Object[]{callable});
        String thisMethod = "runAsCICS(Callable)";
        if (theWork == null) {
            cicsLog.logError("runAsCICS(Callable)", new Object[]{"Callable passed in is null"});
            throw new IllegalArgumentException("The user supplied Callable 'theWork' is null.");
        }
        CICSExecutorService.isCICSThreadAllowed();
        FutureWrapper<T> theResult = new FutureWrapper<T>(theWork);
        if (isThreadPoolActive) {
            CICSExecutorService.waitForLibertyThreadPool();
            libertyExecutor.execute(theResult);
        } else {
            cicsExecutor.execute(theResult);
        }
        FutureWrapper<T> futureWrapper = theResult;
        cicsLog.logExit("runAsCICS", new Object[]{futureWrapper});
        return futureWrapper;
    }

    private static boolean isCICSThreadAllowed() {
        if (restrictRunAsCICS) {
            throw new CicsRuntimeException("Spawning a CICS Thread is disallowed when 'com.ibm.cics.jvmserver.runascics.restrict' = true");
        }
        return true;
    }

    protected static void waitForLibertyThreadPool() {
        int loop = THREADPOOLTIMEOUT / 200;
        for (int i = 0; !isThreadPoolReady && i < loop; ++i) {
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException ie) {
                cicsLog.logError("waitForLibertyThreadPool", "Interrupted", (Throwable)ie);
            }
        }
    }

    protected static void setThreadPoolReady(boolean value) {
        isThreadPoolReady = value;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (isThreadPoolActive) {
            return libertyExecutor.awaitTermination(timeout, unit);
        }
        return this.cicsThreadExecutor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (isThreadPoolActive) {
            return libertyExecutor.invokeAll(tasks);
        }
        return this.cicsThreadExecutor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (isThreadPoolActive) {
            return libertyExecutor.invokeAll(tasks, timeout, unit);
        }
        return this.cicsThreadExecutor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (isThreadPoolActive) {
            return libertyExecutor.invokeAny(tasks);
        }
        return this.cicsThreadExecutor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (isThreadPoolActive) {
            return libertyExecutor.invokeAny(tasks, timeout, unit);
        }
        return this.cicsThreadExecutor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        if (isThreadPoolActive) {
            return libertyExecutor.isShutdown();
        }
        return this.cicsThreadExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        if (isThreadPoolActive) {
            return libertyExecutor.isTerminated();
        }
        return this.cicsThreadExecutor.isTerminated();
    }

    @Override
    @InjectLogging
    public void shutdown() {
        cicsLog.logEntry("shutdown");
        String thisMethod = "shutdown";
        if (this.cicsThreadExecutor == null) {
            cicsLog.logExit("shutdown");
            return;
        }
        this.cicsThreadExecutor.shutdown();
        boolean terminated = false;
        try {
            terminated = this.cicsThreadExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            cicsLog.logError("shutdown", "didn't shutdown politely after 10 seconds", (Throwable)e);
        }
        if (!terminated) {
            try {
                this.cicsThreadExecutor.shutdownNow();
                this.cicsThreadExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                cicsLog.logError("shutdown", "didn't shutdown forcefully after 10 seconds", (Throwable)e);
            }
        }
        cicsLog.logExit("shutdown");
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (isThreadPoolActive) {
            return null;
        }
        return this.cicsThreadExecutor.shutdownNow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public <T> Future<T> submit(Callable<T> callable) {
        void task;
        cicsLog.logEntry("submit", new Object[]{callable});
        Future theFuture = !isThreadPoolActive ? this.cicsThreadExecutor.submit(task) : libertyExecutor.submit(task);
        Future future = theFuture;
        cicsLog.logExit("submit", new Object[]{future});
        return future;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public Future<?> submit(Runnable runnable) {
        void task;
        cicsLog.logEntry("submit", new Object[]{runnable});
        Future<?> theFuture = !isThreadPoolActive ? this.cicsThreadExecutor.submit((Runnable)task) : libertyExecutor.submit((Runnable)task);
        Future<?> future = theFuture;
        cicsLog.logExit("submit", new Object[]{future});
        return future;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public <T> Future<T> submit(Runnable runnable, T t) {
        void result;
        void task;
        cicsLog.logEntry("submit", new Object[]{runnable, t});
        Future<void> theFuture = !isThreadPoolActive ? this.cicsThreadExecutor.submit((Runnable)task, result) : libertyExecutor.submit((Runnable)task, result);
        Future<void> future = theFuture;
        cicsLog.logExit("submit", new Object[]{future});
        return future;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void execute(Runnable runnable) {
        void usersRunnable;
        cicsLog.logEntry("execute", new Object[]{runnable});
        if (!isThreadPoolActive) {
            this.cicsThreadExecutor.execute((Runnable)usersRunnable);
        } else {
            libertyExecutor.execute((Runnable)usersRunnable);
        }
        cicsLog.logExit("execute");
    }

    static {
        try {
            THREADPOOLTIMEOUT = Integer.parseInt(EnvironmentConstants.env.getThreadPoolTimeout());
        }
        catch (NumberFormatException e) {
            THREADPOOLTIMEOUT = 90000;
        }
    }

    public static enum RejectedWorkPolicy {
        ABORT,
        CALLER_RUNS;

    }
}

