/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.async.DelegateCICSFuture;
import com.ibm.cics.server.API;
import com.ibm.cics.server.ChildResponse;
import com.ibm.cics.server.ChildResponseImpl;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@InjectLogging(isEnabled=false)
public class CICSFuture
extends API
implements Future<ChildResponse> {
    private static Logger cicsLog = LoggerFactory.getLogger(CICSFuture.class);
    private ChildResponseImpl childResponse;
    private DelegateCICSFuture delegate;

    protected CICSFuture(byte[] childToken) {
        cicsLog.logEntryExit("constructor", new Object[]{childToken});
        this.childResponse = new ChildResponseImpl(childToken);
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateCICSFuture();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ChildResponseImpl) {
            ChildResponseImpl other = (ChildResponseImpl)obj;
            byte[] otherToken = other.getToken();
            if (Arrays.equals(this.childResponse.getToken(), otherToken)) {
                return true;
            }
        } else if (this.getClass() == obj.getClass()) {
            CICSFuture other = (CICSFuture)obj;
            if (Arrays.equals(this.childResponse.getToken(), other.getChildResponse().getToken())) {
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.childResponse != null) {
            return Arrays.hashCode(this.childResponse.getToken());
        }
        return 0;
    }

    protected ChildResponseImpl getChildResponse() {
        return this.childResponse;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        cicsLog.logEntryExit("cancel", new Object[0]);
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectLogging
    public ChildResponse get() throws InterruptedException, ExecutionException {
        cicsLog.logEntry("get");
        try {
            this.childResponse = (ChildResponseImpl)this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        ChildResponseImpl childResponseImpl = this.childResponse;
        cicsLog.logExit("get", new Object[]{childResponseImpl});
        return childResponseImpl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public ChildResponse get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = new Long(l);
            objectArray[1] = timeUnit;
            cicsLog.logEntry("get", objectArray);
        }
        if (!this.childResponse.isFetched()) {
            void unit;
            void timeout;
            byte[] childResponseData = null;
            long timeoutMilliSeconds = TimeUnit.MILLISECONDS.convert((long)timeout, (TimeUnit)unit);
            if (timeoutMilliSeconds >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Timeout value is too large", new InvalidRequestException(241));
            }
            int cicsTimeout = (int)timeoutMilliSeconds;
            if (timeoutMilliSeconds < 0L) {
                throw new IllegalArgumentException("Timeout value must be positive", new InvalidRequestException(241));
            }
            try {
                childResponseData = this.delegate.fetchChild(this.childResponse.getToken(), cicsTimeout, false);
            }
            catch (DelegateError err) {
                switch (err.getCode()) {
                    case INVALID_REQUEST: {
                        throw new ExecutionException("Invalid request: the child task has already been freed, or the timeout value is invalid", err);
                    }
                    case NOT_FINISHED: {
                        throw new TimeoutException("The child has not yet finished");
                    }
                }
                DelegateErrorHandler.handleUncheckedError(err);
            }
            if (childResponseData != null) {
                this.childResponse.setResponse(childResponseData, false);
            }
        }
        ChildResponseImpl childResponseImpl = this.childResponse;
        cicsLog.logExit("get", new Object[]{childResponseImpl});
        return childResponseImpl;
    }

    @Override
    public boolean isCancelled() {
        cicsLog.logEntryExit("isCancelled", new Object[0]);
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectLogging
    public boolean isDone() {
        cicsLog.logEntry("isDone");
        byte[] childResponseData = null;
        boolean isDone = false;
        if (this.childResponse.isFetched()) {
            isDone = true;
        } else {
            try {
                childResponseData = this.delegate.fetchChild(this.childResponse.getToken(), 0, true);
                this.childResponse.setCompletionStatus(childResponseData);
                if (this.childResponse.getCompletionStatus() != null) {
                    isDone = true;
                }
            }
            catch (DelegateError err) {
                switch (err.getCode()) {
                    case INVALID_REQUEST: {
                        isDone = false;
                        break;
                    }
                    case NOT_FINISHED: {
                        isDone = false;
                        break;
                    }
                    default: {
                        DelegateErrorHandler.handleUncheckedError(err);
                    }
                }
            }
        }
        boolean bl = isDone;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            boolean bl2 = bl;
            cicsLog.logExit("isDone", new Object[]{new Boolean(bl2)});
            bl = bl2;
        }
        return bl;
    }
}

