/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateCertificateExtractor;
import com.ibm.cics.delegate.web.DelegateCertificateInfo;
import com.ibm.cics.delegate.web.DelegateCertificateOriginEntity;
import com.ibm.cics.server.API;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;

public class CertificateInfo
extends API {
    public static final int ISSUER = DelegateCertificateOriginEntity.ISSUER.getValue();
    public static final int OWNER = DelegateCertificateOriginEntity.OWNER.getValue();
    private DelegateCertificateInfo delegate;

    CertificateInfo(int ownerIssuer) throws InvalidRequestException {
        DelegateCertificateExtractor extractor = DelegateFactoryLoader.getDelegateFactory().createDelegateCertificateExtractor();
        DelegateCertificateOriginEntity originEntity = DelegateCertificateOriginEntity.lookup((int)ownerIssuer);
        try {
            this.delegate = extractor.extractCertificate(originEntity);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    public byte[] getCertificate() {
        return this.delegate.getCertificate();
    }

    public String getSerialNum() {
        return this.delegate.getSerialNum();
    }

    public String getUserID() {
        return this.delegate.getUserID();
    }

    public String getCommonName() {
        return this.delegate.getCommonName();
    }

    public String getCountry() {
        return this.delegate.getCountry();
    }

    public String getState() {
        return this.delegate.getState();
    }

    public String getLocality() {
        return this.delegate.getLocality();
    }

    public String getOrganization() {
        return this.delegate.getOrganization();
    }

    public String getOrgUnit() {
        return this.delegate.getOrgUnit();
    }

    protected void resetObject() {
        this.delegate.resetObject();
    }
}

