/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.Environment;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateChannel;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.OwnedDelegate;
import com.ibm.cics.server.API;
import com.ibm.cics.server.CCSIDErrorException;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ChannelFactory;
import com.ibm.cics.server.CicsException;
import com.ibm.cics.server.CodePageErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.ContainerIterator;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.DelegateOwnerAdapter;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;

@InjectLogging(isEnabled=false)
public class Channel
extends API {
    private static final Logger cicsLog = LoggerFactory.getLogger(Channel.class);
    static final int DEFAULT_CONTAINER_LIST_SIZE = 16;
    static final int DEFAULT_ITERATOR_LIST_SIZE = 2;
    public static final String SYSTEM_PROPERTY_NAME_CONTAINER_EXISTENCE_CHECKING_ENABLED_DEFAULT = "com.ibm.cics.server.container.existence.checking.default";
    private DelegateChannel delegateChannel;
    private ArrayList<Container> existingContainerList;
    private HashMap<String, Container> existingContainerMap;
    private WeakHashMap<String, Container> containerHandlesMap;
    private ArrayList<ContainerIterator> iteratorList;
    private boolean isContainerExistenceChecksEnabled;

    Channel(String channelName, Environment env) throws ChannelErrorException {
        this(channelName, 16, env);
    }

    @InjectLogging
    Channel(DelegateChannel delegateChannel, Environment env) {
        cicsLog.logEntry("<init>", new Object[]{delegateChannel, env});
        this.isContainerExistenceChecksEnabled = true;
        this.delegateChannel = delegateChannel;
        DelegateOwnerAdapter<Channel> delegateOwnerAdapter = new DelegateOwnerAdapter<Channel>(this, (OwnedDelegate)delegateChannel);
        this.delegateChannel.setOwner(delegateOwnerAdapter);
        this.initializeContainerLists(16);
        this.isContainerExistenceChecksEnabled = env.isContainerExistenceCheckingEnabledByDefault();
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    Channel(String channelName, int listSize, Environment env) throws ChannelErrorException {
        String name;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("<init>", new Object[]{channelName, new Integer(listSize), env});
        }
        this.isContainerExistenceChecksEnabled = true;
        try {
            name = ChannelFactory.padName(channelName);
        }
        catch (CicsException e) {
            throw new ChannelErrorException("Channel " + e.getMessage(), 1);
        }
        if (name == null) {
            throw new ChannelErrorException("Channel name \"" + channelName + "\" is longer than " + 16 + " characters", 1);
        }
        this.delegateChannel = DelegateFactoryLoader.getDelegateFactory().createDelegateChannel(name);
        DelegateOwnerAdapter<Channel> delegateOwnerAdapter = new DelegateOwnerAdapter<Channel>(this, (OwnedDelegate)this.delegateChannel);
        this.delegateChannel.setOwner(delegateOwnerAdapter);
        this.initializeContainerLists(listSize);
        this.isContainerExistenceChecksEnabled = env.isContainerExistenceCheckingEnabledByDefault();
        cicsLog.logExit("<init>");
    }

    private void initializeContainerLists(int listSize) {
        cicsLog.logEntryExit("initializeContainerLists", new Object[]{new Integer(listSize)});
        this.existingContainerList = new ArrayList(listSize);
        this.existingContainerMap = new HashMap(listSize);
        this.iteratorList = new ArrayList(2);
        this.containerHandlesMap = new WeakHashMap(listSize);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    Container findContainer(String string) throws ContainerErrorException {
        Container foundResult;
        void containerName;
        cicsLog.logEntry("findContainer", new Object[]{string});
        String paddedContainerName = Channel.getPaddedContainerName((String)containerName);
        Container container = foundResult = this.existingContainerMap.get(paddedContainerName);
        cicsLog.logExit("findContainer", new Object[]{container});
        return container;
    }

    private static String getPaddedContainerName(String unPaddedContainerName) throws ContainerErrorException {
        String paddedContainerName = null;
        try {
            paddedContainerName = ChannelFactory.padName(unPaddedContainerName);
        }
        catch (CicsException e) {
            throw new ContainerErrorException("Container " + e.getMessage(), 18);
        }
        if (paddedContainerName == null) {
            throw new ContainerErrorException("Container name \"" + unPaddedContainerName + "\" is longer than " + 16 + " characters", 18);
        }
        return paddedContainerName;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    void containerExistsInCicsEvent(Container container) {
        void c;
        cicsLog.logEntry("containerExistsInCicsEvent", new Object[]{container});
        String containerName = c.getName();
        Container foundContainer = this.existingContainerMap.get(containerName);
        if (foundContainer == null) {
            this.existingContainerList.add((Container)c);
            this.existingContainerMap.put(containerName, (Container)c);
        }
        cicsLog.logExit("containerExistsInCicsEvent");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    void containerRemovedFromCicsEvent(Container container) {
        void c;
        cicsLog.logEntry("containerRemovedFromCicsEvent", new Object[]{container});
        int i = this.existingContainerList.indexOf(c);
        if (i != -1) {
            this.existingContainerList.remove(i);
            this.existingContainerMap.put(c.getName(), null);
            ListIterator<ContainerIterator> li = this.iteratorList.listIterator();
            while (li.hasNext()) {
                ContainerIterator ci = li.next();
                ci.containerDeletedEvent(i);
            }
        }
        cicsLog.logExit("containerRemovedFromCicsEvent");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public Container createContainer(String string) throws ContainerErrorException, ChannelErrorException {
        void containerName;
        cicsLog.logEntry("createContainer", new Object[]{string});
        String paddedContainerName = Channel.getPaddedContainerName((String)containerName);
        Container c = this.containerHandlesMap.get(paddedContainerName);
        if (c == null) {
            c = new Container(paddedContainerName, this);
            this.containerHandlesMap.put(paddedContainerName, c);
        }
        Container container = c;
        cicsLog.logExit("createContainer", new Object[]{container});
        return container;
    }

    public Container getContainer(String containerName) throws ContainerErrorException {
        return this.getContainer(containerName, this.isContainerExistenceChecksEnabled);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public Container getContainer(String string, boolean bl) throws ContainerErrorException {
        void containerName;
        void isExistenceChecked;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("getContainer", new Object[]{string, new Boolean(bl)});
        }
        Container c = isExistenceChecked != false ? this.getContainerWithExistenceCheck((String)containerName) : this.getContainerNoExistenceChecking((String)containerName);
        Container container = c;
        cicsLog.logExit("getContainer", new Object[]{container});
        return container;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    private Container getContainerNoExistenceChecking(String string) throws ContainerErrorException {
        void containerName;
        cicsLog.logEntry("getContainerNoExistenceChecking", new Object[]{string});
        String paddedContainerName = Channel.getPaddedContainerName((String)containerName);
        Container c = this.containerHandlesMap.get(paddedContainerName);
        if (c == null) {
            c = new Container(paddedContainerName, this);
            this.containerHandlesMap.put(paddedContainerName, c);
        }
        Container container = c;
        cicsLog.logExit("getContainerNoExistenceChecking", new Object[]{container});
        return container;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    private Container getContainerWithExistenceCheck(String string) throws ContainerErrorException {
        void containerName;
        cicsLog.logEntry("getContainerWithExistenceCheck", new Object[]{string});
        String paddedContainerName = Channel.getPaddedContainerName((String)containerName);
        Container c = this.containerHandlesMap.get(paddedContainerName);
        if (c == null) {
            c = new Container((String)containerName, this);
            if (c.exists()) {
                this.containerHandlesMap.put(paddedContainerName, c);
            } else {
                c = null;
            }
        } else if (!c.exists()) {
            this.containerRemovedFromCicsEvent(c);
            c.setDataInCICS(false);
            c = null;
        }
        Container container = c;
        cicsLog.logExit("getContainerWithExistenceCheck", new Object[]{container});
        return container;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void deleteContainer(String string) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, InvalidRequestException {
        boolean isExists;
        void containerName;
        cicsLog.logEntry("deleteContainer", new Object[]{string});
        Container c = this.findContainer((String)containerName);
        if (c == null) {
            c = new Container((String)containerName, this);
        }
        if (!(isExists = c.exists())) {
            this.containerRemovedFromCicsEvent(c);
            throw new ContainerErrorException("Container \"" + (String)containerName + "\" does not exist", 10);
        }
        c.delete();
        this.containerRemovedFromCicsEvent(c);
        cicsLog.logExit("deleteContainer");
    }

    public String getName() {
        return this.delegateChannel.getName();
    }

    public String toString() {
        String result = this.delegateChannel != null ? "Channel(name='" + this.delegateChannel.getName() + "')" : super.toString();
        return result;
    }

    @Deprecated
    @InjectLogging
    public ContainerIterator containerIterator() {
        cicsLog.logEntry("containerIterator");
        ContainerIterator ci = new ContainerIterator(this, this.existingContainerList);
        this.iteratorList.add(ci);
        ContainerIterator containerIterator = ci;
        cicsLog.logExit("containerIterator", new Object[]{containerIterator});
        return containerIterator;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected Container returnContainer(String string) throws ContainerErrorException {
        void containerName;
        cicsLog.logEntry("returnContainer", new Object[]{string});
        Container c = this.findContainer((String)containerName);
        if (c == null) {
            c = new Container((String)containerName, this);
            this.containerExistsInCicsEvent(c);
        }
        Container container = c;
        cicsLog.logExit("returnContainer", new Object[]{container});
        return container;
    }

    @InjectLogging
    public void delete() throws ChannelErrorException {
        cicsLog.logEntry("delete");
        try {
            this.delegateChannel.delete();
        }
        catch (DelegateError err) {
            throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
        }
        this.existingContainerList.clear();
        this.existingContainerList = null;
        this.iteratorList.clear();
        this.iteratorList = null;
        this.existingContainerMap.clear();
        this.existingContainerMap = null;
        Task.getTask().removeChannel(this);
        cicsLog.logExit("delete");
    }

    @InjectLogging
    public int getContainerCount() throws ChannelErrorException {
        int containerCount;
        cicsLog.logEntry("getContainerCount");
        try {
            containerCount = this.delegateChannel.getContainerCount();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case CHANNEL_ERROR: {
                    ChannelErrorException ex = new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                    cicsLog.logError("getContainerCount", new Object[]{ex});
                    throw ex;
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            int n = 0;
            if (cicsLog.shouldTrace(LogType.EXIT)) {
                int n2 = n;
                cicsLog.logExit("getContainerCount", new Object[]{new Integer(n2)});
                n = n2;
            }
            return n;
        }
        int n = containerCount;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n3 = n;
            cicsLog.logExit("getContainerCount", new Object[]{new Integer(n3)});
            n = n3;
        }
        return n;
    }

    @InjectLogging
    public List<String> getContainerNames() throws ChannelErrorException {
        cicsLog.logEntry("getContainerNames");
        ArrayList<String> containerNames = null;
        try {
            containerNames = this.delegateChannel.getContainerNames();
            this.updateChannelContainerExistsLists((List<String>)containerNames);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            containerNames = new ArrayList<String>();
        }
        ArrayList<String> arrayList = containerNames;
        cicsLog.logExit("getContainerNames", new Object[]{arrayList});
        return arrayList;
    }

    private void updateChannelContainerExistsLists(List<String> containersExistingInCICSNamesList) {
        HashSet<String> containersExistingInCICSNames = new HashSet<String>();
        for (String containerName : containersExistingInCICSNamesList) {
            containersExistingInCICSNames.add(containerName);
        }
        this.deleteContainersNoLongerExisting(containersExistingInCICSNames);
        this.addContainersToExistingList(containersExistingInCICSNamesList);
    }

    private void deleteContainersNoLongerExisting(HashSet<String> containersExistingInCICSNames) {
        String thisMethod = "deleteContainersNoLongerExisting";
        ListIterator<Container> li = this.existingContainerList.listIterator();
        ArrayList<Container> containersToDeleteFromChannelList = new ArrayList<Container>(this.existingContainerList.size());
        while (li.hasNext()) {
            Container c = li.next();
            boolean isInChannelListButNotInCics = !containersExistingInCICSNames.contains(c.getName());
            if (!isInChannelListButNotInCics || !c.isDataInCICS()) continue;
            containersToDeleteFromChannelList.add(c);
        }
        for (Container containerToDelete : containersToDeleteFromChannelList) {
            cicsLog.logDebug("deleteContainersNoLongerExisting", new Object[]{"Container no longer exists:", containerToDelete.getName()});
            this.containerRemovedFromCicsEvent(containerToDelete);
        }
    }

    private void addContainersToExistingList(List<String> containersExistingInCICSNames) {
        String thisMethod = "addContainersToExistingList";
        for (String containerName : containersExistingInCICSNames) {
            try {
                Container c = this.getContainer(containerName, false);
                if (c == null) {
                    c = this.createContainer(containerName);
                }
                cicsLog.logDebug("addContainersToExistingList", new Object[]{"Container exists", containerName});
                c.containerExistsInCICS();
            }
            catch (ChannelErrorException | ContainerErrorException cicsConditionException) {}
        }
    }

    public void setContainerExistenceCheckingEnabled(boolean isCheckingEnabled) {
        this.isContainerExistenceChecksEnabled = isCheckingEnabled;
    }

    public boolean isContainerExistenceCheckingEnabled() {
        return this.isContainerExistenceChecksEnabled;
    }
}

