/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.CicsException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@InjectLogging(isEnabled=false)
public class ChannelFactory {
    private static final Logger cicsLog = LoggerFactory.getLogger(ChannelFactory.class);
    static final int CHANNEL_LIST_SIZE = 16;
    static final int MAX_NAME_LEN = 16;
    private Map<String, Channel> namedChannels;
    private Set<Channel> unnamedChannels;

    ChannelFactory(Channel currentChan) {
        cicsLog.logEntryExit("constructor", new Object[]{currentChan});
        this.namedChannels = new HashMap<String, Channel>(16);
        this.unnamedChannels = new HashSet<Channel>();
        if (currentChan != null) {
            this.add(currentChan);
        }
    }

    static String padName(String name) throws CicsException {
        if (name == null) {
            throw new CicsException("name is null");
        }
        int strLen = name.length();
        if (strLen == 16 && name.indexOf(0) == -1) {
            return name;
        }
        if (strLen > 16) {
            return null;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.setLength(16);
        for (int i = 15; i >= 0 && sb.charAt(i) == '\u0000'; --i) {
            sb.setCharAt(i, ' ');
        }
        String paddedName = sb.toString();
        if (paddedName.indexOf(0) > -1) {
            throw new CicsException("name contains a null character at index " + paddedName.indexOf(0) + ". ");
        }
        if (paddedName.trim().length() == 0) {
            throw new CicsException("name is empty. ");
        }
        return paddedName;
    }

    boolean channelExists(String channelName) throws ChannelErrorException {
        String fullName = null;
        try {
            fullName = ChannelFactory.padName(channelName);
        }
        catch (CicsException e) {
            throw new ChannelErrorException("Channel " + e.getMessage(), 1);
        }
        if (fullName == null) {
            throw new ChannelErrorException("Channel name \"" + channelName + "\" is longer than " + 16 + " characters", 1);
        }
        boolean isExists = false;
        if (this.namedChannels.containsKey(fullName)) {
            isExists = true;
        }
        return isExists;
    }

    void add(Channel chan) {
        cicsLog.logEntryExit("add", new Object[]{chan});
        String name = chan.getName();
        if (name != null) {
            this.namedChannels.put(name, chan);
        } else {
            this.unnamedChannels.add(chan);
        }
    }

    boolean remove(Channel chan) {
        cicsLog.logEntryExit("remove", new Object[]{chan});
        boolean isExistedBeforeRemove = false;
        String channelName = chan.getName();
        if (channelName != null) {
            Channel channelToRemove = this.namedChannels.remove(channelName);
            if (channelToRemove != null) {
                isExistedBeforeRemove = true;
            }
        } else {
            isExistedBeforeRemove = this.unnamedChannels.remove(chan);
        }
        return isExistedBeforeRemove;
    }

    Channel createChannel(String channelName, int listSize) throws ChannelErrorException {
        cicsLog.logEntryExit("createChannel", new Object[]{channelName});
        if (this.channelExists(channelName)) {
            throw new ChannelErrorException("Channel \"" + channelName + "\" already exists", 1);
        }
        Channel chan = new Channel(channelName, listSize, EnvironmentConstants.env);
        this.add(chan);
        return chan;
    }

    protected Channel returnChannel(String channelName) throws ChannelErrorException {
        String paddedChannelName;
        cicsLog.logEntryExit("returnChannel", new Object[]{channelName});
        try {
            paddedChannelName = ChannelFactory.padName(channelName);
        }
        catch (CicsException e) {
            return null;
        }
        Channel chan = this.namedChannels.get(paddedChannelName);
        if (chan == null) {
            chan = new Channel(channelName, 16, EnvironmentConstants.env);
            this.add(chan);
        }
        return chan;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected Channel getChannel(String string) {
        Channel result;
        cicsLog.logEntry("getChannel", new Object[]{string});
        String channelName = null;
        try {
            void chanName;
            channelName = ChannelFactory.padName((String)chanName);
        }
        catch (CicsException e) {
            Channel channel = null;
            cicsLog.logExit("getChannel", new Object[]{channel});
            return channel;
        }
        Channel channel = result = this.namedChannels.get(channelName);
        cicsLog.logExit("getChannel", new Object[]{channel});
        return channel;
    }
}

