/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.server.CICSFuture;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ChildResponse;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

@InjectLogging(loggerName="logger", isEnabled=true)
public class ChildResponseImpl
implements ChildResponse {
    private String abendCode = null;
    private Channel channel = null;
    private ChildResponse.CompletionStatus completionStatus = null;
    private byte[] token = null;
    private boolean isFetched = false;
    private static final String localCCSID = EnvironmentConstants.env.getLocalCCSID();

    protected ChildResponseImpl(byte[] childToken) {
        this.token = childToken;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof CICSFuture) {
            CICSFuture other = (CICSFuture)obj;
            byte[] otherToken = other.getChildResponse().getToken();
            if (Arrays.equals(this.token, otherToken)) {
                return true;
            }
        } else if (this.getClass() == obj.getClass()) {
            ChildResponseImpl other = (ChildResponseImpl)obj;
            if (Arrays.equals(this.token, other.token)) {
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.token);
    }

    @Override
    public ChildResponse.CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    @Override
    public String getAbendCode() {
        return this.abendCode;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    protected boolean isFetched() {
        return this.isFetched;
    }

    protected byte[] getToken() {
        return this.token;
    }

    protected void setResponse(byte[] childResponseData, boolean parseToken) {
        String codePage = "Cp037";
        String abCode = "";
        String channelName = "";
        try {
            abCode = new String(Arrays.copyOfRange(childResponseData, 0, 4), localCCSID);
            channelName = new String(Arrays.copyOfRange(childResponseData, 4, 20), codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (!abCode.startsWith(" ")) {
            this.abendCode = abCode;
        }
        if (!channelName.startsWith(" ")) {
            try {
                this.channel = new Channel(channelName, EnvironmentConstants.env);
            }
            catch (ChannelErrorException channelErrorException) {
                // empty catch block
            }
        }
        this.setCompletionStatus(childResponseData);
        if (parseToken) {
            this.token = Arrays.copyOfRange(childResponseData, 24, 40);
        }
        this.isFetched = true;
    }

    protected void setCompletionStatus(byte[] childResponseData) {
        int compStatus = ByteBuffer.wrap(Arrays.copyOfRange(childResponseData, 20, 24)).getInt();
        switch (compStatus) {
            case 1016: {
                this.completionStatus = ChildResponse.CompletionStatus.NORMAL;
                break;
            }
            case 900: {
                this.completionStatus = ChildResponse.CompletionStatus.ABEND;
                break;
            }
            case 1214: {
                this.completionStatus = ChildResponse.CompletionStatus.SECERROR;
                break;
            }
        }
    }
}

