/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.server.CicsRuntimeException;
import java.util.Arrays;

public class CicsUnexpectedRuntimeException
extends CicsRuntimeException {
    private static final Logger cicsLog = LoggerFactory.getLogger(CicsUnexpectedRuntimeException.class);
    private static final long serialVersionUID = -8730004316361319463L;
    private byte[] responseCode;
    private int resp;
    private int resp2;

    public CicsUnexpectedRuntimeException(String message, int resp, int resp2, byte[] responseCode, Throwable cause) {
        super(message, cause);
        this.setResp(resp);
        this.setResp2(resp2);
        this.setResponseCode(responseCode);
        cicsLog.logEntryExit("constructor", new Object[]{message, Integer.toString(resp), Integer.toString(resp2), responseCode, cause});
    }

    public byte[] getResponseCode() {
        return this.responseCode;
    }

    private void setResponseCode(byte[] responseCode) {
        this.responseCode = responseCode;
    }

    public int getResp() {
        return this.resp;
    }

    private void setResp(int resp) {
        this.resp = resp;
    }

    public int getResp2() {
        return this.resp2;
    }

    private void setResp2(int resp2) {
        this.resp2 = resp2;
    }

    @Override
    public String getMessage() {
        StringBuilder str = new StringBuilder();
        String superMessage = super.getMessage();
        if (superMessage != null) {
            str.append(superMessage);
        }
        str.append(" (RESP=");
        str.append(Integer.toString(this.resp));
        str.append(")");
        str.append(", RESP2=");
        str.append(Integer.toString(this.resp2));
        str.append(", ResponseCode");
        if (this.responseCode == null) {
            str.append("(null)");
        } else {
            str.append("[");
            str.append(Integer.toString(this.responseCode.length));
            str.append("]=");
            if (this.responseCode.length == 0) {
                str.append("empty");
            } else {
                int maxLength = this.responseCode.length;
                if (maxLength > 4) {
                    maxLength = 4;
                }
                for (int i = 0; i < maxLength; ++i) {
                    if (i > 0) {
                        str.append(", ");
                    }
                    str.append(Byte.toString(this.responseCode[i]));
                }
                if (maxLength < this.responseCode.length) {
                    str.append("...");
                }
            }
        }
        str.append(")");
        return str.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.resp;
        result = 31 * result + this.resp2;
        result = 31 * result + Arrays.hashCode(this.responseCode);
        result = 31 * result + super.getMessage().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CicsUnexpectedRuntimeException other = (CicsUnexpectedRuntimeException)obj;
        if (this.resp != other.resp) {
            return false;
        }
        if (this.resp2 != other.resp2) {
            return false;
        }
        if (!Arrays.equals(this.responseCode, other.responseCode)) {
            return false;
        }
        return this.getMessage().equals(other.getMessage());
    }
}

