/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.PaddingUtils;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateContainer;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.server.API;
import com.ibm.cics.server.CCSIDErrorException;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ChannelFactory;
import com.ibm.cics.server.CicsConditionException;
import com.ibm.cics.server.CicsException;
import com.ibm.cics.server.CodePageErrorException;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import java.nio.charset.Charset;

@InjectLogging(isEnabled=false)
public class Container
extends API {
    private static final Logger cicsLog = LoggerFactory.getLogger(Container.class);
    public static final int NOTSET = -1;
    public static final int DATATYPE_BIT = 1020;
    public static final int DATATYPE_CHAR = 1019;
    public static final int MAX_CONTAINER_NAME_LENGTH = 16;
    private String name;
    private Channel owner;
    private static final int RESP2_INVALID_CODEPAGE = 1;
    private DelegateContainer delegateContainer;
    private static final Charset JAVA_CHARSET = Charset.forName("UTF-16");
    private static final String JAVA_CHARSET_NAME = PaddingUtils.spacePad((String)JAVA_CHARSET.name(), (int)40);

    @InjectLogging
    Container(String containerName, Channel chan) throws ContainerErrorException {
        cicsLog.logEntry("<init>", new Object[]{containerName, chan});
        try {
            this.name = ChannelFactory.padName(containerName);
        }
        catch (CicsException e) {
            throw new ContainerErrorException("Container " + e.getMessage(), 18);
        }
        if (this.name == null) {
            throw new ContainerErrorException("Container name \"" + containerName + "\" is longer than " + 16 + " characters", 18);
        }
        this.owner = chan;
        this.delegateContainer = DelegateFactoryLoader.getDelegateFactory().createDelegateContainer(this.name, this.owner.getName());
        this.delegateContainer.setDataInCICS(false);
        cicsLog.logExit("<init>");
    }

    protected String getChannelName() {
        return this.owner.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getString() throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        byte[] ba;
        cicsLog.logEntryExit("getString", new Object[0]);
        try {
            ba = this.delegateContainer.getData(JAVA_CHARSET_NAME, false, -1, -1);
            this.containerExistsInCICS();
        }
        catch (DelegateError e) {
            Container.throwJCICSException(e);
            ba = null;
        }
        return new String(ba, JAVA_CHARSET);
    }

    private static void throwJCICSException(DelegateError e) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        switch (e.getCode()) {
            case CONTAINER_ERROR: {
                throw new ContainerErrorException(e.getMessage(), e.getResp2(), e);
            }
            case CHANNEL_ERROR: {
                throw new ChannelErrorException(e.getMessage(), e.getResp2(), e);
            }
            case CCSID_ERROR: {
                throw new CCSIDErrorException(e.getMessage(), e.getResp2(), e);
            }
            case CODE_PAGE_ERROR: {
                throw new CodePageErrorException(e.getMessage(), e.getResp2(), e);
            }
        }
        DelegateErrorHandler.handleUncheckedError(e);
    }

    @InjectLogging
    public byte[] get() throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        byte[] ba;
        cicsLog.logEntry("get");
        try {
            ba = this.delegateContainer.getData(null, false, -1, -1);
            this.containerExistsInCICS();
        }
        catch (DelegateError e) {
            Container.throwJCICSException(e);
            ba = null;
        }
        byte[] byArray = ba;
        cicsLog.logExit("get", new Object[]{byArray});
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public byte[] get(String string) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        byte[] ba;
        void targetCodePage;
        cicsLog.logEntry("get", new Object[]{string});
        String intoCodePage = targetCodePage;
        if (intoCodePage == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        intoCodePage = PaddingUtils.spacePad((String)intoCodePage, (int)40);
        try {
            ba = this.delegateContainer.getData(intoCodePage, false, -1, -1);
            this.containerExistsInCICS();
        }
        catch (DelegateError e) {
            Container.throwJCICSException(e);
            ba = null;
        }
        byte[] byArray = ba;
        cicsLog.logExit("get", new Object[]{byArray});
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public byte[] get(String string, int n, int n2) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        byte[] ba;
        void targetCodePage;
        String intoCodePage;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("get", new Object[]{string, new Integer(n), new Integer(n2)});
        }
        if ((intoCodePage = targetCodePage) == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        intoCodePage = PaddingUtils.spacePad((String)intoCodePage, (int)40);
        try {
            void sourceOffset;
            void length;
            ba = this.delegateContainer.getData(intoCodePage, false, (int)length, sourceOffset < 0 ? 0 : sourceOffset);
            this.containerExistsInCICS();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            Container.throwJCICSException(err);
            ba = null;
        }
        byte[] byArray = ba;
        cicsLog.logExit("get", new Object[]{byArray});
        return byArray;
    }

    @InjectLogging
    public byte[] getNoConvert() throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        byte[] ba;
        cicsLog.logEntry("getNoConvert");
        try {
            ba = this.delegateContainer.getData(null, true, -1, -1);
            this.containerExistsInCICS();
        }
        catch (DelegateError e) {
            Container.throwJCICSException(e);
            ba = null;
        }
        byte[] byArray = ba;
        cicsLog.logExit("getNoConvert", new Object[]{byArray});
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public byte[] getNoConvert(int n, int n2) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        byte[] ba;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("getNoConvert", new Object[]{new Integer(n), new Integer(n2)});
        }
        try {
            void offset;
            void length;
            ba = this.delegateContainer.getData(null, true, (int)length, offset < 0 ? 0 : offset);
            this.containerExistsInCICS();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            Container.throwJCICSException(err);
            ba = null;
        }
        byte[] byArray = ba;
        cicsLog.logExit("getNoConvert", new Object[]{byArray});
        return byArray;
    }

    public int get(byte[] destination, int sourceOffset, int length) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        return this.get(destination, 0, sourceOffset, length);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public int get(byte[] byArray, int n, int n2, int n3) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        int len;
        void length;
        void destination;
        void destinationOffset;
        void theSourceOffset;
        int sourceOffset;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("get", new Object[]{byArray, new Integer(n), new Integer(n2), new Integer(n3)});
        }
        if ((sourceOffset = theSourceOffset) < 0) {
            sourceOffset = 0;
        }
        if (destinationOffset < 0) {
            throw new IndexOutOfBoundsException("destinationOffset is less than zero: " + (int)destinationOffset);
        }
        if (destination == null) {
            throw new NullPointerException("destination byte[] is null");
        }
        if (destinationOffset > ((void)destination).length) {
            throw new IndexOutOfBoundsException("destinationOffset '" + (int)destinationOffset + "' is larger than the size of the destination byte[] '" + ((void)destination).length + "'");
        }
        if (((void)destination).length < destinationOffset + length) {
            throw new IndexOutOfBoundsException("Specified length '" + (int)length + "' exceeds the range of the destination byte[]");
        }
        try {
            len = this.delegateContainer.getInto((int)length, sourceOffset, (byte[])destination, (int)destinationOffset, false);
            this.containerExistsInCICS();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            Container.throwJCICSException(err);
            int n4 = 0;
            if (cicsLog.shouldTrace(LogType.EXIT)) {
                int n5 = n4;
                cicsLog.logExit("get", new Object[]{new Integer(n5)});
                n4 = n5;
            }
            return n4;
        }
        int n6 = len;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n7 = n6;
            cicsLog.logExit("get", new Object[]{new Integer(n7)});
            n6 = n7;
        }
        return n6;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public int getNoConvert(byte[] byArray, int n, int n2, int n3) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        int len;
        void length;
        void destination;
        void destinationOffset;
        void theSourceOffset;
        int sourceOffset;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("getNoConvert", new Object[]{byArray, new Integer(n), new Integer(n2), new Integer(n3)});
        }
        if ((sourceOffset = theSourceOffset) < 0) {
            sourceOffset = 0;
        }
        if (destinationOffset < 0) {
            throw new IndexOutOfBoundsException("destinationOffset is less than zero: " + (int)destinationOffset);
        }
        if (destination == null) {
            throw new NullPointerException("destination byte[] is null");
        }
        if (destinationOffset > ((void)destination).length) {
            throw new IndexOutOfBoundsException("destinationOffset '" + (int)destinationOffset + "' is larger than the size of the destination byte[] '" + ((void)destination).length + "'");
        }
        if (((void)destination).length < destinationOffset + length) {
            throw new IndexOutOfBoundsException("Specified length '" + (int)length + "' exceeds the range of the destination byte[]");
        }
        try {
            len = this.delegateContainer.getInto((int)length, sourceOffset, (byte[])destination, (int)destinationOffset, true);
            this.containerExistsInCICS();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            Container.throwJCICSException(err);
            int n4 = 0;
            if (cicsLog.shouldTrace(LogType.EXIT)) {
                int n5 = n4;
                cicsLog.logExit("getNoConvert", new Object[]{new Integer(n5)});
                n4 = n5;
            }
            return n4;
        }
        int n6 = len;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n7 = n6;
            cicsLog.logExit("getNoConvert", new Object[]{new Integer(n7)});
            n6 = n7;
        }
        return n6;
    }

    public int getNoConvert(byte[] destination, int sourceOffset, int length) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        return this.getNoConvert(destination, 0, sourceOffset, length);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public byte[] get(int n, int n2) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, LengthErrorException {
        byte[] ba;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("get", new Object[]{new Integer(n), new Integer(n2)});
        }
        try {
            void sourceOffset;
            void length;
            ba = this.delegateContainer.getData(null, false, (int)length, sourceOffset < 0 ? 0 : sourceOffset);
            this.containerExistsInCICS();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            Container.throwJCICSException(err);
            ba = null;
        }
        byte[] byArray = ba;
        cicsLog.logExit("get", new Object[]{byArray});
        return byArray;
    }

    @InjectLogging
    public boolean exists() {
        cicsLog.logEntry("exists");
        boolean isExists = false;
        try {
            this.getLength();
            isExists = true;
        }
        catch (CicsConditionException ex) {
            cicsLog.logDebug("Container is not accessable. So in effect does not exist.", new Object[]{ex});
            this.setDataInCICS(false);
            this.owner.containerRemovedFromCicsEvent(this);
        }
        boolean bl = isExists;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            boolean bl2 = bl;
            cicsLog.logExit("exists", new Object[]{new Boolean(bl2)});
            bl = bl2;
        }
        return bl;
    }

    @InjectLogging
    public int getLength() throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        int len;
        cicsLog.logEntry("getLength");
        try {
            len = this.delegateContainer.getLength(null, false);
            this.containerExistsInCICS();
        }
        catch (DelegateError err) {
            this.owner.containerRemovedFromCicsEvent(this);
            Container.throwJCICSException(err);
            len = 0;
        }
        int n = len;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n2 = n;
            cicsLog.logExit("getLength", new Object[]{new Integer(n2)});
            n = n2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public int getLength(String string) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        int len;
        void targetCodePage;
        cicsLog.logEntry("getLength", new Object[]{string});
        String intoCodePage = targetCodePage;
        if (intoCodePage == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        intoCodePage = PaddingUtils.spacePad((String)intoCodePage, (int)40);
        try {
            len = this.delegateContainer.getLength(intoCodePage, false);
            this.containerExistsInCICS();
        }
        catch (DelegateError err) {
            this.owner.containerRemovedFromCicsEvent(this);
            Container.throwJCICSException(err);
            len = 0;
        }
        int n = len;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n2 = n;
            cicsLog.logExit("getLength", new Object[]{new Integer(n2)});
            n = n2;
        }
        return n;
    }

    @InjectLogging
    public int getLengthNoConvert() throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        int len;
        cicsLog.logEntry("getLengthNoConvert");
        try {
            len = this.delegateContainer.getLength(null, true);
            this.containerExistsInCICS();
        }
        catch (DelegateError err) {
            cicsLog.logDebug("getLengthNoConvert", new Object[]{"could not get container length", err});
            Container.throwJCICSException(err);
            len = 0;
        }
        int n = len;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n2 = n;
            cicsLog.logExit("getLengthNoConvert", new Object[]{new Integer(n2)});
            n = n2;
        }
        return n;
    }

    public int getCCSID() {
        return this.delegateContainer.getCCSID();
    }

    @InjectLogging
    public int getDatatype() throws ContainerErrorException, ChannelErrorException {
        cicsLog.logEntry("getDatatype");
        int dataType = -1;
        try {
            dataType = this.delegateContainer.getDataType(this.owner.getName());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case CONTAINER_ERROR: {
                    throw new ContainerErrorException(err.getMessage(), err.getResp2(), err);
                }
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        int n = dataType;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n2 = n;
            cicsLog.logExit("getDatatype", new Object[]{new Integer(n2)});
            n = n2;
        }
        return n;
    }

    public void append(byte[] byteArrayData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        cicsLog.logEntryExit("append", new Object[]{byteArrayData});
        this.putContainerCheckParmsAndCall(byteArrayData, null, -1, true, false);
    }

    public void prepend(byte[] byteArrayData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        cicsLog.logEntryExit("prepend", new Object[]{byteArrayData});
        this.putContainerCheckParmsAndCall(byteArrayData, null, -1, false, true);
    }

    public void put(byte[] byteArrayData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        cicsLog.logEntryExit("put(byte[])", new Object[0]);
        this.putContainerCheckParmsAndCall(byteArrayData, null, -1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    private void putContainerCheckParmsAndCall(byte[] byArray, String string, int n, boolean bl, boolean bl2) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        void prepend;
        void append;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("putContainerCheckParmsAndCall", new Object[]{byArray, string, new Integer(n), new Boolean(bl), new Boolean(bl2)});
        }
        if ((append & prepend) != 0) {
            throw new IllegalArgumentException("append and prepend both set to true");
        }
        try {
            void datatype;
            void fromCodepage;
            void byteArrayData;
            this.delegateContainer.put((byte[])byteArrayData, (String)fromCodepage, (int)datatype, (boolean)append, (boolean)prepend);
            this.containerExistsInCICS();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case CONTAINER_ERROR: {
                    throw new ContainerErrorException(err.getMessage(), err.getResp2(), err);
                }
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case CCSID_ERROR: {
                    throw new CCSIDErrorException(err.getMessage(), err.getResp2(), err);
                }
                case CODE_PAGE_ERROR: {
                    throw new CodePageErrorException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("putContainerCheckParmsAndCall");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void append(byte[] byArray, String string) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        void byteArrayData;
        void sourceCodePage;
        String fromCodePage;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("append", new Object[]{byArray, string});
        }
        if ((fromCodePage = sourceCodePage) == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        fromCodePage = PaddingUtils.spacePad((String)fromCodePage, (int)40);
        this.putContainerCheckParmsAndCall((byte[])byteArrayData, fromCodePage, 1019, true, false);
        cicsLog.logExit("append");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void prepend(byte[] byArray, String string) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        void byteArrayData;
        void sourceCodePage;
        String fromCodePage;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("prepend", new Object[]{byArray, string});
        }
        if ((fromCodePage = sourceCodePage) == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        fromCodePage = PaddingUtils.spacePad((String)fromCodePage, (int)40);
        this.putContainerCheckParmsAndCall((byte[])byteArrayData, fromCodePage, 1019, false, true);
        cicsLog.logExit("prepend");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void put(byte[] byArray, String string) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        void byteArrayData;
        void sourceCodePage;
        String fromCodePage;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("put", new Object[]{byArray, string});
        }
        if ((fromCodePage = sourceCodePage) == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        fromCodePage = PaddingUtils.spacePad((String)fromCodePage, (int)40);
        this.putContainerCheckParmsAndCall((byte[])byteArrayData, fromCodePage, 1019, false, false);
        cicsLog.logExit("put");
    }

    public void appendString(String stringData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        String thisMethod = "appendString";
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            int length = 0;
            if (stringData != null) {
                length = stringData.length();
            }
            cicsLog.logEntry("appendString", new Object[]{String.valueOf(length)});
        }
        byte[] value = stringData == null ? null : stringData.getBytes(JAVA_CHARSET);
        this.putContainerCheckParmsAndCall(value, JAVA_CHARSET_NAME, 1019, true, false);
        cicsLog.logExit("appendString");
    }

    public void prependString(String stringData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        String thisMethod = "prependString";
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            int length = 0;
            if (stringData != null) {
                length = stringData.length();
            }
            cicsLog.logEntry("prependString", new Object[]{String.valueOf(length)});
        }
        byte[] value = stringData == null ? null : stringData.getBytes(JAVA_CHARSET);
        this.putContainerCheckParmsAndCall(value, JAVA_CHARSET_NAME, 1019, false, true);
        cicsLog.logExit("prependString");
    }

    public void putString(String stringData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        String thisMethod = "putString(String)";
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            int length = 0;
            if (stringData != null) {
                length = stringData.length();
            }
            cicsLog.logEntry("putString(String)", new Object[]{String.valueOf(length)});
        }
        byte[] value = stringData == null ? null : stringData.getBytes(JAVA_CHARSET);
        this.putContainerCheckParmsAndCall(value, JAVA_CHARSET_NAME, 1019, false, false);
        cicsLog.logExit("putString(String)");
    }

    @InjectLogging
    public void delete() throws ContainerErrorException, ChannelErrorException, InvalidRequestException {
        cicsLog.logEntry("delete");
        try {
            this.delegateContainer.delete();
            this.owner.containerRemovedFromCicsEvent(this);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case CONTAINER_ERROR: {
                    throw new ContainerErrorException(err.getMessage(), err.getResp2(), err.getCause());
                }
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(err.getMessage(), err.getResp2(), err.getCause());
                }
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), err.getCause());
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("delete");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    protected void setDataInCICS(boolean bl) {
        void newValue;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setDataInCICS", new Object[]{new Boolean(bl)});
        }
        this.delegateContainer.setDataInCICS((boolean)newValue);
        if (newValue != false && this.owner != null) {
            this.owner.containerExistsInCicsEvent(this);
        }
        cicsLog.logExit("setDataInCICS");
    }

    protected boolean isDataInCICS() {
        return this.delegateContainer.isDataInCICS();
    }

    protected void containerExistsInCICS() {
        this.setDataInCICS(true);
    }

    public String toString() {
        return "Container(name='" + this.name + "')";
    }
}

