/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateDataHolder;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.comms.DelegateConversation;
import com.ibm.cics.delegate.comms.DelegateConversationState;
import com.ibm.cics.delegate.comms.DelegateSyncLevel;
import com.ibm.cics.server.API;
import com.ibm.cics.server.ConversationSendOptions;
import com.ibm.cics.server.ConversationState;
import com.ibm.cics.server.DataHolder;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.EndOfChainIndicatorException;
import com.ibm.cics.server.InboundSignalException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAllocatedException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.SyncLevel;
import com.ibm.cics.server.TerminalException;

@InjectLogging(isEnabled=false)
public class Conversation
extends API {
    private DelegateConversation delegate;
    private static final Logger cicsLog = LoggerFactory.getLogger(Conversation.class);

    Conversation() {
        this(DelegateFactoryLoader.getDelegateFactory().createDelegateConversation());
    }

    @InjectLogging
    Conversation(DelegateConversation delegateToUse) {
        cicsLog.logEntry("<init>", new Object[]{delegateToUse});
        this.delegate = delegateToUse;
        cicsLog.logExit("<init>");
    }

    protected DelegateConversation getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void converse(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        cicsLog.logEntry("converse", new Object[]{dataHolder});
        try {
            void data;
            DelegateDataHolder delegateDataHolder = data.getDelegate();
            this.delegate.converse(delegateDataHolder);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case END_OF_CHAIN_INDICATOR: {
                    throw new EndOfChainIndicatorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case INBOUND_SIGNAL: {
                    throw new InboundSignalException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("converse");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void converse(DataHolder dataHolder, int n, boolean bl) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("converse", new Object[]{dataHolder, new Integer(n), new Boolean(bl)});
        }
        try {
            void retainExcess;
            void maxLength;
            void data;
            DelegateDataHolder delegateDataHolder = data.getDelegate();
            this.delegate.converse(delegateDataHolder, (int)maxLength, (boolean)retainExcess);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case END_OF_CHAIN_INDICATOR: {
                    throw new EndOfChainIndicatorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case INBOUND_SIGNAL: {
                    throw new InboundSignalException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("converse");
    }

    @InjectLogging
    public void flush() throws InvalidRequestException, NotAllocatedException {
        cicsLog.logEntry("flush");
        try {
            this.delegate.flush();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("flush");
    }

    @InjectLogging
    public void free() throws InvalidRequestException, NotAllocatedException, NotAuthorisedException, InvalidSystemIdException {
        cicsLog.logEntry("free");
        try {
            this.delegate.free();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("free");
    }

    public byte[] getConvId() {
        return this.delegate.getConvId();
    }

    public boolean getDataComplete() {
        return this.delegate.isDataComplete();
    }

    public int getErrorCode() {
        return this.delegate.getErrorCode();
    }

    public boolean getErrorOccurred() {
        return this.delegate.isErrorOccurred();
    }

    public boolean getNoData() {
        return this.delegate.isNoData();
    }

    public boolean getSignalReceived() {
        return this.delegate.isSignalReceived();
    }

    public ConversationState getState() {
        DelegateConversationState state = DelegateConversationState.ALLOCATED;
        try {
            state = this.delegate.getState();
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
        int stateValue = state.getValue();
        ConversationState jcicsState = ConversationState.lookup(stateValue);
        return jcicsState;
    }

    public SyncLevel getSyncLevel() {
        DelegateSyncLevel delegateLevel = this.delegate.getSyncLevel();
        int value = delegateLevel.getValue();
        SyncLevel jcicsSyncLevel = SyncLevel.lookup(value);
        return jcicsSyncLevel;
    }

    @InjectLogging
    public void issueAbend() throws InvalidRequestException, NotAllocatedException, TerminalException {
        cicsLog.logEntry("issueAbend");
        try {
            this.delegate.issueAbend();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("issueAbend");
    }

    @InjectLogging
    public void issueConfirmation() throws InvalidRequestException, NotAllocatedException, TerminalException {
        cicsLog.logEntry("issueConfirmation");
        try {
            this.delegate.issueConfirmation();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("issueConfirmation");
    }

    @InjectLogging
    public void issueError() throws InvalidRequestException, NotAllocatedException, TerminalException {
        cicsLog.logEntry("issueError");
        try {
            this.delegate.issueError();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("issueError");
    }

    @InjectLogging
    public void issuePrepare() throws InvalidRequestException, NotAllocatedException, TerminalException {
        cicsLog.logEntry("issuePrepare");
        try {
            this.delegate.issuePrepare();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("issuePrepare");
    }

    @InjectLogging
    public void issueSignal() throws InvalidRequestException, NotAllocatedException, TerminalException {
        cicsLog.logEntry("issueSignal");
        try {
            this.delegate.issueSignal();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("issueSignal");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void receive(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        cicsLog.logEntry("receive", new Object[]{dataHolder});
        try {
            void data;
            DelegateDataHolder delegateDataHolder = data.getDelegate();
            this.delegate.receive(delegateDataHolder);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case END_OF_CHAIN_INDICATOR: {
                    throw new EndOfChainIndicatorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case INBOUND_SIGNAL: {
                    throw new InboundSignalException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("receive");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void receive(DataHolder dataHolder, int n, boolean bl) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("receive", new Object[]{dataHolder, new Integer(n), new Boolean(bl)});
        }
        try {
            void retainExcess;
            void maxLength;
            void data;
            DelegateDataHolder delegateDataHolder = data.getDelegate();
            this.delegate.receive(delegateDataHolder, (int)maxLength, (boolean)retainExcess);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case END_OF_CHAIN_INDICATOR: {
                    throw new EndOfChainIndicatorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case INBOUND_SIGNAL: {
                    throw new InboundSignalException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("receive");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void send(byte[] byArray) throws InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("send", new Object[]{byArray});
        }
        try {
            void data;
            this.delegate.send((byte[])data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case INBOUND_SIGNAL: {
                    throw new InboundSignalException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("send");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void send(byte[] byArray, ConversationSendOptions conversationSendOptions) throws InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("send", new Object[]{byArray, conversationSendOptions});
        }
        try {
            void options;
            void data;
            this.delegate.send((byte[])data, options.getInvite(), options.getLast(), options.getConfirm(), options.getWait());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case INBOUND_SIGNAL: {
                    throw new InboundSignalException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("send");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void send(ConversationSendOptions conversationSendOptions) throws InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        cicsLog.logEntry("send", new Object[]{conversationSendOptions});
        try {
            void options;
            this.delegate.send(options.getInvite(), options.getLast(), options.getConfirm(), options.getWait());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_ALLOCATED: {
                    throw new NotAllocatedException(err.getMessage(), err.getResp2(), err);
                }
                case INBOUND_SIGNAL: {
                    throw new InboundSignalException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("send");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    void setBits(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        void noData;
        void errorOccurred;
        void signalReceived;
        void dataComplete;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setBits", new Object[]{new Boolean(bl), new Boolean(bl2), new Boolean(bl3), new Boolean(bl4)});
        }
        this.delegate.setBits((boolean)dataComplete, (boolean)signalReceived, (boolean)errorOccurred, (boolean)noData);
        cicsLog.logExit("setBits");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    void setConvId(byte[] byArray) {
        void convId;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setConvId", new Object[]{byArray});
        }
        this.delegate.setConvId((byte[])convId);
        cicsLog.logExit("setConvId");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    void setErrorCode(int n) {
        void errorCode;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setErrorCode", new Object[]{new Integer(n)});
        }
        this.delegate.setErrorCode((int)errorCode);
        cicsLog.logExit("setErrorCode");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    void setSyncLevel(int n) {
        void syncLevelValue;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setSyncLevel", new Object[]{new Integer(n)});
        }
        this.delegate.setSyncLevel(DelegateSyncLevel.fromInt((int)syncLevelValue));
        cicsLog.logExit("setSyncLevel");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    void setSyncLevel(SyncLevel syncLevel) {
        void syncLevel2;
        cicsLog.logEntry("setSyncLevel", new Object[]{syncLevel});
        this.delegate.setSyncLevel(DelegateSyncLevel.fromInt((int)syncLevel2.hashCode()));
        cicsLog.logExit("setSyncLevel");
    }
}

