/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.InvalidRequestException;
import java.util.BitSet;

public class ConversationSendOptions {
    private static final int INVITE_BIT = 0;
    private static final int LAST_BIT = 1;
    private static final int CONFIRM_BIT = 2;
    private static final int WAIT_BIT = 3;
    private static final int NUMBER_OF_BITS = 4;
    private BitSet bits = new BitSet(4);

    public void clearAll() {
        this.bits.clear(0);
        this.bits.clear(1);
        this.bits.clear(2);
        this.bits.clear(3);
    }

    public void clearConfirm() {
        this.bits.clear(2);
    }

    public void clearInvite() {
        this.bits.clear(0);
    }

    public void clearLast() {
        this.bits.clear(1);
    }

    public void clearWait() {
        this.bits.clear(3);
    }

    public boolean getConfirm() {
        return this.bits.get(2);
    }

    public boolean getInvite() {
        return this.bits.get(0);
    }

    public boolean getLast() {
        return this.bits.get(1);
    }

    public boolean getWait() {
        return this.bits.get(3);
    }

    public void setConfirm() throws InvalidRequestException {
        if (this.bits.get(3)) {
            throw new InvalidRequestException("CONFIRM invalid if WAIT set", 0);
        }
        this.bits.set(2);
    }

    public void setInvite() throws InvalidRequestException {
        if (this.bits.get(1)) {
            throw new InvalidRequestException("INVITE invalid if LAST set", 0);
        }
        this.bits.set(0);
    }

    public void setLast() throws InvalidRequestException {
        if (this.bits.get(0)) {
            throw new InvalidRequestException("LAST invalid if INVITE set", 0);
        }
        this.bits.set(1);
    }

    public void setWait() throws InvalidRequestException {
        if (this.bits.get(2)) {
            throw new InvalidRequestException("WAIT invalid if CONFIRM set", 0);
        }
        this.bits.set(3);
    }
}

