/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.delegate.DelegateDataHolder;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.server.IHolder;
import java.io.UnsupportedEncodingException;

public class DataHolder
implements IHolder {
    private static final String localCCSID = EnvironmentConstants.env.getLocalCCSID();
    private DelegateDataHolder delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateDataHolder();

    @Override
    public byte[] getValue() {
        return this.delegate.getValue();
    }

    @Override
    public String getStringValue() {
        String result;
        if (localCCSID != null) {
            try {
                result = new String(this.delegate.getValue(), localCCSID);
            }
            catch (UnsupportedEncodingException e) {
                result = new String(this.delegate.getValue());
            }
        } else {
            result = new String(this.delegate.getValue());
        }
        return result;
    }

    public void setValue(byte[] value) {
        this.delegate.setValue(value);
    }

    public void setStringValue(String valueToSet) {
        if (localCCSID != null) {
            try {
                this.delegate.setValue(valueToSet.getBytes(localCCSID));
            }
            catch (UnsupportedEncodingException e) {
                this.delegate.setValue(valueToSet.getBytes());
            }
        } else {
            this.delegate.setValue(valueToSet.getBytes());
        }
    }

    DelegateDataHolder getDelegate() {
        return this.delegate;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("DelegateDataHolder:[");
        str.append(this.hashCode());
        str.append("] ");
        str.append("(value:");
        if (this.delegate.getValue() == null) {
            str.append("null");
        } else {
            str.append(" length:");
            str.append(this.delegate.getValue().length);
            str.append(" ");
            if (this.delegate.getValue().length > 0) {
                str.append(" 0x");
                str.append(String.format("%02x", new Byte(this.delegate.getValue()[0])));
            }
            if (this.delegate.getValue().length > 1) {
                str.append(" 0x");
                str.append(String.format("%02x", new Byte(this.delegate.getValue()[1])));
            }
            if (this.delegate.getValue().length > 2) {
                str.append(" ...");
            }
        }
        str.append(")");
        return str.toString();
    }
}

