/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.server.AbendCancelException;
import com.ibm.cics.server.AbendException;
import com.ibm.cics.server.CicsRuntimeException;
import com.ibm.cics.server.CicsUnexpectedRuntimeException;
import com.ibm.cics.server.TaskAlreadyBoundRuntimeException;
import com.ibm.cics.server.TransferOfControlException;
import java.util.Optional;

public class DelegateErrorHandler {
    private static final Logger cicsLog = LoggerFactory.getLogger(DelegateErrorHandler.class);

    public static void handleUncheckedError(DelegateError err) {
        cicsLog.logEntryExit("handleUncheckedError", new Object[]{err});
        switch (err.getCode()) {
            case CICS_RUNTIME: {
                throw new CicsRuntimeException(err.getMessage(), err);
            }
            case ABEND: {
                throw new AbendException(err.getMessage(), (String)err.getABCode().get(), err);
            }
            case ABEND_CANCEL: {
                Optional abCode = err.getABCode();
                throw new AbendCancelException(err.getMessage(), abCode.orElse(null), err);
            }
            case TASK_ALREADY_BOUND_RUNTIME: {
                throw new TaskAlreadyBoundRuntimeException(err.getMessage(), err);
            }
            case TRANSFER_OF_CONTROL: {
                throw new TransferOfControlException(err.getMessage(), err);
            }
        }
        throw new CicsUnexpectedRuntimeException("Unexpected error from Delegate layer: " + err.getMessage(), err.getResp(), err.getResp2(), err.getResponseCode(), err);
    }
}

