/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateDocument;
import com.ibm.cics.server.API;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.DocumentLocation;
import com.ibm.cics.server.DuplicateRecordException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.SymbolErrorException;
import com.ibm.cics.server.SymbolList;
import com.ibm.cics.server.TemplateErrorException;

@InjectLogging(isEnabled=false)
public class Document
extends API {
    private DelegateDocument delegate;
    private static final Logger cicsLog = LoggerFactory.getLogger(Document.class);

    @InjectLogging
    public Document() throws InvalidRequestException {
        cicsLog.logEntry("<init>");
        try {
            this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateDocument();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public Document(byte[] docToken) {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("<init>", new Object[]{docToken});
        }
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateDocument(docToken);
        cicsLog.logExit("<init>");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void createFromDocRetrieve(byte[] byArray) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("createFromDocRetrieve", new Object[]{byArray});
        }
        try {
            void from;
            this.delegate.createFromDocRetrieve((byte[])from);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("createFromDocRetrieve");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void createFromTemplate(String string) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("createFromTemplate", new Object[]{string});
        try {
            void from;
            this.delegate.createFromTemplate((String)from);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("createFromTemplate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void createText(String string) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("createText", new Object[]{string});
        try {
            void text;
            this.delegate.createText((String)text, null);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("createText");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void createText(String string, String string2) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("createText", new Object[]{string, string2});
        try {
            void hostCodePage;
            void text;
            this.delegate.createText((String)text, (String)hostCodePage);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("createText");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void createBinary(byte[] byArray) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("createBinary", new Object[]{byArray});
        }
        try {
            void binary;
            this.delegate.createBinary((byte[])binary);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("createBinary");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void createFromDoc(Document document) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("createFromDoc", new Object[]{document});
        try {
            void fromDoc;
            this.delegate.createFromDoc(fromDoc.delegate);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("createFromDoc");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void createTemplate(String string) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("createTemplate", new Object[]{string});
        try {
            void template;
            this.delegate.createTemplate((String)template, null);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("createTemplate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void createTemplate(String string, String string2) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("createTemplate", new Object[]{string, string2});
        try {
            void hostCodePage;
            void template;
            this.delegate.createTemplate((String)template, (String)hostCodePage);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("createTemplate");
    }

    public byte[] getDocToken() throws RecordNotFoundException {
        byte[] result = null;
        try {
            result = this.delegate.getDocToken();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        return result;
    }

    public int getDocSize() throws RecordNotFoundException {
        int docSize = 0;
        try {
            docSize = this.delegate.getDocSize();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        return docSize;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendFromDocRetrieve(byte[] byArray) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("appendFromDocRetrieve", new Object[]{byArray});
        }
        try {
            void from;
            this.delegate.appendFromDocRetrieve((byte[])from);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendFromDocRetrieve");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendFromTemplate(String string) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendFromTemplate", new Object[]{string});
        try {
            void from;
            this.delegate.appendFromTemplate((String)from);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendFromTemplate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendBinary(byte[] byArray) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("appendBinary", new Object[]{byArray});
        }
        try {
            void binary;
            this.delegate.appendBinary((byte[])binary);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendBinary");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendText(String string) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendText", new Object[]{string});
        try {
            void text;
            this.delegate.appendText((String)text, null);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendText");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendText(String string, String string2) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendText", new Object[]{string, string2});
        try {
            void hostCodePage;
            void text;
            this.delegate.appendText((String)text, (String)hostCodePage);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendText");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendLine(String string, String string2) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendLine", new Object[]{string, string2});
        try {
            void hostCodePage;
            void text;
            this.delegate.appendLine((String)text, (String)hostCodePage);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendLine");
    }

    @InjectLogging
    public void appendCRLF() throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendCRLF");
        try {
            this.delegate.appendCRLF();
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendCRLF");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendSymbol(String string) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendSymbol", new Object[]{string});
        try {
            void symbol;
            this.delegate.appendSymbol((String)symbol, null);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendSymbol");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendSymbol(String string, String string2) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendSymbol", new Object[]{string, string2});
        try {
            void hostCodePage;
            void symbol;
            this.delegate.appendSymbol((String)symbol, (String)hostCodePage);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendSymbol");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendTemplate(String string) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendTemplate", new Object[]{string});
        try {
            void template;
            this.delegate.appendTemplate((String)template, null);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendTemplate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendTemplate(String string, String string2) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendTemplate", new Object[]{string, string2});
        try {
            void hostCodePage;
            void template;
            this.delegate.appendTemplate((String)template, (String)hostCodePage);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendTemplate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendDocument(Document document) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendDocument", new Object[]{document});
        try {
            void doc;
            this.delegate.appendDocument(doc.delegate);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendDocument");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void appendBookmark(String string) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("appendBookmark", new Object[]{string});
        try {
            void bookmark;
            this.delegate.appendBookmark((String)bookmark);
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("appendBookmark");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertFromDocRetrieve(byte[] byArray, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("insertFromDocRetrieve", new Object[]{byArray, documentLocation});
        }
        try {
            void locn;
            void from;
            this.delegate.insertFromDocRetrieve((byte[])from, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertFromDocRetrieve");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertFromTemplate(String string, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("insertFromTemplate", new Object[]{string, documentLocation});
        try {
            void locn;
            void from;
            this.delegate.insertFromTemplate((String)from, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertFromTemplate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertBinary(byte[] byArray, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("insertBinary", new Object[]{byArray, documentLocation});
        }
        try {
            void locn;
            void binary;
            this.delegate.insertBinary((byte[])binary, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertBinary");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertText(String string, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("insertText", new Object[]{string, documentLocation});
        try {
            void locn;
            void text;
            this.delegate.insertText((String)text, null, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertText");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertText(String string, String string2, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("insertText", new Object[]{string, string2, documentLocation});
        try {
            void locn;
            void hostCodePage;
            void text;
            this.delegate.insertText((String)text, (String)hostCodePage, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertText");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertSymbol(String string, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("insertSymbol", new Object[]{string, documentLocation});
        try {
            void locn;
            void symbol;
            this.delegate.insertSymbol((String)symbol, null, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertSymbol");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertSymbol(String string, String string2, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("insertSymbol", new Object[]{string, string2, documentLocation});
        try {
            void locn;
            void hostCodePage;
            void symbol;
            this.delegate.insertSymbol((String)symbol, (String)hostCodePage, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertSymbol");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertTemplate(String string, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("insertTemplate", new Object[]{string, documentLocation});
        try {
            void locn;
            void template;
            this.delegate.insertTemplate((String)template, null, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertTemplate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertTemplate(String string, String string2, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("insertTemplate", new Object[]{string, string2, documentLocation});
        try {
            void locn;
            void hostCodePage;
            void template;
            this.delegate.insertTemplate((String)template, (String)hostCodePage, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertTemplate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertDocument(Document document, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("insertDocument", new Object[]{document, documentLocation});
        try {
            void locn;
            void doc;
            this.delegate.insertDocument(doc.delegate, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertDocument");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void insertBookmark(String string, DocumentLocation documentLocation) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        cicsLog.logEntry("insertBookmark", new Object[]{string, documentLocation});
        try {
            void locn;
            void bookmark;
            this.delegate.insertBookmark((String)bookmark, locn.getAt(), locn.getTo());
        }
        catch (DelegateError err) {
            Document.delegateErrorToCommonJcicsErrors(err);
        }
        cicsLog.logExit("insertBookmark");
    }

    @InjectLogging
    public byte[] retrieve() throws InvalidRequestException, RecordNotFoundException {
        cicsLog.logEntry("retrieve");
        byte[] bytesRetrieved = null;
        try {
            bytesRetrieved = this.delegate.retrieve(null, true);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        byte[] byArray = bytesRetrieved;
        cicsLog.logExit("retrieve", new Object[]{byArray});
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public byte[] retrieve(String string) throws InvalidRequestException, RecordNotFoundException {
        cicsLog.logEntry("retrieve", new Object[]{string});
        byte[] bytesRetrieved = null;
        try {
            void characterset;
            bytesRetrieved = this.delegate.retrieve((String)characterset, false);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        byte[] byArray = bytesRetrieved;
        cicsLog.logExit("retrieve", new Object[]{byArray});
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public byte[] retrieve(String string, boolean bl) throws InvalidRequestException, RecordNotFoundException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("retrieve", new Object[]{string, new Boolean(bl)});
        }
        byte[] bytesRetrieved = null;
        try {
            void dataOnly;
            void characterset;
            bytesRetrieved = this.delegate.retrieve((String)characterset, (boolean)dataOnly);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        byte[] byArray = bytesRetrieved;
        cicsLog.logExit("retrieve", new Object[]{byArray});
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void addSymbol(String string, String string2) throws InvalidRequestException, RecordNotFoundException, SymbolErrorException, LengthErrorException {
        cicsLog.logEntry("addSymbol", new Object[]{string, string2});
        try {
            void value;
            void symbol;
            this.delegate.addSymbol((String)symbol, (String)value);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case SYMBOL_ERROR: {
                    throw new SymbolErrorException(err.getMessage(), err.getResp2());
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("addSymbol");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setSymbolList(SymbolList symbolList) throws InvalidRequestException, RecordNotFoundException, SymbolErrorException, LengthErrorException {
        cicsLog.logEntry("setSymbolList", new Object[]{symbolList});
        try {
            void symbolList2;
            this.delegate.setSymbolList(symbolList2.getSymbolListAsByteArray(), symbolList2.getDelimiter(), symbolList2.getUnescaped());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case SYMBOL_ERROR: {
                    throw new SymbolErrorException(err.getMessage(), err.getResp2());
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("setSymbolList");
    }

    @InjectLogging
    public void delete() throws RecordNotFoundException {
        cicsLog.logEntry("delete");
        try {
            this.delegate.delete();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("delete");
    }

    protected void docDeleted() {
        this.delegate.docDeleted();
    }

    private static void delegateErrorToCommonJcicsErrors(DelegateError err) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        switch (err.getCode()) {
            case DUPLICATE_RECORD: {
                throw new DuplicateRecordException(err.getMessage(), err.getResp2(), err);
            }
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case NOT_AUTHORISED: {
                throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
            }
            case RECORD_NOT_FOUND: {
                throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
            }
            case TEMPLATE_ERROR: {
                throw new TemplateErrorException(err.getMessage(), err.getResp2());
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }
}

