/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.events.DelegateEventTracer;
import com.ibm.cics.server.API;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import java.io.Serializable;

@InjectLogging(isEnabled=false)
public class EnterRequest
extends API
implements Serializable {
    private static final String OMIT_RESOURCE = "";
    private static final String EMPTY_RESOURCE = "        ";
    private static final long serialVersionUID = 2241031188438446763L;
    private short traceIdentifier;
    private String resource;
    private boolean exception;
    private DelegateEventTracer delegate;
    private static final Logger cicsLog = LoggerFactory.getLogger(EnterRequest.class);

    @InjectLogging
    public EnterRequest() {
        cicsLog.logEntry("<init>");
        this.traceIdentifier = 0;
        this.resource = OMIT_RESOURCE;
        this.exception = false;
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateEventTracer();
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public void enterTrace() throws InvalidRequestException, LengthErrorException {
        cicsLog.logEntry("enterTrace");
        this.enterTrace(null);
        cicsLog.logExit("enterTrace");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void enterTrace(byte[] byArray) throws InvalidRequestException, LengthErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("enterTrace", new Object[]{byArray});
        }
        try {
            void data;
            this.delegate.traceEvent(this.getTraceIdentifier(), this.getResource(), this.isException(), (byte[])data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("enterTrace");
    }

    public String getResource() {
        return this.resource;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setResource(String string) {
        void resource;
        cicsLog.logEntry("setResource", new Object[]{string});
        if (resource == null) {
            this.resource = OMIT_RESOURCE;
            cicsLog.logExit("setResource");
            return;
        }
        if (resource.isEmpty()) {
            this.resource = OMIT_RESOURCE;
            cicsLog.logExit("setResource");
            return;
        }
        String localResource = ((String)resource + EMPTY_RESOURCE).substring(0, 8);
        if (localResource.equals(EMPTY_RESOURCE)) {
            this.resource = OMIT_RESOURCE;
            cicsLog.logExit("setResource");
            return;
        }
        this.resource = localResource;
        cicsLog.logExit("setResource");
    }

    public short getTraceIdentifier() {
        return this.traceIdentifier;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setTraceIdentifier(short s) {
        void traceId;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setTraceIdentifier", new Object[]{new Short(s)});
        }
        this.traceIdentifier = traceId;
        cicsLog.logExit("setTraceIdentifier");
    }

    public boolean isException() {
        return this.exception;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setException(boolean bl) {
        void traceException;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setException", new Object[]{new Boolean(bl)});
        }
        this.exception = traceException;
        cicsLog.logExit("setException");
    }
}

