/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.events.DelegateEvent;
import com.ibm.cics.server.API;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.EventErrorException;
import com.ibm.cics.server.LengthErrorException;
import java.io.UnsupportedEncodingException;

@InjectLogging(isEnabled=false)
public class Event
extends API {
    static final int MAX_NAME_LEN = 32;
    private String eventName;
    private static final Logger cicsLog = LoggerFactory.getLogger(Event.class);

    @InjectLogging
    public Event() {
        cicsLog.logEntry("<init>");
        this.eventName = null;
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public Event(String name) throws EventErrorException {
        cicsLog.logEntry("<init>", new Object[]{name});
        this.eventName = Event.padName(name);
        Event.checkEventNameNotNull(this.eventName);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    static String padName(String string) {
        String name;
        cicsLog.logEntry("padName", new Object[]{string});
        String paddedName = null;
        if (name != null) {
            int strLen = name.length();
            if (strLen == 32) {
                paddedName = name;
            } else if (strLen <= 32) {
                StringBuilder sb = new StringBuilder(name);
                sb.setLength(32);
                for (int i = 31; i >= 0 && sb.charAt(i) == '\u0000'; --i) {
                    sb.setCharAt(i, ' ');
                }
                paddedName = sb.toString();
            }
        }
        String string2 = paddedName;
        cicsLog.logExit("padName", new Object[]{string2});
        return string2;
    }

    public String getName() {
        return this.eventName;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setName(String string) throws EventErrorException {
        void name;
        cicsLog.logEntry("setName", new Object[]{string});
        this.eventName = Event.padName((String)name);
        Event.checkEventNameNotNull(this.eventName);
        cicsLog.logExit("setName");
    }

    @InjectLogging
    public void signal() throws EventErrorException, ChannelErrorException, LengthErrorException {
        cicsLog.logEntry("signal");
        Event.checkEventNameNotNull(this.eventName);
        DelegateEvent delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateEvent();
        try {
            delegate.signal(this.eventName, null, 0, null);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case EVENT_ERROR: {
                    throw new EventErrorException(err.getMessage());
                }
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("signal");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void signal(String string) throws ChannelErrorException, EventErrorException, LengthErrorException {
        void fromString;
        cicsLog.logEntry("signal", new Object[]{string});
        Event.checkEventNameNotNull(this.eventName);
        try {
            this.signal(fromString.getBytes(EnvironmentConstants.env.getLocalCCSID()));
        }
        catch (UnsupportedEncodingException e) {
            this.signal(fromString.getBytes());
        }
        cicsLog.logExit("signal");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void signal(byte[] byArray) throws ChannelErrorException, EventErrorException, LengthErrorException {
        void fromData;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("signal", new Object[]{byArray});
        }
        Event.checkEventNameNotNull(this.eventName);
        if (((void)fromData).length > 0) {
            DelegateEvent delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateEvent();
            try {
                delegate.signal(this.eventName, (byte[])fromData, ((void)fromData).length, null);
            }
            catch (DelegateError err) {
                switch (err.getCode()) {
                    case EVENT_ERROR: {
                        throw new EventErrorException(err.getMessage());
                    }
                    case CHANNEL_ERROR: {
                        throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                    }
                    case LENGTH_ERROR: {
                        throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                    }
                }
                DelegateErrorHandler.handleUncheckedError(err);
            }
        } else {
            throw new LengthErrorException("Data length not greater than zero");
        }
        cicsLog.logExit("signal");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void signal(byte[] byArray, int n) throws ChannelErrorException, EventErrorException, LengthErrorException {
        int fromLength;
        void fromData;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("signal", new Object[]{byArray, new Integer(n)});
        }
        Event.checkEventNameNotNull(this.eventName);
        if (((void)fromData).length > 0 && fromLength > 0) {
            DelegateEvent delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateEvent();
            try {
                delegate.signal(this.eventName, (byte[])fromData, ((void)fromData).length > fromLength ? fromLength : ((void)fromData).length, null);
            }
            catch (DelegateError err) {
                switch (err.getCode()) {
                    case EVENT_ERROR: {
                        throw new EventErrorException(err.getMessage());
                    }
                    case CHANNEL_ERROR: {
                        throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                    }
                    case LENGTH_ERROR: {
                        throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                    }
                }
                DelegateErrorHandler.handleUncheckedError(err);
            }
        } else {
            throw new LengthErrorException("Data length not greater than zero");
        }
        cicsLog.logExit("signal");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void signal(Channel channel) throws ChannelErrorException, EventErrorException, LengthErrorException {
        cicsLog.logEntry("signal", new Object[]{channel});
        Event.checkEventNameNotNull(this.eventName);
        DelegateEvent delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateEvent();
        try {
            void fromChannel;
            delegate.signal(this.eventName, null, 0, fromChannel.getName());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case EVENT_ERROR: {
                    throw new EventErrorException(err.getMessage());
                }
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("signal");
    }

    private static void checkEventNameNotNull(String eventNameToCheck) throws EventErrorException {
        if (eventNameToCheck == null) {
            throw new EventErrorException("Event name is invalid. Value is '" + eventNameToCheck + "'. It is null or too long", 6);
        }
    }
}

