/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.DelegateResource;
import com.ibm.cics.delegate.resource.vsam.DelegateFile;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RemotableResource;

@InjectLogging(isEnabled=false)
abstract class File
extends RemotableResource {
    private static final long serialVersionUID = 6652836353023783619L;
    private static final Logger cicsLog = LoggerFactory.getLogger(File.class);

    @InjectLogging
    public File() {
        super(DelegateFactoryLoader.getDelegateFactory().createDelegateFile());
        cicsLog.logEntry("<init>");
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public File(String name) {
        super(DelegateFactoryLoader.getDelegateFactory().createDelegateFile());
        cicsLog.logEntry("<init>", new Object[]{name});
        ((DelegateFile)this.getDelegate()).setName(name);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    protected File(DelegateFile delegate) {
        super((DelegateResource)delegate);
        cicsLog.logEntry("<init>", new Object[]{delegate});
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public void unlock() throws FileDisabledException, FileNotFoundException, LogicException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, NotOpenException, InvalidSystemIdException {
        cicsLog.logEntry("unlock");
        try {
            ((DelegateFile)this.getDelegate()).unlock();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case FILE_DISABLED: {
                    throw new FileDisabledException(err.getMessage(), err.getResp2(), err);
                }
                case FILE_NOT_FOUND: {
                    throw new FileNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case LOGIC: {
                    throw new LogicException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("unlock");
    }
}

