/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.vsam.DelegateFileBrowse;
import com.ibm.cics.server.API;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.Task;

@InjectLogging(isEnabled=false)
public class FileBrowse
extends API {
    private DelegateFileBrowse delegate;
    private static final Logger cicsLog = LoggerFactory.getLogger(FileBrowse.class);

    @InjectLogging
    protected FileBrowse(String fileName, String sysId) {
        this(DelegateFactoryLoader.getDelegateFactory().createDelegateFileBrowse(fileName, sysId, Task.getTask().getTaskNumber()));
        cicsLog.logEntry("<init>", new Object[]{fileName, sysId});
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    protected FileBrowse(DelegateFileBrowse delegate) {
        cicsLog.logEntry("<init>", new Object[]{delegate});
        this.delegate = delegate;
        cicsLog.logExit("<init>");
    }

    protected DelegateFileBrowse getDelegate() {
        return this.delegate;
    }

    @InjectLogging
    public void end() throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, ISCInvalidRequestException, NotAuthorisedException, NotOpenException, InvalidSystemIdException {
        cicsLog.logEntry("end");
        try {
            this.delegate.end();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case FILE_DISABLED: {
                    throw new FileDisabledException(err.getMessage(), err.getResp2(), err);
                }
                case FILE_NOT_FOUND: {
                    throw new FileNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case LOGIC: {
                    throw new LogicException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("end");
    }

    @InjectLogging
    public short getRequestID() {
        cicsLog.logEntry("getRequestID");
        short s = this.delegate.getRequestID();
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            short s2 = s;
            cicsLog.logExit("getRequestID", new Object[]{new Short(s2)});
            s = s2;
        }
        return s;
    }
}

