/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.DelegateHPOutputWriter;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.TerminalPrincipalFacility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

@InjectLogging(isEnabled=false)
class HPOutputStream
extends OutputStream {
    private static volatile DelegateHPOutputWriter writer;
    private static final String systemOutTDQ = "CESO";
    private static final int TDQRecordLength = 105;
    private boolean displayBlankLine = false;
    private static final String ASCII_cp = "8859_1";
    private static final String FILE_ENCODING;
    private static final byte ASCII_LF = 10;
    private byte[] dataBuffer = new byte[105];
    private int dataBufferOffset = 0;
    private byte[] blankBuffer = new byte[105];
    private static final Logger cicsLog;

    HPOutputStream() {
    }

    @Override
    @InjectLogging
    public void close() throws IOException {
        cicsLog.logEntry("close");
        cicsLog.logExit("close");
    }

    @Override
    @InjectLogging
    public void flush() throws IOException {
        cicsLog.logEntry("flush");
        if (this.dataBufferOffset > 0 || this.displayBlankLine) {
            this.displayBlankLine = false;
            try {
                String prefix;
                try {
                    Task thisTask = Task.getTask();
                    TerminalPrincipalFacility tpf = (TerminalPrincipalFacility)thisTask.getPrincipalFacility();
                    prefix = tpf.getName() + thisTask.getTransactionName() + " ";
                }
                catch (Exception exc) {
                    prefix = "         ";
                }
                prefix = prefix + "               ";
                BufferedReader r = null;
                if (this.dataBufferOffset > 0) {
                    ByteArrayInputStream in = new ByteArrayInputStream(this.dataBuffer);
                    r = new BufferedReader(new InputStreamReader((InputStream)in, ASCII_cp));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream(prefix.length() + 105);
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)out, FILE_ENCODING));
                ((Writer)w).write(prefix.toCharArray(), 0, prefix.length());
                if (this.dataBufferOffset > 0) {
                    char[] buffer = new char[1050];
                    if (r != null) {
                        int rlen;
                        while ((rlen = r.read(buffer)) != -1) {
                            ((Writer)w).write(buffer, 0, rlen);
                        }
                        ((Reader)r).close();
                    }
                }
                ((Writer)w).flush();
                DelegateHPOutputWriter writer1 = HPOutputStream.getWriter();
                writer1.write(systemOutTDQ, out.toByteArray(), null, false);
                ((Writer)w).close();
            }
            catch (Exception exc) {
                System.err.println("Exception: " + exc + "\n raised during write to TDQ " + systemOutTDQ + ".");
            }
            System.arraycopy(this.blankBuffer, 0, this.dataBuffer, 0, 105);
            this.dataBufferOffset = 0;
        }
        cicsLog.logExit("flush");
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void write(byte[] byArray, int n, int n2) throws IOException {
        void length;
        void offset;
        void b;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("write", new Object[]{byArray, new Integer(n), new Integer(n2)});
        }
        int blen = ((void)b).length;
        void off = offset;
        int len = length;
        if (len != 1 || b[off] != 10) {
            int lfPos = HPOutputStream.index((byte)10, (byte[])b, (int)off, len);
            while (off < blen && len > 0) {
                int copyBytes;
                int n3 = copyBytes = len + this.dataBufferOffset < 105 ? len : 105 - this.dataBufferOffset;
                if (lfPos != -1 && copyBytes > lfPos - off) {
                    copyBytes = lfPos - off;
                }
                System.arraycopy(b, (int)off, this.dataBuffer, this.dataBufferOffset, copyBytes);
                this.dataBufferOffset += copyBytes;
                if (this.dataBufferOffset == 105) {
                    this.flush();
                }
                len -= copyBytes;
                if (lfPos == -1 || lfPos > (off += copyBytes)) continue;
                this.flush();
                ++off;
                lfPos = HPOutputStream.index((byte)10, (byte[])b, lfPos + 1, --len);
            }
        } else {
            this.displayBlankLine = true;
            this.flush();
        }
        cicsLog.logExit("write");
    }

    private static int index(byte searchFor, byte[] inHere, int fromOffset, int forLen) {
        int index = -1;
        int i = fromOffset;
        do {
            if (inHere[i] == searchFor) {
                index = i;
                continue;
            }
            ++i;
        } while (index == -1 && i < fromOffset + forLen);
        return index;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] DataBuffer = new byte[1];
        this.write(DataBuffer, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DelegateHPOutputWriter getWriter() {
        if (writer != null) return writer;
        Class<HPOutputStream> clazz = HPOutputStream.class;
        synchronized (HPOutputStream.class) {
            if (writer != null) return writer;
            writer = DelegateFactoryLoader.getDelegateFactory().createDelegateHPOutputWriter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return writer;
        }
    }

    static {
        cicsLog = LoggerFactory.getLogger(HPOutputStream.class);
        FILE_ENCODING = EnvironmentConstants.env.getFileEncoding();
    }
}

