/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateHostType;
import com.ibm.cics.delegate.web.DelegateHttpClientRequest;
import com.ibm.cics.delegate.web.DelegateHttpRequestType;
import com.ibm.cics.server.API;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.Document;
import com.ibm.cics.server.HttpSession;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.TokenErrorException;

@InjectLogging(isEnabled=false)
public class HttpClientRequest
extends API {
    public static final int NOTSET;
    private DelegateHttpClientRequest delegate;
    private static final int RESP2_CONTAINER_NOT_FOUND = 2;
    private static final Logger cicsLog;

    @InjectLogging
    public HttpClientRequest(String method) {
        cicsLog.logEntry("<init>", new Object[]{method});
        DelegateHttpRequestType request = DelegateHttpRequestType.lookup((String)method);
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateHttpClientRequest(request);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public HttpClientRequest(String method, String mediaType) {
        cicsLog.logEntry("<init>", new Object[]{method, mediaType});
        DelegateHttpRequestType request = DelegateHttpRequestType.lookup((String)method);
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateHttpClientRequest(request, mediaType);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public void setMethodPost() {
        cicsLog.logEntry("setMethodPost");
        this.delegate.setMethod(DelegateHttpRequestType.POST);
        cicsLog.logExit("setMethodPost");
    }

    @InjectLogging
    public void setMethodGet() {
        cicsLog.logEntry("setMethodGet");
        this.delegate.setMethod(DelegateHttpRequestType.GET);
        cicsLog.logExit("setMethodGet");
    }

    @InjectLogging
    public void setMethodHead() {
        cicsLog.logEntry("setMethodHead");
        this.delegate.setMethod(DelegateHttpRequestType.HEAD);
        cicsLog.logExit("setMethodHead");
    }

    @InjectLogging
    public void setMethodPut() {
        cicsLog.logEntry("setMethodPut");
        this.delegate.setMethod(DelegateHttpRequestType.PUT);
        cicsLog.logExit("setMethodPut");
    }

    @InjectLogging
    public void setMethodTrace() {
        cicsLog.logEntry("setMethodTrace");
        this.delegate.setMethod(DelegateHttpRequestType.TRACE);
        cicsLog.logExit("setMethodTrace");
    }

    @InjectLogging
    public void setMethodOptions() {
        cicsLog.logEntry("setMethodOptions");
        this.delegate.setMethod(DelegateHttpRequestType.OPTIONS);
        cicsLog.logExit("setMethodOptions");
    }

    @InjectLogging
    public void setMethodDelete() {
        cicsLog.logEntry("setMethodDelete");
        this.delegate.setMethod(DelegateHttpRequestType.DELETE);
        cicsLog.logExit("setMethodDelete");
    }

    @InjectLogging
    public void setMethodPatch() {
        cicsLog.logEntry("setMethodPatch");
        this.delegate.setMethod(DelegateHttpRequestType.PATCH);
        cicsLog.logExit("setMethodPatch");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setCharacterset(String string) {
        void characterset;
        cicsLog.logEntry("setCharacterset", new Object[]{string});
        this.delegate.setCharacterset((String)characterset);
        cicsLog.logExit("setCharacterset");
    }

    @InjectLogging
    public void setClose() {
        cicsLog.logEntry("setClose");
        this.delegate.setClose(true);
        cicsLog.logExit("setClose");
    }

    @InjectLogging
    public void setNoClose() {
        cicsLog.logEntry("setNoClose");
        this.delegate.setClose(false);
        cicsLog.logExit("setNoClose");
    }

    @InjectLogging
    public void setActionExpect() {
        cicsLog.logEntry("setActionExpect");
        this.delegate.setActionExpect();
        cicsLog.logExit("setActionExpect");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setMediaType(String string) {
        void mediaType;
        cicsLog.logEntry("setMediaType", new Object[]{string});
        this.delegate.setMediaType((String)mediaType);
        cicsLog.logExit("setMediaType");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setPath(String string) {
        void path;
        cicsLog.logEntry("setPath", new Object[]{string});
        this.delegate.setPath((String)path);
        cicsLog.logExit("setPath");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setUrimap(String string) {
        void urimap;
        cicsLog.logEntry("setUrimap", new Object[]{string});
        this.delegate.setUrimap((String)urimap);
        cicsLog.logExit("setUrimap");
    }

    @InjectLogging
    public void setClientConvert() {
        cicsLog.logEntry("setClientConvert");
        this.delegate.setClientConvert(true);
        cicsLog.logExit("setClientConvert");
    }

    @InjectLogging
    public void setNoClientConvert() {
        cicsLog.logEntry("setNoClientConvert");
        this.delegate.setClientConvert(false);
        cicsLog.logExit("setNoClientConvert");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setQueryString(String string) {
        void queryString;
        cicsLog.logEntry("setQueryString", new Object[]{string});
        this.delegate.setQueryString((String)queryString);
        cicsLog.logExit("setQueryString");
    }

    @InjectLogging
    public void setDocDelete() {
        cicsLog.logEntry("setDocDelete");
        this.delegate.setDocDelete(true);
        cicsLog.logExit("setDocDelete");
    }

    @InjectLogging
    public void setNoDocDelete() {
        cicsLog.logEntry("setNoDocDelete");
        this.delegate.setDocDelete(false);
        cicsLog.logExit("setNoDocDelete");
    }

    @InjectLogging
    public void setAuthenticationNone() {
        cicsLog.logEntry("setAuthenticationNone");
        this.delegate.setAuthenticationNone();
        cicsLog.logExit("setAuthenticationNone");
    }

    @InjectLogging
    public void setAuthenticationBasic() {
        cicsLog.logEntry("setAuthenticationBasic");
        this.delegate.setAuthenticationBasic();
        cicsLog.logExit("setAuthenticationBasic");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setAuthenticationBasic(String string, String string2) {
        void password;
        void userName;
        cicsLog.logEntry("setAuthenticationBasic", new Object[]{string, string2});
        this.delegate.setAuthenticationBasic((String)userName, (String)password);
        cicsLog.logExit("setAuthenticationBasic");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendDocument(HttpSession httpSession, Document document) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        void doc;
        cicsLog.logEntry("sendDocument", new Object[]{httpSession, document});
        boolean docDeleted = false;
        try {
            void session;
            docDeleted = this.delegate.sendDocument(session.getSessionToken(), doc.getDocToken());
        }
        catch (DelegateError e) {
            HttpClientRequest.catchSENDExceptionsAndConvertToJcicsExceptions(e);
        }
        if (docDeleted) {
            doc.docDeleted();
        }
        cicsLog.logExit("sendDocument");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendFrom(HttpSession httpSession, String string) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        cicsLog.logEntry("sendFrom", new Object[]{httpSession, string});
        try {
            void from;
            void session;
            this.delegate.sendFrom(session.getSessionToken(), session.getCodePageCharsetName(), (String)from);
        }
        catch (DelegateError e) {
            HttpClientRequest.catchSENDExceptionsAndConvertToJcicsExceptions(e);
        }
        cicsLog.logExit("sendFrom");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendFrom(HttpSession httpSession, byte[] byArray) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("sendFrom", new Object[]{httpSession, byArray});
        }
        try {
            void from;
            void session;
            this.delegate.sendFrom(session.getSessionToken(), (byte[])from);
        }
        catch (DelegateError e) {
            HttpClientRequest.catchSENDExceptionsAndConvertToJcicsExceptions(e);
        }
        cicsLog.logExit("sendFrom");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendContainer(HttpSession httpSession, Container container) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        void container2;
        cicsLog.logEntry("sendContainer", new Object[]{httpSession, container});
        if (container2 == null) {
            throw new ContainerErrorException("Null Container", 2);
        }
        try {
            container2.getName();
            container2.getChannelName();
        }
        catch (Exception e) {
            throw new ContainerErrorException("Container deleted", 2, e);
        }
        try {
            void session;
            this.delegate.sendContainer(session.getSessionToken(), container2.getName(), container2.getChannelName());
        }
        catch (DelegateError e) {
            HttpClientRequest.catchSENDExceptionsAndConvertToJcicsExceptions(e);
        }
        cicsLog.logExit("sendContainer");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void send(HttpSession httpSession) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        cicsLog.logEntry("send", new Object[]{httpSession});
        try {
            void session;
            this.delegate.send(session.getSessionToken());
        }
        catch (DelegateError e) {
            HttpClientRequest.catchSENDExceptionsAndConvertToJcicsExceptions(e);
        }
        cicsLog.logExit("send");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendChunk(HttpSession httpSession, String string) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        cicsLog.logEntry("sendChunk", new Object[]{httpSession, string});
        try {
            void from;
            void session;
            this.delegate.sendChunk(session.getSessionToken(), session.getCodePageCharsetName(), (String)from);
        }
        catch (DelegateError e) {
            HttpClientRequest.catchSENDExceptionsAndConvertToJcicsExceptions(e);
        }
        cicsLog.logExit("sendChunk");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendChunk(HttpSession httpSession, byte[] byArray) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("sendChunk", new Object[]{httpSession, byArray});
        }
        try {
            void from;
            void session;
            this.delegate.sendChunk(session.getSessionToken(), (byte[])from);
        }
        catch (DelegateError e) {
            HttpClientRequest.catchSENDExceptionsAndConvertToJcicsExceptions(e);
        }
        cicsLog.logExit("sendChunk");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendLastChunk(HttpSession httpSession) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        cicsLog.logEntry("sendLastChunk", new Object[]{httpSession});
        try {
            void session;
            this.delegate.sendLastChunk(session.getSessionToken());
        }
        catch (DelegateError e) {
            HttpClientRequest.catchSENDExceptionsAndConvertToJcicsExceptions(e);
        }
        cicsLog.logExit("sendLastChunk");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void writeHeader(HttpSession httpSession, String string, String string2) throws InvalidRequestException, NotOpenException {
        cicsLog.logEntry("writeHeader", new Object[]{httpSession, string, string2});
        try {
            void value;
            void header;
            void session;
            this.delegate.writeHeader(session.getSessionToken(), (String)header, (String)value);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(e.getMessage(), e.getResp2(), e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        cicsLog.logExit("writeHeader");
    }

    @InjectLogging
    private static void catchSENDExceptionsAndConvertToJcicsExceptions(DelegateError delegateError) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        DelegateError e;
        cicsLog.logEntry("catchSENDExceptionsAndConvertToJcicsExceptions", new Object[]{delegateError});
        switch (e.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
            }
            case RECORD_NOT_FOUND: {
                throw new RecordNotFoundException(e.getMessage(), e.getResp2(), e);
            }
            case IO_ERROR: {
                throw new IOErrorException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
            }
            case NOT_AUTHORISED: {
                throw new NotAuthorisedException(e.getMessage(), e.getResp2(), e);
            }
            case LENGTH_ERROR: {
                throw new LengthErrorException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
            }
            case NOT_OPEN: {
                throw new NotOpenException(e.getMessage(), e.getResp2(), e);
            }
            case TOKEN_ERROR: {
                throw new TokenErrorException(e.getMessage(), e.getResp2());
            }
            case CONTAINER_ERROR: {
                throw new ContainerErrorException(e.getMessage(), e.getResp2(), e);
            }
            case CHANNEL_ERROR: {
                throw new ChannelErrorException(e.getMessage(), e.getResp2(), e);
            }
        }
        DelegateErrorHandler.handleUncheckedError(e);
        cicsLog.logExit("catchSENDExceptionsAndConvertToJcicsExceptions");
    }

    static {
        cicsLog = LoggerFactory.getLogger(HttpClientRequest.class);
        NOTSET = DelegateHostType.NOTSET.getValue();
    }
}

