/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.PaddingUtils;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateHostType;
import com.ibm.cics.delegate.web.DelegateHttpClientResponse;
import com.ibm.cics.delegate.web.DelegateNameValue;
import com.ibm.cics.server.API;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.EndOfFileException;
import com.ibm.cics.server.HttpHeader;
import com.ibm.cics.server.HttpSession;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.TimedOutException;

public class HttpClientResponse
extends API {
    private DelegateHttpClientResponse delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateHttpClientResponse();
    private static final int RESP2_NO_CURRENT_CHANNEL = 145;
    private static final int RESP2_CONTAINER_NAME_INVALID = 1;
    private static final int RESP2_CHANNEL_NAME_INVALID = 1;
    public static final int NOTSET = DelegateHostType.NOTSET.getValue();

    public void setClientConvert() {
        this.delegate.setClientConvert(true);
    }

    public void setNoClientConvert() {
        this.delegate.setClientConvert(false);
    }

    public void setNoTruncate() {
        this.delegate.setTruncate(false);
    }

    public void setTruncate() {
        this.delegate.setTruncate(true);
    }

    public void setMaxLength(int maxLength) throws LengthErrorException {
        try {
            this.delegate.setMaxLength(maxLength);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case LENGTH_ERROR: {
                    throw new LengthErrorException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
    }

    public byte[] getContent(HttpSession session) throws InvalidRequestException, IOErrorException, NotOpenException, TimedOutException {
        byte[] serverBodyResponse = null;
        try {
            serverBodyResponse = this.delegate.getContent(session.getSessionToken());
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getLocalizedMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case IO_ERROR: {
                    throw new IOErrorException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(e.getMessage(), e.getResp2(), e);
                }
                case TIMED_OUT: {
                    throw new TimedOutException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return serverBodyResponse;
    }

    public String getContentAsString(HttpSession session) throws InvalidRequestException, IOErrorException, NotOpenException, TimedOutException {
        String contentStringFormat = null;
        try {
            contentStringFormat = this.delegate.getContentAsString(session.getSessionToken(), session.getCodePage());
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getLocalizedMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case IO_ERROR: {
                    throw new IOErrorException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(e.getMessage(), e.getResp2(), e);
                }
                case TIMED_OUT: {
                    throw new TimedOutException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return contentStringFormat;
    }

    public Container getContentAsContainer(HttpSession session, String targetContainer, String targetChannel) throws InvalidRequestException, IOErrorException, NotOpenException, TimedOutException, ChannelErrorException, ContainerErrorException {
        Channel chan;
        String toContainer = targetContainer;
        if (toContainer == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        String toChannel = targetChannel;
        if (toChannel == null) {
            throw new ChannelErrorException("Null toChannel", 1);
        }
        toContainer = PaddingUtils.spacePad((String)toContainer, (int)16);
        toChannel = PaddingUtils.spacePad((String)toChannel, (int)16);
        try {
            this.delegate.callRecreateContainer(session.getSessionToken(), toContainer, toChannel);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case IO_ERROR: {
                    throw new IOErrorException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(e.getMessage(), e.getResp2(), e);
                }
                case TIMED_OUT: {
                    throw new TimedOutException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(e.getMessage(), e.getResp2(), e);
                }
                case CONTAINER_ERROR: {
                    throw new ContainerErrorException(e.getMessage(), e.getResp2(), e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        Task t = Task.getTask();
        if (t == null) {
            throw new InvalidRequestException("Task.getTask failed");
        }
        try {
            chan = t.createChannel(toChannel);
        }
        catch (Exception e) {
            chan = t.returnChannel(toChannel);
        }
        Container cont = chan.returnContainer(toContainer);
        cont.containerExistsInCICS();
        return cont;
    }

    public Container getContentAsContainer(HttpSession session, String targetContainer) throws InvalidRequestException, IOErrorException, NotOpenException, TimedOutException, ChannelErrorException, ContainerErrorException {
        String toContainer = targetContainer;
        if (toContainer == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        toContainer = PaddingUtils.spacePad((String)toContainer, (int)16);
        Task t = Task.getTask();
        Channel chan = t.getCurrentChannel();
        if (chan == null) {
            throw new InvalidRequestException("No current channel", 145);
        }
        try {
            this.delegate.callRecreateContainer(session.getSessionToken(), toContainer, chan.getName());
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case IO_ERROR: {
                    throw new IOErrorException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(e.getMessage(), e.getResp2(), e);
                }
                case TIMED_OUT: {
                    throw new TimedOutException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case CHANNEL_ERROR: {
                    throw new ChannelErrorException(e.getMessage(), e.getResp2(), e);
                }
                case CONTAINER_ERROR: {
                    throw new ContainerErrorException(e.getMessage(), e.getResp2(), e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        Container cont = chan.returnContainer(toContainer);
        cont.containerExistsInCICS();
        return cont;
    }

    public int getStatusCode() throws InvalidRequestException {
        int statusCode = 0;
        try {
            statusCode = this.delegate.getStatusCode();
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return statusCode;
    }

    public String getStatusText() throws InvalidRequestException {
        String statusText = "";
        try {
            statusText = this.delegate.getStatusText();
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return statusText;
    }

    public String getMediaType() throws InvalidRequestException {
        String mediaType = "";
        try {
            mediaType = this.delegate.getMediaType(false);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return mediaType;
    }

    public String getMediaTypeTrim() throws InvalidRequestException {
        String mediaType = "";
        try {
            mediaType = this.delegate.getMediaType(true);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return mediaType;
    }

    public String getCharacterset() throws InvalidRequestException {
        String characterSet = "";
        try {
            characterSet = this.delegate.getCharacterset(false);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return characterSet;
    }

    public String getCharactersetTrim() throws InvalidRequestException {
        String characterSet = "";
        try {
            characterSet = this.delegate.getCharacterset(true);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return characterSet;
    }

    public String getBodyCharset() throws InvalidRequestException {
        String characterSet = "";
        try {
            characterSet = this.delegate.getCharacterset(true);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return characterSet;
    }

    public boolean isBodyComplete() {
        return this.delegate.isBodyComplete();
    }

    public boolean isBodyTruncated() {
        return this.delegate.isBodyTruncated();
    }

    public boolean isBodyPartial() {
        return this.delegate.isBodyPartial();
    }

    public String getHeader(HttpSession session, String header) throws InvalidRequestException, NotOpenException {
        String headerReturned = "";
        try {
            headerReturned = this.delegate.getHeader(session.getSessionToken(), header);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(e.getMessage(), e.getResp2(), e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return headerReturned;
    }

    public void startBrowseHeader(HttpSession session) throws InvalidRequestException, NotOpenException, LogicException {
        try {
            this.delegate.startBrowseHeader(session.getSessionToken());
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(e.getMessage(), e.getResp2(), e);
                }
                case LOGIC: {
                    throw new LogicException(e.getLocalizedMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
    }

    public HttpHeader getNextHeader(HttpSession session) throws LogicException, NotOpenException, EndOfFileException {
        HttpHeader header = null;
        try {
            DelegateNameValue nameValue = this.delegate.getNextHeader(session.getSessionToken());
            header = new HttpHeader(nameValue.getName(), nameValue.getValue());
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case NOT_OPEN: {
                    throw new NotOpenException(e.getMessage(), e.getResp2(), e);
                }
                case LOGIC: {
                    throw new LogicException(e.getLocalizedMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case END_OF_FILE: {
                    throw new EndOfFileException(e.getMessage(), e.getResp2(), e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return header;
    }

    public void endBrowseHeader(HttpSession session) throws LogicException, NotOpenException {
        try {
            this.delegate.endBrowseHeader(session.getSessionToken());
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case NOT_OPEN: {
                    throw new NotOpenException(e.getMessage(), e.getResp2(), e);
                }
                case LOGIC: {
                    throw new LogicException(e.getLocalizedMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
    }
}

