/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CICSThreadLocalManager;
import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.PaddingUtils;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateHostType;
import com.ibm.cics.delegate.web.DelegateHttpRequest;
import com.ibm.cics.delegate.web.DelegateNameValue;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.EndOfFileException;
import com.ibm.cics.server.FormField;
import com.ibm.cics.server.HttpHeader;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NonHttpDataException;
import com.ibm.cics.server.QueryParm;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.TcpipRequest;
import com.ibm.cics.server.WebInfo;
import com.ibm.cics.server.WebReceive;
import com.ibm.cics.server.internal.WrapperHelper;

@InjectLogging(isEnabled=false)
public class HttpRequest
extends TcpipRequest {
    public static final int NOTSET;
    private static final ThreadLocal<WebInfo> WInfo;
    private static final ThreadLocal<HttpRequest> _hrq;
    private static final ThreadLocal<WebReceive> WRecv;
    private static final int RESP2_NO_CURRENT_CHANNEL = 145;
    private static final int RESP2_CONTAINER_NAME_INVALID = 1;
    private static final int RESP2_CHANNEL_NAME_INVALID = 1;
    private static boolean registeredWithWrapper;
    private DelegateHttpRequest delegate;
    private static final Logger cicsLog;

    @InjectLogging
    private HttpRequest() {
        cicsLog.logEntry("<init>");
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateHttpRequest();
        if (!registeredWithWrapper) {
            registeredWithWrapper = true;
            WrapperHelper.registerTerminator(this);
        }
        cicsLog.logExit("<init>");
    }

    public static HttpRequest getHttpRequestInstance() {
        if (_hrq.get() == null) {
            _hrq.set(new HttpRequest());
        }
        return _hrq.get();
    }

    public String getHttpMethod() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getHttpMethod();
    }

    public String getHttpVersion() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getHttpVersion();
    }

    public String getRequestType() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getRequestType();
    }

    public boolean isDataHttp() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().isDataHttp();
    }

    public String getPath() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getPath();
    }

    public String getQueryString() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getQueryString();
    }

    public String getHost() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getHost();
    }

    public int getHostType() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getHostType();
    }

    public boolean isSchemeHttp() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().isSchemeHttp();
    }

    public boolean isSchemeHttps() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().isSchemeHttps();
    }

    public String getScheme() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getScheme();
    }

    public String getUrimap() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getUrimap();
    }

    @Override
    public int getPortNumber() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getPortNumber();
    }

    public String getHeader(String header) throws InvalidRequestException {
        String result = null;
        try {
            result = this.delegate.getHeader(header);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return result;
    }

    public String getFormField(String formField) throws InvalidRequestException {
        return this.getFormField(formField, null, null);
    }

    public String getFormField(String formField, String hostCodePage, String characterset) throws InvalidRequestException {
        String result = null;
        try {
            result = this.delegate.getFormField(formField, hostCodePage, characterset);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return result;
    }

    public byte[] getFormFieldData(String formField) throws InvalidRequestException {
        return this.getFormFieldData(formField, null, null);
    }

    public byte[] getFormFieldData(String formField, String hostCodePage, String characterset) throws InvalidRequestException {
        byte[] result = null;
        try {
            result = this.delegate.getFormFieldData(formField, hostCodePage, characterset);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return result;
    }

    public String getQueryParm(String queryParm) throws InvalidRequestException {
        String result = null;
        try {
            result = this.delegate.getQueryParm(queryParm);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        return result;
    }

    @Override
    @InjectLogging
    public void setServerConvert() {
        cicsLog.logEntry("setServerConvert");
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setServerConvert();
        cicsLog.logExit("setServerConvert");
    }

    @Override
    @InjectLogging
    public void setNoServerConvert() {
        cicsLog.logEntry("setNoServerConvert");
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNoServerConvert();
        cicsLog.logExit("setNoServerConvert");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void setClientCodePage(String string) {
        void theCharacterset;
        cicsLog.logEntry("setClientCodePage", new Object[]{string});
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        String characterset = theCharacterset;
        characterset = PaddingUtils.spacePad((String)characterset, (int)40);
        WRecv.get().setCharacterset(characterset);
        cicsLog.logExit("setClientCodePage");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void setCharacterset(String string) {
        void theCharacterset;
        cicsLog.logEntry("setCharacterset", new Object[]{string});
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        String characterset = theCharacterset;
        characterset = PaddingUtils.spacePad((String)characterset, (int)40);
        WRecv.get().setCharacterset(characterset);
        cicsLog.logExit("setCharacterset");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void setHostCodePage(String string) {
        void theHostCodePage;
        cicsLog.logEntry("setHostCodePage", new Object[]{string});
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        String hostCodePage = theHostCodePage;
        hostCodePage = PaddingUtils.spacePad((String)hostCodePage, (int)8);
        WRecv.get().setHostCodePage(hostCodePage);
        cicsLog.logExit("setHostCodePage");
    }

    @Override
    @InjectLogging
    public void setNoTruncate() {
        cicsLog.logEntry("setNoTruncate");
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNoTruncate();
        cicsLog.logExit("setNoTruncate");
    }

    @Override
    @InjectLogging
    public void setTruncate() {
        cicsLog.logEntry("setTruncate");
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setTruncate();
        cicsLog.logExit("setTruncate");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectLogging
    public void setMaxLength(int n) throws LengthErrorException {
        void maxLength;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setMaxLength", new Object[]{new Integer(n)});
        }
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if (maxLength < true) {
            throw new LengthErrorException("maxLength not greater than 0");
        }
        WRecv.get().setMaxLength((int)maxLength);
        cicsLog.logExit("setMaxLength");
    }

    @Override
    public byte[] getContent(String theHostCodePage, String theCharacterset) throws InvalidRequestException, RecordNotFoundException, NonHttpDataException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        String hostCodePage = theHostCodePage;
        hostCodePage = PaddingUtils.spacePad((String)hostCodePage, (int)8);
        WRecv.get().setHostCodePage(hostCodePage);
        String characterset = theCharacterset;
        characterset = PaddingUtils.spacePad((String)characterset, (int)40);
        WRecv.get().setCharacterset(characterset);
        WRecv.get().setNonHttpDataExceptionYes();
        return WRecv.get().receive();
    }

    @Override
    public byte[] getContent() throws InvalidRequestException, RecordNotFoundException, NonHttpDataException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNonHttpDataExceptionYes();
        return WRecv.get().receive();
    }

    @Override
    public Container getContentAsContainer(String targetContainer, String targetChannel) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException {
        Channel chan;
        String toContainer;
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if ((toContainer = targetContainer) == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        String toChannel = targetChannel;
        if (toChannel == null) {
            throw new ChannelErrorException("Null toChannel", 1);
        }
        toContainer = PaddingUtils.spacePad((String)toContainer, (int)16);
        toChannel = PaddingUtils.spacePad((String)toChannel, (int)16);
        WRecv.get().receiveContainer(toContainer, toChannel);
        Task t = Task.getTask();
        if (t == null) {
            throw new InvalidRequestException("Task.getTask failed");
        }
        try {
            chan = t.createChannel(toChannel);
        }
        catch (Exception e) {
            chan = t.returnChannel(toChannel);
        }
        Container cont = chan.returnContainer(toContainer);
        cont.containerExistsInCICS();
        return cont;
    }

    @Override
    public Container getContentAsContainer(String targetContainer) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException {
        String toContainer;
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if ((toContainer = targetContainer) == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        toContainer = PaddingUtils.spacePad((String)toContainer, (int)16);
        Task t = Task.getTask();
        Channel chan = t.getCurrentChannel();
        if (chan == null) {
            throw new InvalidRequestException("No current channel", 145);
        }
        WRecv.get().receiveContainer(toContainer, chan.getName());
        Container cont = chan.returnContainer(toContainer);
        cont.containerExistsInCICS();
        return cont;
    }

    @Override
    public boolean isBodyComplete() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().isBodyComplete();
    }

    @Override
    public boolean isBodyTruncated() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().isBodyTruncated();
    }

    @Override
    public boolean isBodyPartial() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().isBodyPartial();
    }

    @Override
    public String getBodyCharset() throws InvalidRequestException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().getBodyCharset();
    }

    @Override
    public String getMediaType() throws InvalidRequestException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().getMediaType();
    }

    @InjectLogging
    public void startBrowseHeader() throws InvalidRequestException, RecordNotFoundException, LogicException {
        cicsLog.logEntry("startBrowseHeader");
        try {
            this.delegate.startBrowseHeader();
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(e.getMessage(), e.getResp2(), e);
                }
                case LOGIC: {
                    throw new LogicException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        cicsLog.logExit("startBrowseHeader");
    }

    @InjectLogging
    public HttpHeader getNextHeader() throws InvalidRequestException, EndOfFileException {
        HttpHeader httpHeader;
        cicsLog.logEntry("getNextHeader");
        try {
            DelegateNameValue nameValue = this.delegate.getNextHeader();
            httpHeader = new HttpHeader(nameValue.getName(), nameValue.getValue());
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case END_OF_FILE: {
                    throw new EndOfFileException(e.getMessage(), e.getResp2(), e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
            HttpHeader httpHeader2 = null;
            cicsLog.logExit("getNextHeader", new Object[]{httpHeader2});
            return httpHeader2;
        }
        cicsLog.logExit("getNextHeader", new Object[]{httpHeader});
        return httpHeader;
    }

    @InjectLogging
    public void endBrowseHeader() throws InvalidRequestException {
        cicsLog.logEntry("endBrowseHeader");
        try {
            this.delegate.endBrowseHeader();
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        cicsLog.logExit("endBrowseHeader");
    }

    @InjectLogging
    public void startBrowseFormField() throws InvalidRequestException, RecordNotFoundException, LogicException {
        cicsLog.logEntry("startBrowseFormField");
        this.startBrowseFormField(null);
        cicsLog.logExit("startBrowseFormField");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void startBrowseFormField(String string) throws InvalidRequestException, RecordNotFoundException, LogicException {
        void name;
        cicsLog.logEntry("startBrowseFormField", new Object[]{string});
        this.startBrowseFormField((String)name, null, null);
        cicsLog.logExit("startBrowseFormField");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void startBrowseFormField(String string, String string2, String string3) throws InvalidRequestException, RecordNotFoundException, LogicException {
        cicsLog.logEntry("startBrowseFormField", new Object[]{string, string2, string3});
        try {
            void characterset;
            void hostCodePage;
            void name;
            this.delegate.startBrowseFormField((String)name, (String)hostCodePage, (String)characterset);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(e.getMessage(), e.getResp2(), e);
                }
                case LOGIC: {
                    throw new LogicException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        cicsLog.logExit("startBrowseFormField");
    }

    @InjectLogging
    public FormField getNextFormField() throws InvalidRequestException, EndOfFileException {
        FormField formField;
        cicsLog.logEntry("getNextFormField");
        try {
            DelegateNameValue nameValue = this.delegate.getNextFormField();
            formField = new FormField(nameValue.getName(), nameValue.getValue());
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case END_OF_FILE: {
                    throw new EndOfFileException(e.getMessage(), e.getResp2(), e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
            FormField formField2 = null;
            cicsLog.logExit("getNextFormField", new Object[]{formField2});
            return formField2;
        }
        cicsLog.logExit("getNextFormField", new Object[]{formField});
        return formField;
    }

    @InjectLogging
    public void endBrowseFormField() throws InvalidRequestException {
        cicsLog.logEntry("endBrowseFormField");
        try {
            this.delegate.endBrowseFormField();
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        cicsLog.logExit("endBrowseFormField");
    }

    @InjectLogging
    public void startBrowseQueryParm() throws InvalidRequestException, RecordNotFoundException, LogicException {
        cicsLog.logEntry("startBrowseQueryParm");
        this.startBrowseQueryParm(null);
        cicsLog.logExit("startBrowseQueryParm");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void startBrowseQueryParm(String string) throws InvalidRequestException, RecordNotFoundException, LogicException {
        cicsLog.logEntry("startBrowseQueryParm", new Object[]{string});
        try {
            void name;
            this.delegate.startBrowseQueryParm((String)name);
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(e.getMessage(), e.getResp2(), e);
                }
                case LOGIC: {
                    throw new LogicException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        cicsLog.logExit("startBrowseQueryParm");
    }

    @InjectLogging
    public QueryParm getNextQueryParm() throws InvalidRequestException, EndOfFileException {
        QueryParm queryParm;
        cicsLog.logEntry("getNextQueryParm");
        try {
            DelegateNameValue nameValue = this.delegate.getNextQueryParm();
            queryParm = new QueryParm(nameValue.getName(), nameValue.getValue());
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
                case END_OF_FILE: {
                    throw new EndOfFileException(e.getMessage(), e.getResp2(), e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
            QueryParm queryParm2 = null;
            cicsLog.logExit("getNextQueryParm", new Object[]{queryParm2});
            return queryParm2;
        }
        cicsLog.logExit("getNextQueryParm", new Object[]{queryParm});
        return queryParm;
    }

    @InjectLogging
    public void endBrowseQueryParm() throws InvalidRequestException {
        cicsLog.logEntry("endBrowseQueryParm");
        try {
            this.delegate.endBrowseQueryParm();
        }
        catch (DelegateError e) {
            switch (e.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
                }
            }
            DelegateErrorHandler.handleUncheckedError(e);
        }
        cicsLog.logExit("endBrowseQueryParm");
    }

    private static boolean ibmJVMTidyUp() {
        if (WInfo.get() != null) {
            WInfo.get().resetObject();
            WInfo.remove();
        }
        if (WRecv.get() != null) {
            WRecv.get().resetObject();
            WRecv.remove();
        }
        return true;
    }

    @Override
    @InjectLogging
    public final void drive_ibmJVMTidyUp() {
        cicsLog.logEntry("drive_ibmJVMTidyUp");
        HttpRequest.ibmJVMTidyUp();
        super.drive_ibmJVMTidyUp();
        cicsLog.logExit("drive_ibmJVMTidyUp");
    }

    static {
        cicsLog = LoggerFactory.getLogger(HttpRequest.class);
        NOTSET = DelegateHostType.NOTSET.getValue();
        WInfo = CICSThreadLocalManager.createThreadLocal();
        _hrq = CICSThreadLocalManager.createThreadLocal();
        WRecv = CICSThreadLocalManager.createThreadLocal();
        registeredWithWrapper = false;
    }
}

