/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateHostType;
import com.ibm.cics.delegate.web.DelegateHttpResponse;
import com.ibm.cics.server.API;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.Document;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;

@InjectLogging(isEnabled=false)
public class HttpResponse
extends API {
    public static final int NOTSET;
    private static final int RESP2_CONTAINER_NOT_FOUND = 2;
    private DelegateHttpResponse delegate;
    private static final Logger cicsLog;

    @InjectLogging
    public HttpResponse() {
        cicsLog.logEntry("<init>");
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateHttpResponse();
        cicsLog.logExit("<init>");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void writeHeader(String string, String string2) throws InvalidRequestException, LengthErrorException {
        cicsLog.logEntry("writeHeader", new Object[]{string, string2});
        try {
            void value;
            void header;
            this.delegate.writeHeader((String)header, (String)value);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("writeHeader");
    }

    @InjectLogging
    public void setServerConvert() {
        cicsLog.logEntry("setServerConvert");
        this.delegate.setServerConvert(true);
        cicsLog.logExit("setServerConvert");
    }

    @InjectLogging
    public void setNoServerConvert() {
        cicsLog.logEntry("setNoServerConvert");
        this.delegate.setServerConvert(false);
        cicsLog.logExit("setNoServerConvert");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setClientCodePage(String string) {
        void characterset;
        cicsLog.logEntry("setClientCodePage", new Object[]{string});
        this.delegate.setCharacterset((String)characterset);
        cicsLog.logExit("setClientCodePage");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setCharacterset(String string) {
        void characterset;
        cicsLog.logEntry("setCharacterset", new Object[]{string});
        this.delegate.setCharacterset((String)characterset);
        cicsLog.logExit("setCharacterset");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setHostCodePage(String string) {
        void hostCodePage;
        cicsLog.logEntry("setHostCodePage", new Object[]{string});
        this.delegate.setHostCodePage((String)hostCodePage);
        cicsLog.logExit("setHostCodePage");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setMediaType(String string) {
        void mediaType;
        cicsLog.logEntry("setMediaType", new Object[]{string});
        this.delegate.setMediaType((String)mediaType);
        cicsLog.logExit("setMediaType");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setStatus(short s, String string) {
        void statusText;
        void statusCode;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setStatus", new Object[]{new Short(s), string});
        }
        this.delegate.setStatus((short)statusCode, (String)statusText);
        cicsLog.logExit("setStatus");
    }

    @InjectLogging
    public void setClose() {
        cicsLog.logEntry("setClose");
        this.delegate.setClose(true);
        cicsLog.logExit("setClose");
    }

    @InjectLogging
    public void setNoClose() {
        cicsLog.logEntry("setNoClose");
        this.delegate.setClose(false);
        cicsLog.logExit("setNoClose");
    }

    @InjectLogging
    public void setActionEventual() {
        cicsLog.logEntry("setActionEventual");
        this.delegate.setAction(false);
        cicsLog.logExit("setActionEventual");
    }

    @InjectLogging
    public void setActionImmediate() {
        cicsLog.logEntry("setActionImmediate");
        this.delegate.setAction(true);
        cicsLog.logExit("setActionImmediate");
    }

    @InjectLogging
    public void setDocDelete() {
        cicsLog.logEntry("setDocDelete");
        this.delegate.setDocDelete(true);
        cicsLog.logExit("setDocDelete");
    }

    @InjectLogging
    public void setNoDocDelete() {
        cicsLog.logEntry("setNoDocDelete");
        this.delegate.setDocDelete(false);
        cicsLog.logExit("setNoDocDelete");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendDocument(Document document, short s, String string, String string2) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        void doc;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("sendDocument", new Object[]{document, new Short(s), string, string2});
        }
        boolean docDeleted = false;
        try {
            void characterset;
            void statusText;
            void statusCode;
            docDeleted = this.delegate.sendDocument(doc.getDocToken(), (short)statusCode, (String)statusText, (String)characterset);
        }
        catch (DelegateError e) {
            HttpResponse.covertDelegateErrorToSENDJcicsErrors(e);
        }
        if (docDeleted) {
            doc.docDeleted();
        }
        cicsLog.logExit("sendDocument");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendDocument(Document document) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        void doc;
        cicsLog.logEntry("sendDocument", new Object[]{document});
        boolean docDeleted = false;
        try {
            docDeleted = this.delegate.sendDocument(doc.getDocToken());
        }
        catch (DelegateError e) {
            HttpResponse.covertDelegateErrorToSENDJcicsErrors(e);
        }
        if (docDeleted) {
            doc.docDeleted();
        }
        cicsLog.logExit("sendDocument");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendFrom(String string) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        cicsLog.logEntry("sendFrom", new Object[]{string});
        try {
            void from;
            this.delegate.sendFrom((String)from);
        }
        catch (DelegateError e) {
            HttpResponse.covertDelegateErrorToSENDJcicsErrors(e);
        }
        cicsLog.logExit("sendFrom");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendFrom(byte[] byArray) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("sendFrom", new Object[]{byArray});
        }
        try {
            void from;
            this.delegate.sendFrom((byte[])from);
        }
        catch (DelegateError e) {
            HttpResponse.covertDelegateErrorToSENDJcicsErrors(e);
        }
        cicsLog.logExit("sendFrom");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendChunk(String string) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        cicsLog.logEntry("sendChunk", new Object[]{string});
        try {
            void from;
            this.delegate.sendChunk((String)from);
        }
        catch (DelegateError e) {
            HttpResponse.covertDelegateErrorToSENDJcicsErrors(e);
        }
        cicsLog.logExit("sendChunk");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendChunk(byte[] byArray) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("sendChunk", new Object[]{byArray});
        }
        try {
            void from;
            this.delegate.sendChunk((byte[])from);
        }
        catch (DelegateError e) {
            HttpResponse.covertDelegateErrorToSENDJcicsErrors(e);
        }
        cicsLog.logExit("sendChunk");
    }

    @InjectLogging
    public void sendLastChunk() throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        cicsLog.logEntry("sendLastChunk");
        try {
            this.delegate.sendLastChunk();
        }
        catch (DelegateError e) {
            HttpResponse.covertDelegateErrorToSENDJcicsErrors(e);
        }
        cicsLog.logExit("sendLastChunk");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void sendContainer(Container container) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        void container2;
        cicsLog.logEntry("sendContainer", new Object[]{container});
        if (container2 == null) {
            throw new ContainerErrorException("Null Container", 2);
        }
        try {
            container2.getName();
            container2.getChannelName();
        }
        catch (Exception e) {
            throw new ContainerErrorException("Container deleted", 2, e);
        }
        try {
            this.delegate.sendContainer(container2.getName(), container2.getChannelName());
        }
        catch (DelegateError e) {
            HttpResponse.covertDelegateErrorToSENDJcicsErrors(e);
        }
        cicsLog.logExit("sendContainer");
    }

    private static void covertDelegateErrorToSENDJcicsErrors(DelegateError e) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        switch (e.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
            }
            case RECORD_NOT_FOUND: {
                throw new RecordNotFoundException(e.getMessage(), e.getResp2(), e);
            }
            case LENGTH_ERROR: {
                throw new LengthErrorException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
            }
            case IO_ERROR: {
                throw new IOErrorException(e.getMessage(), e.getResp2(), e.getResponseCode(), (Throwable)e);
            }
            case CONTAINER_ERROR: {
                throw new ContainerErrorException(e.getMessage(), e.getResp2(), e);
            }
            case CHANNEL_ERROR: {
                throw new ChannelErrorException(e.getMessage(), e.getResp2(), e);
            }
        }
        DelegateErrorHandler.handleUncheckedError(e);
    }

    static {
        cicsLog = LoggerFactory.getLogger(HttpResponse.class);
        NOTSET = DelegateHostType.NOTSET.getValue();
    }
}

