/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateHostType;
import com.ibm.cics.delegate.web.DelegateHttpSession;
import com.ibm.cics.delegate.web.DelegateScheme;
import com.ibm.cics.server.API;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.TimedOutException;

@InjectLogging(isEnabled=false)
public class HttpSession
extends API {
    public static final int NOTSET;
    public static final int NOTAPPLIC;
    public static final int IPV4;
    public static final int IPV6;
    public static final int HOSTNAME;
    private DelegateHttpSession delegate;
    private static final Logger cicsLog;

    @InjectLogging
    public HttpSession(String urimap) {
        cicsLog.logEntry("<init>", new Object[]{urimap});
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateHttpSession(urimap);
        cicsLog.logExit("<init>");
    }

    public HttpSession(String hostName, String schemeName) {
        this(hostName, schemeName, -1);
    }

    @InjectLogging
    public HttpSession(String hostName, String schemeName, int portNumber) {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("<init>", new Object[]{hostName, schemeName, new Integer(portNumber)});
        }
        DelegateScheme scheme = DelegateScheme.lookup((String)schemeName);
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateHttpSession(hostName, scheme, portNumber);
        cicsLog.logExit("<init>");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setCodePage(String string) {
        void codePage;
        cicsLog.logEntry("setCodePage", new Object[]{string});
        this.delegate.setCodePage((String)codePage);
        cicsLog.logExit("setCodePage");
    }

    public String getCodePage() {
        return this.delegate.getCodePage();
    }

    protected String getCodePageCharsetName() {
        return this.delegate.getCodePageCharsetName();
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setCertificate(String string) {
        void certificate;
        cicsLog.logEntry("setCertificate", new Object[]{string});
        this.delegate.setCertificate((String)certificate);
        cicsLog.logExit("setCertificate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setCiphers(String string, short s) {
        void numberCiphers;
        void ciphers;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setCiphers", new Object[]{string, new Short(s)});
        }
        this.delegate.setCiphers((String)ciphers, (short)numberCiphers);
        cicsLog.logExit("setCiphers");
    }

    @InjectLogging
    public void open() throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, TimedOutException, LengthErrorException {
        cicsLog.logEntry("open");
        try {
            this.delegate.open();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getLocalizedMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
        }
        cicsLog.logExit("open");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void open(boolean bl) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, TimedOutException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("open", new Object[]{new Boolean(bl)});
        }
        try {
            void options;
            this.delegate.open((boolean)options);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getLocalizedMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
        }
        cicsLog.logExit("open");
    }

    public int getHttpVersionNumber() {
        return this.delegate.getHttpVersionNumber();
    }

    public int getHttpReleaseNumber() {
        return this.delegate.getHttpReleaseNumber();
    }

    protected byte[] getSessionToken() {
        return this.delegate.getSessionToken();
    }

    @InjectLogging
    public void close() throws NotOpenException, InvalidRequestException {
        cicsLog.logEntry("close");
        try {
            this.delegate.close();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case NOT_OPEN: {
                    throw new NotOpenException(err.getLocalizedMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
        }
        cicsLog.logExit("close");
    }

    public String getHost() throws NotOpenException {
        try {
            return this.delegate.getHost();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case NOT_OPEN: {
                    throw new NotOpenException(err.getLocalizedMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
        }
    }

    public int getHostType() throws NotOpenException {
        try {
            return this.delegate.getHostType();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case NOT_OPEN: {
                    throw new NotOpenException(err.getLocalizedMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
        }
    }

    public String getPath() throws NotOpenException {
        try {
            return this.delegate.getPath();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case NOT_OPEN: {
                    throw new NotOpenException(err.getLocalizedMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
        }
    }

    public String getScheme() throws NotOpenException {
        try {
            return this.delegate.getScheme();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case NOT_OPEN: {
                    throw new NotOpenException(err.getLocalizedMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
        }
    }

    public String getVersion() throws NotOpenException {
        try {
            return this.delegate.getVersion();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case NOT_OPEN: {
                    throw new NotOpenException(err.getLocalizedMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
        }
    }

    public String getUrimap() throws NotOpenException {
        try {
            return this.delegate.getUrimap();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case NOT_OPEN: {
                    throw new NotOpenException(err.getLocalizedMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
        }
    }

    public int getPortNumber() throws NotOpenException {
        try {
            return this.delegate.getPortNumber();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case NOT_OPEN: {
                    throw new NotOpenException(err.getLocalizedMessage(), err.getResp2(), err);
                }
            }
            throw new RuntimeException("Unexpected error code from Delegate layer:" + err.getCode() + " " + err.getMessage(), err);
        }
    }

    static {
        cicsLog = LoggerFactory.getLogger(HttpSession.class);
        NOTSET = DelegateHostType.NOTSET.getValue();
        NOTAPPLIC = DelegateHostType.NOTAPPLIC.getValue();
        IPV4 = DelegateHostType.IPV4.getValue();
        IPV6 = DelegateHostType.IPV6.getValue();
        HOSTNAME = DelegateHostType.HOSTNAME.getValue();
    }
}

