/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.vsam.DelegateKSDS;
import com.ibm.cics.delegate.resource.vsam.DelegateKeyedFile;
import com.ibm.cics.server.ChangedException;
import com.ibm.cics.server.CicsError;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.DuplicateKeyException;
import com.ibm.cics.server.DuplicateRecordException;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.KeyedFile;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LoadingException;
import com.ibm.cics.server.LockedException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NoSpaceException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RecordBusyException;
import com.ibm.cics.server.RecordNotFoundException;

@InjectLogging(isEnabled=false)
public class KSDS
extends KeyedFile {
    private static final long serialVersionUID = -3061399328966602329L;
    private static final Logger cicsLog = LoggerFactory.getLogger(KSDS.class);

    @InjectLogging
    public KSDS() {
        super((DelegateKeyedFile)DelegateFactoryLoader.getDelegateFactory().createDelegateKSDS());
        cicsLog.logEntry("<init>");
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public KSDS(String name) {
        super((DelegateKeyedFile)DelegateFactoryLoader.getDelegateFactory().createDelegateKSDS());
        cicsLog.logEntry("<init>", new Object[]{name});
        this.setName(name);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public void delete() throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        cicsLog.logEntry("delete");
        try {
            ((DelegateKSDS)this.getDelegate()).delete();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case DUPLICATE_KEY: 
                case RECORD_NOT_FOUND: {
                    throw new CicsError(err.getMessage(), err);
                }
            }
            KSDS.throwCommonJCICSExceptions(err);
        }
        cicsLog.logExit("delete");
    }

    private static void throwCommonJCICSExceptions(DelegateError err) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        switch (err.getCode()) {
            case FILE_DISABLED: {
                throw new FileDisabledException(err.getMessage(), err.getResp2(), err);
            }
            case FILE_NOT_FOUND: {
                throw new FileNotFoundException(err.getMessage(), err.getResp2(), err);
            }
            case LOGIC: {
                throw new LogicException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case IO_ERROR: {
                throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case ISC_INVALID_REQUEST: {
                throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case NOT_AUTHORISED: {
                throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
            }
            case NOT_OPEN: {
                throw new NotOpenException(err.getMessage(), err.getResp2(), err);
            }
            case INVALID_SYSTEM_ID: {
                throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case CHANGED: {
                throw new ChangedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LOCKED: {
                throw new LockedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LOADING: {
                throw new LoadingException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case RECORD_BUSY: {
                throw new RecordBusyException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void delete(byte[] byArray) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("delete", new Object[]{byArray});
        }
        try {
            void key;
            ((DelegateKSDS)this.getDelegate()).delete((byte[])key);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            KSDS.throwCommonJCICSExceptions(err);
        }
        cicsLog.logExit("delete");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public int deleteGeneric(byte[] byArray) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("deleteGeneric", new Object[]{byArray});
        }
        int numberDeleted = 0;
        try {
            void key;
            numberDeleted = ((DelegateKSDS)this.getDelegate()).deleteGeneric((byte[])key);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case DUPLICATE_KEY: {
                    throw new CicsError("Unexpected DuplicateKeyException caught", err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            KSDS.throwCommonJCICSExceptions(err);
        }
        int n = numberDeleted;
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            int n2 = n;
            cicsLog.logExit("deleteGeneric", new Object[]{new Integer(n2)});
            n = n2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void write(byte[] byArray, byte[] byArray2) throws FileDisabledException, DuplicateRecordException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("write", new Object[]{byArray, byArray2});
        }
        try {
            void data;
            void key;
            ((DelegateKSDS)this.getDelegate()).write((byte[])key, (byte[])data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case DUPLICATE_RECORD: {
                    throw new DuplicateRecordException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NO_SPACE: {
                    throw new NoSpaceException(err.getMessage(), err.getResp2(), err);
                }
            }
            KSDS.throwCommonJCICSExceptions(err);
        }
        cicsLog.logExit("write");
    }
}

