/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateDataHolder;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.vsam.DelegateFile;
import com.ibm.cics.delegate.resource.vsam.DelegateKeyedFile;
import com.ibm.cics.server.ChangedException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.DuplicateKeyException;
import com.ibm.cics.server.DuplicateRecordException;
import com.ibm.cics.server.File;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.KeyedFileBrowse;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LoadingException;
import com.ibm.cics.server.LockedException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NoSpaceException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RecordBusyException;
import com.ibm.cics.server.RecordHolder;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.SearchType;
import com.ibm.cics.server.Task;

@InjectLogging(isEnabled=false)
public class KeyedFile
extends File {
    private static final long serialVersionUID = -5327458558427905768L;
    private static final Logger cicsLog = LoggerFactory.getLogger(KeyedFile.class);

    @InjectLogging
    public KeyedFile() {
        super((DelegateFile)DelegateFactoryLoader.getDelegateFactory().createDelegateKeyedFile());
        cicsLog.logEntry("<init>");
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public KeyedFile(String name) {
        this();
        cicsLog.logEntry("<init>", new Object[]{name});
        this.setName(name);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    protected KeyedFile(DelegateKeyedFile delegate) {
        super((DelegateFile)delegate);
        cicsLog.logEntry("<init>", new Object[]{delegate});
        cicsLog.logExit("<init>");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void read(byte[] byArray, RecordHolder recordHolder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("read", new Object[]{byArray, recordHolder});
        }
        try {
            void key;
            void holder;
            DelegateDataHolder delegateDataHolder = holder.getDelegate();
            ((DelegateKeyedFile)this.getDelegate()).read((byte[])key, delegateDataHolder);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            KeyedFile.throwJCICSException(err);
        }
        cicsLog.logExit("read");
    }

    private static void throwJCICSExceptionWithDuplicateKey(DelegateError err) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        switch (err.getCode()) {
            case DUPLICATE_KEY: {
                throw new DuplicateKeyException(err.getMessage(), err.getResp2(), err);
            }
            case RECORD_NOT_FOUND: {
                throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
            }
        }
        KeyedFile.throwJCICSException(err);
    }

    private static void throwJCICSException(DelegateError err) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        switch (err.getCode()) {
            case FILE_DISABLED: {
                throw new FileDisabledException(err.getMessage(), err.getResp2(), err);
            }
            case FILE_NOT_FOUND: {
                throw new FileNotFoundException(err.getMessage(), err.getResp2(), err);
            }
            case LOGIC: {
                throw new LogicException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case IO_ERROR: {
                throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case ISC_INVALID_REQUEST: {
                throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case NOT_AUTHORISED: {
                throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
            }
            case NOT_OPEN: {
                throw new NotOpenException(err.getMessage(), err.getResp2(), err);
            }
            case INVALID_SYSTEM_ID: {
                throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case CHANGED: {
                throw new ChangedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LOCKED: {
                throw new LockedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LOADING: {
                throw new LoadingException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case RECORD_BUSY: {
                throw new RecordBusyException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void read(byte[] byArray, SearchType searchType, RecordHolder recordHolder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("read", new Object[]{byArray, searchType, recordHolder});
        }
        try {
            void searchType2;
            void key;
            void holder;
            DelegateDataHolder delegateDataHolder = holder.getDelegate();
            ((DelegateKeyedFile)this.getDelegate()).read((byte[])key, searchType2.getDelegateSearchType(), delegateDataHolder);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            KeyedFile.throwJCICSExceptionWithDuplicateKey(err);
        }
        cicsLog.logExit("read");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void readForUpdate(byte[] byArray, RecordHolder recordHolder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("readForUpdate", new Object[]{byArray, recordHolder});
        }
        try {
            void key;
            void holder;
            DelegateDataHolder delegateDataHolder = holder.getDelegate();
            ((DelegateKeyedFile)this.getDelegate()).readForUpdate((byte[])key, delegateDataHolder);
        }
        catch (DelegateError err) {
            KeyedFile.throwJCICSExceptionWithDuplicateKey(err);
        }
        cicsLog.logExit("readForUpdate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void readForUpdate(byte[] byArray, SearchType searchType, RecordHolder recordHolder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("readForUpdate", new Object[]{byArray, searchType, recordHolder});
        }
        try {
            void searchType2;
            void key;
            void holder;
            DelegateDataHolder delegateDataHolder = holder.getDelegate();
            ((DelegateKeyedFile)this.getDelegate()).readForUpdate((byte[])key, searchType2.getDelegateSearchType(), delegateDataHolder);
        }
        catch (DelegateError err) {
            KeyedFile.throwJCICSExceptionWithDuplicateKey(err);
        }
        cicsLog.logExit("readForUpdate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void readGeneric(byte[] byArray, RecordHolder recordHolder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("readGeneric", new Object[]{byArray, recordHolder});
        }
        try {
            void key;
            void holder;
            DelegateDataHolder delegateDataHolder = holder.getDelegate();
            ((DelegateKeyedFile)this.getDelegate()).readGeneric((byte[])key, delegateDataHolder);
        }
        catch (DelegateError err) {
            KeyedFile.throwJCICSExceptionWithDuplicateKey(err);
        }
        cicsLog.logExit("readGeneric");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void readGeneric(byte[] byArray, SearchType searchType, RecordHolder recordHolder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("readGeneric", new Object[]{byArray, searchType, recordHolder});
        }
        try {
            void searchType2;
            void key;
            void holder;
            DelegateDataHolder delegateDataHolder = holder.getDelegate();
            ((DelegateKeyedFile)this.getDelegate()).readGeneric((byte[])key, searchType2.getDelegateSearchType(), delegateDataHolder);
        }
        catch (DelegateError err) {
            KeyedFile.throwJCICSExceptionWithDuplicateKey(err);
        }
        cicsLog.logExit("readGeneric");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void readGenericForUpdate(byte[] byArray, RecordHolder recordHolder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("readGenericForUpdate", new Object[]{byArray, recordHolder});
        }
        try {
            void key;
            void holder;
            DelegateDataHolder delegateDataHolder = holder.getDelegate();
            ((DelegateKeyedFile)this.getDelegate()).readGenericForUpdate((byte[])key, delegateDataHolder);
        }
        catch (DelegateError err) {
            KeyedFile.throwJCICSExceptionWithDuplicateKey(err);
        }
        cicsLog.logExit("readGenericForUpdate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void readGenericForUpdate(byte[] byArray, SearchType searchType, RecordHolder recordHolder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("readGenericForUpdate", new Object[]{byArray, searchType, recordHolder});
        }
        try {
            void searchType2;
            void key;
            void holder;
            DelegateDataHolder delegateDataHolder = holder.getDelegate();
            ((DelegateKeyedFile)this.getDelegate()).readGenericForUpdate((byte[])key, searchType2.getDelegateSearchType(), delegateDataHolder);
        }
        catch (DelegateError err) {
            KeyedFile.throwJCICSExceptionWithDuplicateKey(err);
        }
        cicsLog.logExit("readGenericForUpdate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void rewrite(byte[] byArray) throws FileDisabledException, DuplicateRecordException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("rewrite", new Object[]{byArray});
        }
        try {
            void data;
            ((DelegateKeyedFile)this.getDelegate()).rewrite((byte[])data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case DUPLICATE_RECORD: {
                    throw new DuplicateRecordException();
                }
            }
            KeyedFile.throwJCICSException(err);
        }
        cicsLog.logExit("rewrite");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public KeyedFileBrowse startBrowse(byte[] byArray) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, RecordBusyException, LoadingException, ChangedException {
        KeyedFileBrowse newBrowse;
        void key;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("startBrowse", new Object[]{byArray});
        }
        if (key == null) {
            throw new NullPointerException("null key in KeyedFile.startBrowse()");
        }
        KeyedFileBrowse keyedFileBrowse = newBrowse = new KeyedFileBrowse(this.getName(), this.getSysId(), Task.getTask().getTaskNumber(), (byte[])key, ((void)key).length, false, 0);
        cicsLog.logExit("startBrowse", new Object[]{keyedFileBrowse});
        return keyedFileBrowse;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public KeyedFileBrowse startBrowse(byte[] byArray, SearchType searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        void searchType2;
        KeyedFileBrowse newBrowse;
        void key;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("startBrowse", new Object[]{byArray, searchType});
        }
        if (key == null) {
            throw new NullPointerException("null key in KeyedFile.startBrowse()");
        }
        KeyedFileBrowse keyedFileBrowse = newBrowse = new KeyedFileBrowse(this.getName(), this.getSysId(), Task.getTask().getTaskNumber(), (byte[])key, ((void)key).length, false, searchType2.hashCode());
        cicsLog.logExit("startBrowse", new Object[]{keyedFileBrowse});
        return keyedFileBrowse;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public KeyedFileBrowse startGenericBrowse(byte[] byArray, int n) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        void fullKeyLength;
        KeyedFileBrowse newBrowse;
        void key;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("startGenericBrowse", new Object[]{byArray, new Integer(n)});
        }
        if (key == null) {
            throw new NullPointerException("null key in KeyedFile.startGenericBrowse()");
        }
        KeyedFileBrowse keyedFileBrowse = newBrowse = new KeyedFileBrowse(this.getName(), this.getSysId(), Task.getTask().getTaskNumber(), (byte[])key, (int)fullKeyLength, true, 0);
        cicsLog.logExit("startGenericBrowse", new Object[]{keyedFileBrowse});
        return keyedFileBrowse;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public KeyedFileBrowse startGenericBrowse(byte[] byArray, int n, SearchType searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        void searchType2;
        void fullKeyLength;
        KeyedFileBrowse newBrowse;
        void key;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("startGenericBrowse", new Object[]{byArray, new Integer(n), searchType});
        }
        if (key == null) {
            throw new NullPointerException("null key in KeyedFile.startGenericBrowse()");
        }
        KeyedFileBrowse keyedFileBrowse = newBrowse = new KeyedFileBrowse(this.getName(), this.getSysId(), Task.getTask().getTaskNumber(), (byte[])key, (int)fullKeyLength, true, searchType2.hashCode());
        cicsLog.logExit("startGenericBrowse", new Object[]{keyedFileBrowse});
        return keyedFileBrowse;
    }
}

