/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.vsam.DelegateFileBrowse;
import com.ibm.cics.delegate.resource.vsam.DelegateKeyedFileBrowse;
import com.ibm.cics.delegate.resource.vsam.DelegateSearchType;
import com.ibm.cics.server.ChangedException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.DuplicateKeyException;
import com.ibm.cics.server.EndOfFileException;
import com.ibm.cics.server.FileBrowse;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.KeyHolder;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LoadingException;
import com.ibm.cics.server.LockedException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RecordBusyException;
import com.ibm.cics.server.RecordHolder;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.SearchType;

@InjectLogging(isEnabled=false)
public class KeyedFileBrowse
extends FileBrowse {
    private static final Logger cicsLog = LoggerFactory.getLogger(KeyedFileBrowse.class);

    protected KeyedFileBrowse(String fileName, String sysId, int currentTaskId) {
        this(DelegateFactoryLoader.getDelegateFactory().createDelegateKeyedFileBrowse(fileName, sysId, currentTaskId));
    }

    protected KeyedFileBrowse(DelegateKeyedFileBrowse delegate) {
        super((DelegateFileBrowse)delegate);
    }

    protected KeyedFileBrowse(String fileName, String sysId, int currentTaskId, byte[] key, int fullKeyLength, boolean generic, int searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        this(KeyedFileBrowse.createDelegate(fileName, sysId, currentTaskId, key, fullKeyLength, generic, searchType));
    }

    private static DelegateKeyedFileBrowse createDelegate(String fileName, String sysId, int currentTaskId, byte[] key, int fullKeyLength, boolean generic, int searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DelegateKeyedFileBrowse delegate;
        try {
            delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateKeyedFileBrowse(fileName, sysId, currentTaskId, key, fullKeyLength, generic, DelegateSearchType.lookup((int)searchType));
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case FILE_DISABLED: {
                    throw new FileDisabledException(err.getMessage(), err.getResp2(), err);
                }
                case FILE_NOT_FOUND: {
                    throw new FileNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case LOGIC: {
                    throw new LogicException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case NOT_OPEN: {
                    throw new NotOpenException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case CHANGED: {
                    throw new ChangedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LOCKED: {
                    throw new LockedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LOADING: {
                    throw new LoadingException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case RECORD_BUSY: {
                    throw new RecordBusyException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
            return null;
        }
        return delegate;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void next(byte[] byArray, RecordHolder recordHolder, KeyHolder keyHolder) throws FileDisabledException, DuplicateKeyException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("next", new Object[]{byArray, recordHolder, keyHolder});
        }
        try {
            void outputKey;
            void record;
            void inputKey;
            ((DelegateKeyedFileBrowse)this.getDelegate()).next((byte[])inputKey, record.getDelegate(), outputKey.getDelegate());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case DUPLICATE_KEY: {
                    throw new DuplicateKeyException(err.getMessage(), err.getResp2(), err);
                }
                case END_OF_FILE: {
                    throw new EndOfFileException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            KeyedFileBrowse.handleCommonJCICSErrors(err);
        }
        cicsLog.logExit("next");
    }

    private static void handleCommonJCICSErrors(DelegateError err) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        switch (err.getCode()) {
            case RECORD_NOT_FOUND: {
                throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
            }
            case FILE_DISABLED: {
                throw new FileDisabledException(err.getMessage(), err.getResp2(), err);
            }
            case FILE_NOT_FOUND: {
                throw new FileNotFoundException(err.getMessage(), err.getResp2(), err);
            }
            case LOGIC: {
                throw new LogicException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case IO_ERROR: {
                throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case ISC_INVALID_REQUEST: {
                throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case NOT_AUTHORISED: {
                throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
            }
            case NOT_OPEN: {
                throw new NotOpenException(err.getMessage(), err.getResp2(), err);
            }
            case INVALID_SYSTEM_ID: {
                throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case CHANGED: {
                throw new ChangedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LOCKED: {
                throw new LockedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LOADING: {
                throw new LoadingException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case RECORD_BUSY: {
                throw new RecordBusyException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void next(RecordHolder recordHolder, KeyHolder keyHolder) throws FileDisabledException, DuplicateKeyException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        cicsLog.logEntry("next", new Object[]{recordHolder, keyHolder});
        try {
            void outputKey;
            void record;
            ((DelegateKeyedFileBrowse)this.getDelegate()).next(record.getDelegate(), outputKey.getDelegate());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case DUPLICATE_KEY: {
                    throw new DuplicateKeyException(err.getMessage(), err.getResp2(), err);
                }
                case END_OF_FILE: {
                    throw new EndOfFileException(err.getMessage(), err.getResp2(), err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            KeyedFileBrowse.handleCommonJCICSErrors(err);
        }
        cicsLog.logExit("next");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void previous(byte[] byArray, RecordHolder recordHolder, KeyHolder keyHolder) throws FileDisabledException, DuplicateKeyException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("previous", new Object[]{byArray, recordHolder, keyHolder});
        }
        try {
            void outputKey;
            void record;
            void inputKey;
            ((DelegateKeyedFileBrowse)this.getDelegate()).previous((byte[])inputKey, record.getDelegate(), outputKey.getDelegate());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case DUPLICATE_KEY: {
                    throw new DuplicateKeyException(err.getMessage(), err.getResp2(), err);
                }
            }
            KeyedFileBrowse.handleCommonJCICSErrors(err);
        }
        cicsLog.logExit("previous");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void previous(RecordHolder recordHolder, KeyHolder keyHolder) throws FileDisabledException, DuplicateKeyException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        cicsLog.logEntry("previous", new Object[]{recordHolder, keyHolder});
        try {
            void outputKey;
            void record;
            ((DelegateKeyedFileBrowse)this.getDelegate()).previous(record.getDelegate(), outputKey.getDelegate());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case DUPLICATE_KEY: {
                    throw new DuplicateKeyException(err.getMessage(), err.getResp2(), err);
                }
            }
            KeyedFileBrowse.handleCommonJCICSErrors(err);
        }
        cicsLog.logExit("previous");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void reset(byte[] byArray) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("reset", new Object[]{byArray});
        }
        try {
            void key;
            ((DelegateKeyedFileBrowse)this.getDelegate()).reset((byte[])key);
        }
        catch (DelegateError err) {
            KeyedFileBrowse.handleResetJCICSErrors(err);
        }
        cicsLog.logExit("reset");
    }

    private static void handleResetJCICSErrors(DelegateError err) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        KeyedFileBrowse.handleCommonJCICSErrors(err);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void reset(byte[] byArray, SearchType searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("reset", new Object[]{byArray, searchType});
        }
        try {
            void key;
            void theSearchType;
            SearchType searchType2 = theSearchType;
            if (searchType2 == null) {
                searchType2 = SearchType.GTEQ;
            }
            ((DelegateKeyedFileBrowse)this.getDelegate()).reset((byte[])key, searchType2.getDelegateSearchType());
        }
        catch (DelegateError err) {
            KeyedFileBrowse.handleResetJCICSErrors(err);
        }
        cicsLog.logExit("reset");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void reset(byte[] byArray, boolean bl) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("reset", new Object[]{byArray, new Boolean(bl)});
        }
        try {
            void generic;
            void key;
            ((DelegateKeyedFileBrowse)this.getDelegate()).reset((byte[])key, (boolean)generic);
        }
        catch (DelegateError err) {
            KeyedFileBrowse.handleResetJCICSErrors(err);
        }
        cicsLog.logExit("reset");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void reset(byte[] byArray, boolean bl, SearchType searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("reset", new Object[]{byArray, new Boolean(bl), searchType});
        }
        try {
            void generic;
            void key;
            void theSearchType;
            SearchType searchType2 = theSearchType;
            if (searchType2 == null) {
                searchType2 = SearchType.GTEQ;
            }
            ((DelegateKeyedFileBrowse)this.getDelegate()).reset((byte[])key, (boolean)generic, searchType2.getDelegateSearchType());
        }
        catch (DelegateError err) {
            KeyedFileBrowse.handleResetJCICSErrors(err);
        }
        cicsLog.logExit("reset");
    }
}

