/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.DelegateUnitOfWork;
import com.ibm.cics.delegate.resource.DelegateResource;
import com.ibm.cics.delegate.resource.execution.DelegateProgram;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidProgramIdException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.RemotableResource;
import com.ibm.cics.server.RolledBackException;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.TerminalException;

@InjectLogging(isEnabled=false)
public class Program
extends RemotableResource {
    private static final long serialVersionUID = -4417976934390189065L;
    private static final Logger cicsLog = LoggerFactory.getLogger(Program.class);

    @InjectLogging
    public Program() {
        super((DelegateResource)DelegateFactoryLoader.getDelegateFactory().createDelegateProgram());
        cicsLog.logEntry("<init>");
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public Program(String name) {
        super((DelegateResource)DelegateFactoryLoader.getDelegateFactory().createDelegateProgram());
        cicsLog.logEntry("<init>", new Object[]{name});
        this.setName(name);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public boolean getSyncOnReturn() {
        cicsLog.logEntry("getSyncOnReturn");
        boolean bl = ((DelegateProgram)this.getDelegate()).isSyncOnReturn();
        if (cicsLog.shouldTrace(LogType.EXIT)) {
            boolean bl2 = bl;
            cicsLog.logExit("getSyncOnReturn", new Object[]{new Boolean(bl2)});
            bl = bl2;
        }
        return bl;
    }

    @InjectLogging
    public String getTransId() {
        cicsLog.logEntry("getTransId");
        String string = ((DelegateProgram)this.getDelegate()).getTransId();
        cicsLog.logExit("getTransId", new Object[]{string});
        return string;
    }

    @InjectLogging
    public void link() throws InvalidRequestException, LengthErrorException, NotAuthorisedException, InvalidProgramIdException, RolledBackException, InvalidSystemIdException, TerminalException {
        cicsLog.logEntry("link");
        try {
            DelegateUnitOfWork unitOfWork = Task.getTask().getDelegateUnitOfWork();
            ((DelegateProgram)this.getDelegate()).link(null, 0, null, unitOfWork);
        }
        catch (DelegateError err) {
            Program.handleLinkError(err);
        }
        cicsLog.logExit("link");
    }

    private static void handleLinkError(DelegateError err) throws InvalidRequestException, LengthErrorException, NotAuthorisedException, InvalidProgramIdException, RolledBackException, InvalidSystemIdException, TerminalException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LENGTH_ERROR: {
                throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case NOT_AUTHORISED: {
                throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
            }
            case INVALID_PROGRAM_ID: {
                throw new InvalidProgramIdException(err.getMessage(), err.getResp2(), err);
            }
            case ROLLED_BACK: {
                throw new RolledBackException(err.getMessage(), err.getResp2(), err);
            }
            case INVALID_SYSTEM_ID: {
                throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case TERMINAL: {
                throw new TerminalException(err.getMessage(), err.getResp2(), err);
            }
            case CHANNEL_ERROR: {
                break;
            }
            default: {
                DelegateErrorHandler.handleUncheckedError(err);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void link(byte[] byArray) throws InvalidRequestException, LengthErrorException, NotAuthorisedException, InvalidProgramIdException, RolledBackException, InvalidSystemIdException, TerminalException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("link", new Object[]{byArray});
        }
        try {
            void CA;
            DelegateUnitOfWork unitOfWork = Task.getTask().getDelegateUnitOfWork();
            ((DelegateProgram)this.getDelegate()).link((byte[])CA, ((void)CA).length, null, unitOfWork);
        }
        catch (DelegateError err) {
            Program.handleLinkError(err);
        }
        cicsLog.logExit("link");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void link(byte[] byArray, int n) throws InvalidRequestException, LengthErrorException, NotAuthorisedException, InvalidProgramIdException, RolledBackException, InvalidSystemIdException, TerminalException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("link", new Object[]{byArray, new Integer(n)});
        }
        try {
            void DATALENGTH;
            void CA;
            DelegateUnitOfWork unitOfWork = Task.getTask().getDelegateUnitOfWork();
            ((DelegateProgram)this.getDelegate()).link((byte[])CA, (int)DATALENGTH, null, unitOfWork);
        }
        catch (DelegateError err) {
            Program.handleLinkError(err);
        }
        cicsLog.logExit("link");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void link(Channel channel) throws InvalidRequestException, LengthErrorException, NotAuthorisedException, InvalidProgramIdException, RolledBackException, InvalidSystemIdException, TerminalException, ChannelErrorException {
        cicsLog.logEntry("link", new Object[]{channel});
        try {
            void chan;
            DelegateUnitOfWork unitOfWork = Task.getTask().getDelegateUnitOfWork();
            ((DelegateProgram)this.getDelegate()).link(null, 0, chan == null ? null : chan.getName(), unitOfWork);
        }
        catch (DelegateError err) {
            Program.handleLinkError(err);
        }
        cicsLog.logExit("link");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setSyncOnReturn(boolean bl) {
        void syncOnReturn;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setSyncOnReturn", new Object[]{new Boolean(bl)});
        }
        ((DelegateProgram)this.getDelegate()).setSyncOnReturn((boolean)syncOnReturn);
        cicsLog.logExit("setSyncOnReturn");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void setTransId(String string) {
        void TRANSID;
        cicsLog.logEntry("setTransId", new Object[]{string});
        ((DelegateProgram)this.getDelegate()).setTransId((String)TRANSID);
        cicsLog.logExit("setTransId");
    }
}

