/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.vsam.DelegateFile;
import com.ibm.cics.delegate.resource.vsam.DelegateRRDS;
import com.ibm.cics.server.ChangedException;
import com.ibm.cics.server.CicsError;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.DuplicateRecordException;
import com.ibm.cics.server.File;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LoadingException;
import com.ibm.cics.server.LockedException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NoSpaceException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RRDS_Browse;
import com.ibm.cics.server.RecordBusyException;
import com.ibm.cics.server.RecordHolder;
import com.ibm.cics.server.RecordNotFoundException;

@InjectLogging(isEnabled=false)
public class RRDS
extends File {
    private static final long serialVersionUID = 8384111062303379383L;
    private static final Logger cicsLog = LoggerFactory.getLogger(RRDS.class);

    @InjectLogging
    public RRDS() {
        super((DelegateFile)DelegateFactoryLoader.getDelegateFactory().createDelegateRRDS());
        cicsLog.logEntry("<init>");
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public RRDS(String name) {
        super((DelegateFile)DelegateFactoryLoader.getDelegateFactory().createDelegateRRDS());
        cicsLog.logEntry("<init>", new Object[]{name});
        this.setName(name);
        cicsLog.logExit("<init>");
    }

    @InjectLogging
    public void delete() throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        cicsLog.logEntry("delete");
        try {
            ((DelegateRRDS)this.getDelegate()).delete();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            RRDS.throwVeryCommonJCICSException(err);
        }
        cicsLog.logExit("delete");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void delete(long l) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(l);
            cicsLog.logEntry("delete", objectArray);
        }
        try {
            void recordNumber;
            ((DelegateRRDS)this.getDelegate()).delete((long)recordNumber);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            RRDS.throwVeryCommonJCICSException(err);
        }
        cicsLog.logExit("delete");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void read(long l, RecordHolder recordHolder) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = new Long(l);
            objectArray[1] = recordHolder;
            cicsLog.logEntry("read", objectArray);
        }
        try {
            void record;
            void recordNumber;
            ((DelegateRRDS)this.getDelegate()).read((long)recordNumber, record.getDelegate());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            RRDS.throwCommonJCICSException(err);
        }
        cicsLog.logExit("read");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void readForUpdate(long l, RecordHolder recordHolder) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = new Long(l);
            objectArray[1] = recordHolder;
            cicsLog.logEntry("readForUpdate", objectArray);
        }
        try {
            void record;
            void recordNumber;
            ((DelegateRRDS)this.getDelegate()).readForUpdate((long)recordNumber, record.getDelegate());
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
            }
            RRDS.throwCommonJCICSException(err);
        }
        cicsLog.logExit("readForUpdate");
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void rewrite(byte[] byArray) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("rewrite", new Object[]{byArray});
        }
        try {
            void data;
            ((DelegateRRDS)this.getDelegate()).rewrite((byte[])data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case NO_SPACE: {
                    throw new NoSpaceException(err.getMessage(), err.getResp2(), err);
                }
                case DUPLICATE_RECORD: {
                    throw new CicsError("DuplicateRecordException not expected", err);
                }
            }
            RRDS.throwCommonJCICSException(err);
        }
        cicsLog.logExit("rewrite");
    }

    private static void throwVeryCommonJCICSException(DelegateError err) throws FileDisabledException, RecordBusyException, ChangedException, LoadingException, LockedException, InvalidSystemIdException, NotOpenException, NotAuthorisedException, ISCInvalidRequestException, IOErrorException, InvalidRequestException, LogicException, FileNotFoundException {
        switch (err.getCode()) {
            case FILE_DISABLED: {
                throw new FileDisabledException(err.getMessage(), err.getResp2(), err);
            }
            case FILE_NOT_FOUND: {
                throw new FileNotFoundException(err.getMessage(), err.getResp2(), err);
            }
            case LOGIC: {
                throw new LogicException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case IO_ERROR: {
                throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case ISC_INVALID_REQUEST: {
                throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case NOT_AUTHORISED: {
                throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
            }
            case NOT_OPEN: {
                throw new NotOpenException(err.getMessage(), err.getResp2(), err);
            }
            case INVALID_SYSTEM_ID: {
                throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case CHANGED: {
                throw new ChangedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LOCKED: {
                throw new LockedException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case LOADING: {
                throw new LoadingException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case RECORD_BUSY: {
                throw new RecordBusyException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }

    private static void throwCommonJCICSException(DelegateError err) throws FileDisabledException, RecordBusyException, ChangedException, LoadingException, LockedException, InvalidSystemIdException, NotOpenException, LengthErrorException, NotAuthorisedException, ISCInvalidRequestException, IOErrorException, InvalidRequestException, LogicException, FileNotFoundException {
        switch (err.getCode()) {
            case LENGTH_ERROR: {
                throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        RRDS.throwVeryCommonJCICSException(err);
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public RRDS_Browse startBrowse(long l) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LoadingException {
        void recordNumber;
        RRDS_Browse newBrowse;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(l);
            cicsLog.logEntry("startBrowse", objectArray);
        }
        RRDS_Browse rRDS_Browse = newBrowse = new RRDS_Browse(this.getName(), this.getSysId(), (long)recordNumber);
        cicsLog.logExit("startBrowse", new Object[]{rRDS_Browse});
        return rRDS_Browse;
    }

    /*
     * WARNING - void declaration
     */
    @InjectLogging
    public void write(long l, byte[] byArray) throws FileDisabledException, DuplicateRecordException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = new Long(l);
            objectArray[1] = byArray;
            cicsLog.logEntry("write", objectArray);
        }
        try {
            void data;
            void recordNumber;
            ((DelegateRRDS)this.getDelegate()).write((long)recordNumber, (byte[])data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case DUPLICATE_RECORD: {
                    throw new DuplicateRecordException(err.getMessage(), err.getResp2(), err);
                }
                case NO_SPACE: {
                    throw new NoSpaceException(err.getMessage(), err.getResp2(), err);
                }
            }
            RRDS.throwCommonJCICSException(err);
        }
        cicsLog.logExit("write");
    }
}

