/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.InjectLogging;
import com.ibm.cics.common.log.LogType;
import com.ibm.cics.common.log.Logger;
import com.ibm.cics.common.log.LoggerFactory;
import com.ibm.cics.delegate.DelegateDataHolder;
import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.DelegateRegion;
import com.ibm.cics.server.CWAHolder;
import com.ibm.cics.server.CicsRuntimeException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.RegionTraceBits;
import com.ibm.cics.server.internal.JCICSLateBinding;
import java.util.BitSet;

@InjectLogging(isEnabled=false)
public class Region
implements RegionTraceBits {
    private static boolean isBoundToTask;
    private static final Logger cicsLog;

    private static DelegateRegion getDelegate() {
        DelegateRegion delegate = DelegateFactoryLoader.getDelegateFactory().getDelegateRegion();
        return delegate;
    }

    @Deprecated
    @InjectLogging
    public static void disableTrace() {
        cicsLog.logEntry("disableTrace");
        JCICSLateBinding.bindTaskIfRequired();
        throw new CicsRuntimeException("disableTrace not supported in this release.");
    }

    @Deprecated
    @InjectLogging
    public static void disableTrace(BitSet bitSet) {
        cicsLog.logEntry("disableTrace", new Object[]{bitSet});
        JCICSLateBinding.bindTaskIfRequired();
        throw new CicsRuntimeException("disableTrace not supported in this release.");
    }

    @Deprecated
    @InjectLogging
    public static void enableTrace() {
        cicsLog.logEntry("enableTrace");
        JCICSLateBinding.bindTaskIfRequired();
        throw new CicsRuntimeException("enableTrace not supported in this release.");
    }

    @Deprecated
    @InjectLogging
    public static void enableTrace(BitSet bitSet) {
        cicsLog.logEntry("enableTrace", new Object[]{bitSet});
        JCICSLateBinding.bindTaskIfRequired();
        throw new CicsRuntimeException("enableTrace not supported in this release.");
    }

    @InjectLogging
    public static String getAPPLID() {
        cicsLog.logEntry("getAPPLID");
        Region.makeSureBoundToTask();
        String applId = null;
        try {
            applId = Region.getDelegate().getAPPLID();
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
        String string = applId;
        cicsLog.logExit("getAPPLID", new Object[]{string});
        return string;
    }

    private static void makeSureBoundToTask() {
        if (!isBoundToTask) {
            JCICSLateBinding.bindTaskIfRequired();
        }
    }

    @InjectLogging
    public static void getCWA(CWAHolder cWAHolder) {
        CWAHolder holder;
        cicsLog.logEntry("getCWA", new Object[]{cWAHolder});
        if (holder == null) {
            throw new NullPointerException("null holder in Region.getCWA()");
        }
        Region.makeSureBoundToTask();
        DelegateDataHolder dataHolder = holder.getDelegate();
        try {
            Region.getDelegate().getCWAContents(dataHolder);
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("getCWA");
    }

    @InjectLogging
    public static String getSYSID() {
        cicsLog.logEntry("getSYSID");
        String sysId = null;
        Region.makeSureBoundToTask();
        try {
            sysId = Region.getDelegate().getSYSID();
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
        String string = sysId;
        cicsLog.logExit("getSYSID", new Object[]{string});
        return string;
    }

    @InjectLogging
    static void setAPPLID(String string) {
        String applid;
        cicsLog.logEntry("setAPPLID", new Object[]{string});
        Region.getDelegate().setTemporaryApplIdOverride(applid);
        cicsLog.logExit("setAPPLID");
    }

    @InjectLogging
    public static void setCWA(byte[] byArray) {
        byte[] data;
        if (cicsLog.shouldTrace(LogType.ENTRY)) {
            cicsLog.logEntry("setCWA", new Object[]{byArray});
        }
        if (data == null) {
            throw new NullPointerException("null data in setCWA()");
        }
        Region.makeSureBoundToTask();
        try {
            Region.getDelegate().setCWAContents(data);
        }
        catch (DelegateError err) {
            DelegateErrorHandler.handleUncheckedError(err);
        }
        cicsLog.logExit("setCWA");
    }

    @InjectLogging
    static void setSYSID(String string) {
        String SYSID;
        cicsLog.logEntry("setSYSID", new Object[]{string});
        Region.getDelegate().setTemporarySYSIDOverride(SYSID);
        cicsLog.logExit("setSYSID");
    }

    static {
        cicsLog = LoggerFactory.getLogger(Region.class);
        isBoundToTask = false;
    }
}

