/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.EnvironmentConstants;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.DelegateRetrievedData;
import java.io.UnsupportedEncodingException;

public class RetrievedData {
    private static final String localCCSID = EnvironmentConstants.env.getLocalCCSID();
    private DelegateRetrievedData delegate;

    RetrievedData(byte[] data, String transId, String termId, byte[] queue) {
        this.delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateRetrievedData(data, transId, termId, queue);
    }

    RetrievedData(DelegateRetrievedData prePopulatedDelegate) {
        if (prePopulatedDelegate != null) {
            this.delegate = prePopulatedDelegate;
        }
    }

    DelegateRetrievedData getDelegate() {
        return this.delegate;
    }

    public byte[] getData() {
        return this.delegate.getDataAsBytes();
    }

    public String getStringData() {
        try {
            return new String(this.delegate.getDataAsBytes(), localCCSID);
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.delegate.getDataAsString());
        }
    }

    public String getTransId() {
        return this.delegate.getTransId();
    }

    public String getTermId() {
        return this.delegate.getTermId();
    }

    public byte[] getQueue() {
        return this.delegate.getQueueNameAsBytes();
    }

    public String getStringQueue() {
        try {
            return new String(this.delegate.getQueueNameAsBytes(), localCCSID);
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.delegate.getQueueNameAsString());
        }
    }

    public void setValue(byte[] bytes) {
        this.delegate.setData(bytes);
    }

    public void setQueueName(byte[] newQueueName) {
        this.delegate.setQueueName(newQueueName);
    }

    public void setTermid(String newTermId) {
        this.delegate.setTermId(newTermId);
    }

    public void setTransid(String newTransId) {
        this.delegate.setTransId(newTransId);
    }
}

