/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.web.DelegateSoapFaultEditor;
import com.ibm.cics.server.CCSIDErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.internal.JCICSLateBinding;

public class SoapFault {
    public static final int SENDER = 1045;
    public static final int RECEIVER = 1046;
    public static final int CLIENT = 1122;
    public static final int SERVER = 1123;
    private static final int ZERO_FAULTCODE = 0;
    private static final String EMPTY_FAULTCODE_STRING = "";
    private static final String EMPTY_NATIONAL_LANGUAGE = "";
    private static final String EMPTY_FAULT_ACTOR = "";
    private static final String EMPTY_ROLE = "";
    private static final String EMPTY_DETAIL = "";

    public static void create(int faultCode, String faultString, String nationalLanguage, String faultActor, String role, String detail) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        DelegateSoapFaultEditor delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateSoapFault();
        try {
            delegate.create(faultCode, "", faultString, nationalLanguage, faultActor, role, detail);
        }
        catch (DelegateError err) {
            SoapFault.processCreateFailure(err);
        }
    }

    public static void create(int faultCode, String faultString, String nationalLanguage, String detail) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        SoapFault.create(faultCode, faultString, nationalLanguage, "", "", detail);
    }

    public static void create(int faultCode, String faultString, String detail) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        SoapFault.create(faultCode, faultString, "", "", "", detail);
    }

    public static void create(int faultCode, String faultString) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        SoapFault.create(faultCode, faultString, "", "", "", "");
    }

    public static void create(String faultCodeString, String faultString, String nationalLanguage, String faultActor, String role, String detail) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        DelegateSoapFaultEditor delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateSoapFault();
        try {
            delegate.create(0, faultCodeString, faultString, nationalLanguage, faultActor, role, detail);
        }
        catch (DelegateError err) {
            SoapFault.processCreateFailure(err);
        }
    }

    public static void addFaultstring(String faultstring, String natlang) throws RecordNotFoundException, InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        DelegateSoapFaultEditor delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateSoapFault();
        try {
            delegate.addFaultstring(faultstring, natlang);
        }
        catch (DelegateError err) {
            SoapFault.processAddSubCodeAndAddFaultStringFailure(err);
        }
    }

    public static void addSubcode(String subcode) throws RecordNotFoundException, InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        DelegateSoapFaultEditor delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateSoapFault();
        try {
            delegate.addSubcode(subcode);
        }
        catch (DelegateError err) {
            SoapFault.processAddSubCodeAndAddFaultStringFailure(err);
        }
    }

    public static void delete() throws RecordNotFoundException {
        JCICSLateBinding.bindTaskIfRequired();
        DelegateSoapFaultEditor delegate = DelegateFactoryLoader.getDelegateFactory().createDelegateSoapFault();
        try {
            delegate.delete();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage());
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    private static void processCreateFailure(DelegateError err) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case CCSID_ERROR: {
                throw new CCSIDErrorException(err.getMessage(), err.getResp2(), err);
            }
            case LENGTH_ERROR: {
                throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }

    private static void processAddSubCodeAndAddFaultStringFailure(DelegateError err) throws InvalidRequestException, CCSIDErrorException, LengthErrorException, RecordNotFoundException {
        switch (err.getCode()) {
            case INVALID_REQUEST: {
                throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case CCSID_ERROR: {
                throw new CCSIDErrorException(err.getMessage(), err.getResp2(), err);
            }
            case LENGTH_ERROR: {
                throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
            }
            case RECORD_NOT_FOUND: {
                throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
            }
        }
        DelegateErrorHandler.handleUncheckedError(err);
    }
}

