/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

public enum StartCode {
    DPL_NO_SYNCONRETURN("D"),
    DPL_SYNCONRETURN("DS"),
    TRANSIENT_DATA_TRIGGERED("QD"),
    START_COMMAND_WITHOUT_DATA("S"),
    START_COMMAND_WITH_DATA("SD"),
    FEPI_START_COMMAND("SZ"),
    TERMINAL_INPUT("TD"),
    USER_ATTACHED("U");

    private final String reason;

    private StartCode(String reason) {
        this.reason = reason;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.name());
        str.append("('");
        str.append(this.reason);
        str.append("')");
        return str.toString();
    }

    public static StartCode fromShortCode(String shortStartCode) {
        StartCode result = null;
        if (shortStartCode == null) {
            throw new IllegalArgumentException("Unexpected null start code string value");
        }
        String trimmedShortStartCode = shortStartCode.trim();
        for (StartCode code : StartCode.values()) {
            if (!code.reason.equals(trimmedShortStartCode)) continue;
            result = code;
        }
        if (result == null) {
            throw new IllegalArgumentException("Unexpected start code string value '" + shortStartCode + "'");
        }
        return result;
    }

    public String getShortCode() {
        return this.reason;
    }
}

