/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.delegate.DelegateError;
import com.ibm.cics.delegate.DelegateFactoryLoader;
import com.ibm.cics.delegate.resource.DelegateResource;
import com.ibm.cics.delegate.resource.execution.DelegateStartRequest;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.DelegateErrorHandler;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.InvalidTransactionIdException;
import com.ibm.cics.server.InvalidUserIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.RemotableResource;
import com.ibm.cics.server.TerminalException;
import java.util.Calendar;

public class StartRequest
extends RemotableResource {
    static final int START_OK = 0;
    static final int INTERVAL_ERROR = 1;
    static final int REQID_ERROR = 2;
    static final int RTRANSID_ERROR = 3;
    static final int RTERMINAL_ERROR = 4;
    static final int QUEUE_ERROR = 5;
    static final int NOCHECK_ERROR = 6;
    static final int PROTECT_ERROR = 7;
    static final long serialVersionUID = 3500682743308421323L;

    public StartRequest() {
        super((DelegateResource)DelegateFactoryLoader.getDelegateFactory().createDelegateStartRequest());
    }

    public void cancel() throws InvalidRequestException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, InvalidSystemIdException {
        try {
            ((DelegateStartRequest)this.getDelegate()).cancel();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case RECORD_NOT_FOUND: {
                    throw new RecordNotFoundException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    public void setTransId(String transId) {
        ((DelegateStartRequest)this.getDelegate()).setTransId(transId);
    }

    public byte[] getID() {
        return ((DelegateStartRequest)this.getDelegate()).getID();
    }

    public String getIDAsString() {
        return ((DelegateStartRequest)this.getDelegate()).getIDAsString();
    }

    public byte[] getQueueName() {
        return ((DelegateStartRequest)this.getDelegate()).getQueueName();
    }

    public String getQueueNameAsString() {
        return ((DelegateStartRequest)this.getDelegate()).getQueueNameAsString();
    }

    public String getRTerminal() {
        return ((DelegateStartRequest)this.getDelegate()).getRTerminal();
    }

    public String getRTransaction() {
        return ((DelegateStartRequest)this.getDelegate()).getRTransaction();
    }

    public String getTerminal() {
        return ((DelegateStartRequest)this.getDelegate()).getTerminal();
    }

    public Calendar getTime() {
        return ((DelegateStartRequest)this.getDelegate()).getTime();
    }

    public String getUserId() {
        return ((DelegateStartRequest)this.getDelegate()).getUserId();
    }

    public String getTransId() {
        return ((DelegateStartRequest)this.getDelegate()).getTransId();
    }

    public boolean isChecked() {
        return ((DelegateStartRequest)this.getDelegate()).isChecked();
    }

    public boolean isProtected() {
        return ((DelegateStartRequest)this.getDelegate()).isProtected();
    }

    public void issue() throws InvalidRequestException, ISCInvalidRequestException, IOErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException, TerminalException, InvalidTransactionIdException, InvalidUserIdException {
        try {
            ((DelegateStartRequest)this.getDelegate()).issue();
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_TRANSACTION_ID: {
                    throw new InvalidTransactionIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_USER_ID: {
                    throw new InvalidUserIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    public void issue(byte[] data) throws InvalidRequestException, ISCInvalidRequestException, IOErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException, TerminalException, InvalidTransactionIdException, InvalidUserIdException {
        try {
            ((DelegateStartRequest)this.getDelegate()).issue(data);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_TRANSACTION_ID: {
                    throw new InvalidTransactionIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_USER_ID: {
                    throw new InvalidUserIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    public void issue(Channel chan) throws InvalidRequestException, ISCInvalidRequestException, IOErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException, TerminalException, InvalidTransactionIdException, InvalidUserIdException, ChannelErrorException {
        try {
            String channelName = null;
            if (chan != null) {
                channelName = chan.getName();
            }
            ((DelegateStartRequest)this.getDelegate()).issue(channelName);
        }
        catch (DelegateError err) {
            switch (err.getCode()) {
                case INVALID_REQUEST: {
                    throw new InvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case ISC_INVALID_REQUEST: {
                    throw new ISCInvalidRequestException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case NOT_AUTHORISED: {
                    throw new NotAuthorisedException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_SYSTEM_ID: {
                    throw new InvalidSystemIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case IO_ERROR: {
                    throw new IOErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case LENGTH_ERROR: {
                    throw new LengthErrorException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case TERMINAL: {
                    throw new TerminalException(err.getMessage(), err.getResp2(), err);
                }
                case INVALID_TRANSACTION_ID: {
                    throw new InvalidTransactionIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
                case INVALID_USER_ID: {
                    throw new InvalidUserIdException(err.getMessage(), err.getResp2(), err.getResponseCode(), (Throwable)err);
                }
            }
            DelegateErrorHandler.handleUncheckedError(err);
        }
    }

    public void setChecked(boolean checked) {
        ((DelegateStartRequest)this.getDelegate()).setChecked(checked);
    }

    public void setID(byte[] id) {
        ((DelegateStartRequest)this.getDelegate()).setID(id);
    }

    public void setIDFromString(String id) {
        ((DelegateStartRequest)this.getDelegate()).setIDFromString(id);
    }

    public void setProtected(boolean isProtected) {
        ((DelegateStartRequest)this.getDelegate()).setProtected(isProtected);
    }

    public void setQueueName(byte[] queueName) throws NullPointerException {
        ((DelegateStartRequest)this.getDelegate()).setQueueName(queueName);
    }

    public void setQueueNameFromString(String name) throws NullPointerException {
        ((DelegateStartRequest)this.getDelegate()).setQueueNameFromString(name);
    }

    public void setRTerminal(String rTerminal) {
        ((DelegateStartRequest)this.getDelegate()).setRTerminal(rTerminal);
    }

    public void setRTransaction(String rTransaction) {
        ((DelegateStartRequest)this.getDelegate()).setRTransaction(rTransaction);
    }

    public void setTerminal(String terminal) {
        ((DelegateStartRequest)this.getDelegate()).setTerminal(terminal);
    }

    public void setTime(Calendar calendar) {
        ((DelegateStartRequest)this.getDelegate()).setTime(calendar);
    }

    public void setUserId(String userId) {
        ((DelegateStartRequest)this.getDelegate()).setUserId(userId);
    }

    public void resetRequestData() {
        ((DelegateStartRequest)this.getDelegate()).resetRequestData();
    }
}

